/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.tools.planexporter;

import com.gemstone.gemfire.LogWriter;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.PublicAPI;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedResultSet;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.jdbc.InternalDriver;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import com.pivotal.gemfirexd.tools.planexporter.TreeNode;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Properties;

public final class AccessDistributedSystem {
    public final EmbedConnection conn;
    private final LanguageConnectionContext lcc;
    private final String schema;
    private final String queryID;
    private final String userQueryStr;
    private final boolean schemaExists;
    private boolean isLocal = true;
    private boolean isDerbyActivation = false;
    private TreeNode[] data;
    private String xmlPlanFragment;
    private LogWriter logger = null;
    private int depth = 0;
    private String xmlDetails = "";
    private static final int ID = 0;
    private static final int P_ID = 1;
    private static final int NODE_TYPE = 2;
    private static final int NO_OF_OPENS = 3;
    private static final int INPUT_ROWS = 4;
    private static final int RETURNED_ROWS = 5;
    private static final int VISITED_PAGES = 6;
    private static final int SCAN_QUALIFIERS = 7;
    private static final int NEXT_QUALIFIERS = 8;
    private static final int SCANNED_OBJECT = 9;
    private static final int SCAN_TYPE = 10;
    private static final int SORT_TYPE = 11;
    private static final int NO_OF_OUTPUT_ROWS_BY_SORTER = 12;
    private static final int EXEC_TIME = 13;
    private static final int MEMBER_NODE = 14;
    private static final int PERCENT_EXEC_TIME = 15;
    private static final int NODE_DETAILS = 16;
    private static final int RANK = 17;

    public String getQueryID() {
        return this.queryID;
    }

    public String getUserQueryStr() {
        return this.userQueryStr;
    }

    public int getDepth() {
        return this.depth;
    }

    public AccessDistributedSystem getClone(String stmtUUID) throws SQLException {
        return new AccessDistributedSystem(this.conn, this.schema, stmtUUID, null);
    }

    public AccessDistributedSystem(String dburl, Properties props, String aSchema, String aQuery, ArrayList<ArrayList<Object>> queryParameters) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        this(AccessDistributedSystem.createConnection(dburl, props), aSchema, aQuery, queryParameters);
    }

    public AccessDistributedSystem(EmbedConnection conn, String aQuery, ArrayList<ArrayList<Object>> queryParameters) throws SQLException {
        this(AccessDistributedSystem.createConnection(conn), null, aQuery, queryParameters);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AccessDistributedSystem(EmbedConnection aConn, String aSchema, String aQuery, ArrayList<ArrayList<Object>> queryParameters) throws SQLException {
        this.conn = aConn;
        this.lcc = this.conn.getLanguageConnection();
        this.logger = Misc.getCacheLogWriter();
        boolean runtimeOnOff = this.lcc != null ? this.lcc.getRunTimeStatisticsMode() : false;
        try {
            ResultSet rs;
            if (this.lcc != null) {
                this.lcc.setRunTimeStatisticsMode(false, true);
            }
            if (aSchema == null) {
                rs = this.conn.createStatement().executeQuery("values CURRENT SCHEMA");
                if (!rs.next()) {
                    throw GemFireXDRuntimeException.newRuntimeException("Current schema couldn't be determined ", null);
                }
                aSchema = rs.getString(1);
                rs.close();
            }
            this.schema = aSchema;
            this.schemaExists = this.schemaExists();
            if (this.schemaExists) {
                this.setSchema();
            }
            if (aQuery.matches("PREVIOUS")) {
                this.userQueryStr = null;
                rs = this.conn.createStatement().executeQuery("SELECT STMT_ID FROM SYS.STATEMENTPLANS ORDER BY XPLAIN_TIME DESC");
                if (!rs.next()) {
                    throw GemFireXDRuntimeException.newRuntimeException("Previous statement to explain couldn't be determined ", null);
                }
                this.queryID = rs.getString(1);
                rs.close();
            } else {
                String type = XPLAINUtil.getStatementType(aQuery);
                if (type == null || type.length() <= 0) {
                    this.userQueryStr = null;
                    this.queryID = aQuery.trim();
                    assert (this.queryID.length() == 36 && this.queryID.split("-").length == 5) : "Wrong UUID=" + this.queryID;
                } else {
                    this.userQueryStr = aQuery;
                    this.queryID = this.recordExecutionPlan(type, aQuery, queryParameters);
                }
            }
        }
        finally {
            if (this.lcc != null) {
                this.lcc.setRunTimeStatisticsMode(runtimeOnOff, true);
            }
        }
    }

    public boolean setRuntimeStatisticsMode(boolean onOrOff) {
        boolean currentstate = this.lcc.getRunTimeStatisticsMode();
        this.lcc.setRunTimeStatisticsMode(onOrOff, true);
        return currentstate;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String recordExecutionPlan(String type, String aQuery, ArrayList<ArrayList<Object>> queryParameters) throws SQLException {
        if (type == "DDL") {
            throw GemFireXDRuntimeException.newRuntimeException("DDLs cannot be profiled", null);
        }
        String stUUID = null;
        try {
            this.prepareExecution();
            if (type == "SA" || type == "S") {
                ResultSet rs;
                if (queryParameters != null) {
                    if (queryParameters.size() > 1) {
                        throw PublicAPI.wrapStandardException(StandardException.newException("42Z10", queryParameters));
                    }
                    PreparedStatement ps = this.conn.prepareStatement(aQuery);
                    this.setParameters(ps, queryParameters);
                    rs = ps.executeQuery();
                } else {
                    rs = this.conn.createStatement().executeQuery(aQuery);
                }
                ResultSetMetaData rsMD = rs.getMetaData();
                int numCols22 = rsMD.getColumnCount();
                int rowCount = 0;
                while (rs.next()) {
                    StringBuilder row = new StringBuilder();
                    ++rowCount;
                    for (int index = 1; index <= numCols22; ++index) {
                        String colName = rsMD.getColumnName(index);
                        Object value = rs.getObject(index);
                        row.append(colName).append("=").append(value);
                    }
                    if (!GemFireXDUtils.TracePlanGeneration) continue;
                    SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("Retrieved row " + rowCount + " as " + row.toString()));
                }
                rs.close();
                assert (rs instanceof EmbedResultSet);
                com.pivotal.gemfirexd.internal.iapi.sql.ResultSet iapiResultSet = ((EmbedResultSet)rs).getSourceResultSet();
                this.isDerbyActivation = !(iapiResultSet instanceof AbstractGemFireResultSet);
                String numCols22 = iapiResultSet.getExecutionPlanID().toString();
                return numCols22;
            }
            if (type == "I" || type == "U" || type == "D" || type == "C") {
                String iapiResultSet;
                EmbedStatement est = (EmbedStatement)this.conn.createStatement();
                try {
                    est.execute(aQuery);
                    iapiResultSet = est.getResultsToWrap().getExecutionPlanID().toString();
                }
                catch (Throwable throwable) {
                    est.close();
                    throw throwable;
                }
                est.close();
                return iapiResultSet;
            }
        }
        finally {
            this.clear();
        }
        ResultSet st_id = this.conn.createStatement().executeQuery("select STMT_ID, ORIGIN_MEMBER_ID from sys.statementPlans ");
        if (!st_id.next()) {
            st_id.close();
            ResultSet plans = this.conn.createStatement().executeQuery("select STMT_ID, ORIGIN_MEMBER_ID from sys.statementPlans ");
            StringBuilder sb = new StringBuilder("Profile information missing for the statement: ").append(aQuery);
            sb.append("Statement Plans captured in thes system: \n");
            this.reportError(sb, plans);
            throw GemFireXDRuntimeException.newRuntimeException(sb.toString(), null);
        }
        stUUID = st_id.getString(1).trim();
        String originated = st_id.getString(2);
        while (st_id.next()) {
            if (stUUID.equalsIgnoreCase(st_id.getString(1).trim())) continue;
            StringBuilder sb = new StringBuilder();
            sb.append("Multiple statement id found... do explicit query on sys.statementPlans & provide statement UUID \n");
            sb.append("stid=").append(stUUID).append(" originated=").append(originated).append("\n");
            sb.append("stid=").append(st_id.getString(1)).append(" originated=").append(st_id.getString(2)).append("\n");
            this.reportError(sb, st_id);
            throw GemFireXDRuntimeException.newRuntimeException(sb.toString(), null);
        }
        st_id.close();
        return stUUID;
    }

    private void setParameters(PreparedStatement ps, ArrayList<ArrayList<Object>> queryParameters) throws SQLException {
        for (ArrayList<Object> v : queryParameters) {
            int i = 1;
            for (Object o : v) {
                ps.setObject(i++, o);
            }
        }
    }

    private StringBuilder reportError(StringBuilder sb, ResultSet r) throws SQLException {
        while (r.next()) {
            sb.append("stid=").append(r.getString(1)).append(" originated=").append(r.getString(2)).append("\n");
        }
        r.close();
        return sb;
    }

    private void prepareExecution() throws SQLException {
        boolean current = this.conn.getAutoCommit();
        this.conn.setAutoCommit(false);
        Statement st = this.conn.createStatement();
        try {
            st.execute("call syscs_util.set_explain_connection(1)");
            st.execute("call syscs_util.set_statistics_timing(1)");
        }
        finally {
            st.close();
            this.conn.setAutoCommit(current);
        }
    }

    private void clear() {
        this.lcc.setStatsEnabled(this.lcc.statsEnabled(), this.lcc.timeStatsEnabled(), false);
    }

    private static EmbedConnection createConnection(EmbedConnection conn) throws SQLException {
        Connection nestedconn;
        InternalDriver id = conn.getLocalDriver();
        if (id != null && (nestedconn = id.getNewNestedConnection(conn)) != null) {
            assert (nestedconn instanceof EmbedConnection);
            return (EmbedConnection)nestedconn;
        }
        throw Util.noCurrentConnection();
    }

    private static EmbedConnection createConnection(String dbURL, Properties props) throws InstantiationException, IllegalAccessException, ClassNotFoundException, SQLException {
        if (dbURL.indexOf("://") != -1) {
            throw GemFireXDRuntimeException.newRuntimeException("Client driver is unsupported by this utility ... ", null);
        }
        Class.forName("io.snappydata.jdbc.EmbeddedDriver").newInstance();
        return (EmbedConnection)DriverManager.getConnection(dbURL, props);
    }

    private void setSchema() throws SQLException {
        PreparedStatement setSchema = this.conn.prepareStatementByPassQueryInfo(-1L, "SET SCHEMA ?", false, false, false, null, 0L, 0);
        setSchema.setString(1, this.schema);
        setSchema.execute();
        setSchema.close();
    }

    private boolean schemaExists() throws SQLException {
        boolean found = false;
        ResultSet result = this.conn.getMetaData().getSchemas();
        while (result.next()) {
            boolean schemaMatches = System.getProperty("metadatacase.lower", "false").equalsIgnoreCase("true") && this.lcc.isQueryRoutingFlagTrue() ? result.getString(1).equalsIgnoreCase(this.schema) : result.getString(1).equals(this.schema);
            if (!schemaMatches) continue;
            found = true;
            break;
        }
        result.close();
        return found;
    }

    public boolean verifySchemaExistance() {
        return this.schemaExists;
    }

    public void createXMLFragment() throws SQLException {
        String qry = "select PLAN_XML_FRAGMENT from SYSSTAT.SYSXPLAIN_RESULTSETS where STMT_ID = ?";
        PreparedStatement ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select PLAN_XML_FRAGMENT from SYSSTAT.SYSXPLAIN_RESULTSETS where STMT_ID = ?", false, false, false, null, 0L, 0);
        ps.setString(1, this.getQueryID());
        ResultSet r = ps.executeQuery();
        if (r.next()) {
            this.xmlPlanFragment = r.getString(1);
        }
        if (GemFireXDUtils.TracePlanAssertion) {
            ArrayList<String> morePlans = new ArrayList<String>();
            int plans = 0;
            while (r.next()) {
                ++plans;
                morePlans.add(r.getString(1));
            }
            if (plans > 0) {
                for (String p : morePlans) {
                    SanityManager.DEBUG_PRINT((String)"TracePlanAssertion", (String)("Extra Plans: " + p));
                }
                SanityManager.THROWASSERT((String)(plans + " plans detected expected only one plan"));
            }
        }
        r.close();
        ps.close();
    }

    public String getXmlString() {
        return this.xmlPlanFragment;
    }

    public String indent(int j) {
        String str = "";
        for (int i = 0; i <= j + 1; ++i) {
            str = str + "    ";
        }
        return str;
    }

    public void markTheDepth() {
        int i = 0;
        while (this.data[i].getParent().indexOf("null") == -1) {
            ++i;
        }
        this.data[i].setDepth(this.depth);
        this.findChildren(i, this.depth);
    }

    public void markRemote() {
        this.isLocal = false;
    }

    public boolean isRemote() {
        return !this.isLocal;
    }

    public boolean isDerbyActivation() {
        return this.isDerbyActivation;
    }

    private void findChildren(int idx, int dep) {
        if (dep > this.depth) {
            this.depth = dep;
        }
        for (int i = 0; i < this.data.length; ++i) {
            if (this.data[i].getParent().indexOf("null") != -1 || this.data[idx].getId().indexOf(this.data[i].getParent()) == -1 || i == idx) continue;
            this.data[i].setDepth(dep + 1);
            this.findChildren(i, dep + 1);
        }
    }

    public boolean initializeDataArray() throws SQLException {
        if (this.noOfNodes() == 0) {
            return false;
        }
        this.data = new TreeNode[this.noOfNodes()];
        for (int i = 0; i < this.data.length; ++i) {
            this.data[i] = new TreeNode();
        }
        return true;
    }

    private int noOfNodes() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select count(*) from SYSSTAT.SYSXPLAIN_RESULTSETS where STMT_ID = ?", false, false, false, null, 0L, 0);
        ps.setString(1, this.getQueryID());
        ResultSet results = ps.executeQuery();
        results.next();
        int no = results.getInt(1);
        results.close();
        ps.close();
        if (GemFireXDUtils.TracePlanGeneration) {
            SanityManager.DEBUG_PRINT((String)"TracePlanGeneration", (String)("SYSSTAT.SYSXPLAIN_resultsets contain " + no + " rows for " + this.getQueryID()));
            if (!this.isRemote()) {
                this.dumpXPLAINResultSets(no == 0 ? "" : " where stmt_id='" + this.getQueryID() + "'");
            }
        }
        return no;
    }

    private void dumpXPLAINResultSets(String condition) throws SQLException {
        StringBuilder sb = new StringBuilder("----------- Dumping SYSSTAT.SYSXPLAIN_RESULTSETS ---------- \n");
        PreparedStatement ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select stmt_id , plan_xml_fragment from SYSSTAT.SYSXPLAIN_RESULTSETS " + condition, false, false, false, null, 0L, 0);
        ResultSet results = ps.executeQuery();
        int rowNum = 0;
        while (results.next()) {
            sb.append(++rowNum).append(" ").append(results.getString(1)).append(" ").append(results.getString(2)).append("\n");
        }
        SanityManager.DEBUG_PRINT((String)"dump:TracePlanGeneration", (String)sb.toString());
        results.close();
        ps.close();
    }

    public String statement() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select STMT_TEXT from SYSSTAT.SYSXPLAIN_STATEMENTS where STMT_ID = ?", false, false, false, null, 0L, 0);
        ps.setString(1, this.getQueryID());
        ResultSet results = ps.executeQuery();
        results.next();
        String statement = results.getString(1);
        results.close();
        ps.close();
        statement = AccessDistributedSystem.escapeForXML(statement);
        return "<statement>" + statement + "</statement>\n";
    }

    public String member() {
        return this.isLocal ? "" : "<member>" + AccessDistributedSystem.escapeForXML(Misc.getGemFireCache().getDistributedSystem().getDistributedMember().getId()) + "</member>";
    }

    private static String escapeForXML(String text) {
        StringBuilder sb = new StringBuilder();
        block7: for (int i = 0; i < text.length(); ++i) {
            char ch = text.charAt(i);
            switch (ch) {
                case '&': {
                    sb.append("&amp;");
                    continue block7;
                }
                case '<': {
                    sb.append("&lt;");
                    continue block7;
                }
                case '>': {
                    sb.append("&gt;");
                    continue block7;
                }
                case '\'': {
                    sb.append("&apos;");
                    continue block7;
                }
                case '\"': {
                    sb.append("&quot;");
                    continue block7;
                }
                default: {
                    sb.append(ch);
                }
            }
        }
        return sb.toString();
    }

    private String escapeInAttribute(String text) {
        if (text.indexOf(34) == -1) {
            return text;
        }
        String correctXMLString = AccessDistributedSystem.escapeForXML(text.substring(text.indexOf(34) + 1, text.length() - 1));
        return text.substring(0, text.indexOf(34) + 1) + correctXMLString + "\"";
    }

    public String time() throws SQLException {
        PreparedStatement ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select '<time>'||TRIM(CHAR(XPLAIN_TIME))||'</time>' from SYSSTAT.SYSXPLAIN_STATEMENTS where STMT_ID = ?", false, false, false, null, 0L, 0);
        ps.setString(1, this.getQueryID());
        ResultSet results = ps.executeQuery();
        results.next();
        String time = results.getString(1);
        results.close();
        ps.close();
        return time + "\n";
    }

    public String begin_end_exe_time() throws SQLException {
        String timeDiffFn = "TRIM(CHAR(END_EXE_TIME_L - BEGIN_EXE_TIME_L))";
        PreparedStatement ps = this.conn.prepareStatementByPassQueryInfo(-1L, "select '<begin_exe_time>'||TRIM(CHAR(BEGIN_EXE_TIME))||'</begin_exe_time>'||'\n'||'<end_exe_time>'||TRIM(CHAR(END_EXE_TIME))||'</end_exe_time>'||'\n'||'<elapsed_time>'||TRIM(CHAR(END_EXE_TIME_L - BEGIN_EXE_TIME_L))||'</elapsed_time>'  from (SYSSTAT.SYSXPLAIN_STATEMENTS b) where STMT_ID = ?", false, false, false, null, 0L, 0);
        ps.setString(1, this.getQueryID());
        ResultSet results = ps.executeQuery();
        results.next();
        String time = results.getString(1);
        results.close();
        ps.close();
        return time + "\n";
    }

    public String stmt_id() {
        return this.isLocal ? "<stmt_id>" + this.getQueryID() + "</stmt_id>\n" : "";
    }

    public void closeConnection() {
        try {
            if (this.conn != null) {
                this.conn.close();
            }
        }
        catch (SQLException sQLException) {
            // empty catch block
        }
    }

    public LanguageConnectionContext getLanguageConnectionContext() {
        return this.lcc;
    }

    public LogWriter logger() {
        return this.logger;
    }

    public TreeNode[] getData() {
        return this.data;
    }

    public static boolean isMessagingEntry(String n) {
        return "QUERY-SCATTER".equals(n) || "QUERY-SEND".equals(n) || "QUERY-RECEIVE".equals(n) || "RESULT-SEND".equals(n) || "RESULT-RECEIVE".equals(n) || "RESULT-HOLDER".equals(n);
    }
}

