/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.utils;

import com.gemstone.gemfire.internal.cache.DiskStoreImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.comparators.RegionViewSortComparator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.comparators.ServerNameComparator;
import com.pivotal.gemfirexd.internal.tools.dataextractor.diskstore.GFXDDiskStoreImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.domain.ServerInfo;
import com.pivotal.gemfirexd.internal.tools.dataextractor.extractor.GemFireXDDataExtractorImpl;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.PersistentView;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import java.io.File;
import java.io.FilenameFilter;
import java.io.IOException;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.sql.Connection;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Scanner;
import org.apache.commons.io.FileSystemUtils;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;

public final class ExtractorUtils {
    private static final String LOCK_FILE_EXTENSION = ".lk";
    private static final String CRF_EXTENSION = ".crf";
    private static final String KRF_EXTENSION = ".krf";
    private static final String IF_EXTENSION = ".if";
    private static final String DRF_EXTENSION = ".drf";
    private static final String INDEX_KRF_EXTENSION = ".idxkrf";
    static ExtensionFilter extensionFilter = new ExtensionFilter();

    public static List<List<GFXDSnapshotExportStat>> rankAndGroupDdlStats(Map<ServerInfo, List<GFXDSnapshotExportStat>> hostToDdlMap) {
        PersistentView pv = PersistentView.getPersistentViewForDdlStats(hostToDdlMap);
        ArrayList<GFXDSnapshotExportStat> ddlStats = new ArrayList<GFXDSnapshotExportStat>();
        for (Map.Entry<ServerInfo, List<GFXDSnapshotExportStat>> entry : hostToDdlMap.entrySet()) {
            ServerInfo member = entry.getKey();
            List<GFXDSnapshotExportStat> statList = entry.getValue();
            GFXDSnapshotExportStat stat = statList.get(0);
            stat.setServerName(member.getServerName());
            ddlStats.add(stat);
        }
        ServerNameComparator serverNameComparator = new ServerNameComparator();
        RegionViewSortComparator rvSortComparator = new RegionViewSortComparator(serverNameComparator);
        Collections.sort(ddlStats, rvSortComparator);
        return ExtractorUtils.groupByContent(ddlStats);
    }

    public static List<List<GFXDSnapshotExportStat>> groupByContent(List<GFXDSnapshotExportStat> rankedDdlStats) {
        int length = rankedDdlStats.size();
        int i = 0;
        ArrayList<List<GFXDSnapshotExportStat>> rankedAndGroupedDdlStats = new ArrayList<List<GFXDSnapshotExportStat>>();
        while (i < length) {
            GFXDSnapshotExportStat stat2;
            int j;
            GFXDSnapshotExportStat stat1 = rankedDdlStats.get(i);
            ArrayList<GFXDSnapshotExportStat> statGroup = new ArrayList<GFXDSnapshotExportStat>();
            statGroup.add(stat1);
            for (j = i + 1; j < length && ExtractorUtils.isDDLFileSame(stat1, stat2 = rankedDdlStats.get(j)); ++j) {
                statGroup.add(stat2);
            }
            i = j;
            rankedAndGroupedDdlStats.add(statGroup);
        }
        return rankedAndGroupedDdlStats;
    }

    public static boolean isDDLFileSame(GFXDSnapshotExportStat stat1, GFXDSnapshotExportStat stat2) {
        File ddlFile1 = new File(stat1.getFileName());
        File ddlFile2 = new File(stat2.getFileName());
        try {
            return FileUtils.contentEquals((File)ddlFile1, (File)ddlFile2);
        }
        catch (Exception e) {
            GemFireXDDataExtractorImpl.logInfo("Exception occurred while comparing the DDL", e);
            return false;
        }
    }

    public static List<String> readSqlStatements(String ddlFilePath) throws IOException {
        List lines = FileUtils.readLines((File)new File(ddlFilePath));
        ArrayList<String> ddlStatements = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (String line : lines) {
            if ((line = line.trim()).startsWith("--")) continue;
            int scIndex = line.indexOf(";");
            int commentStartIndex = line.indexOf("--");
            if (commentStartIndex != -1) {
                line = line.substring(0, commentStartIndex);
            }
            if (scIndex != -1) {
                line = line.substring(0, scIndex);
                sb.append(line);
                ddlStatements.add(sb.toString());
                sb = new StringBuilder();
                continue;
            }
            sb.append(line).append(" ");
        }
        return ddlStatements;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void executeDdlFromSqlFile(Connection conn, List<String> ddlStatements) throws IOException, SQLException {
        try (Statement statement = null;){
            statement = conn.createStatement();
            for (String ddlStatement : ddlStatements) {
                if (ddlStatement.startsWith("--")) continue;
                try {
                    statement.execute(ddlStatement);
                }
                catch (Exception e) {
                    GemFireXDDataExtractorImpl.logSevere("Exception occurred while executing : " + ddlStatement, e, GemFireXDDataExtractorImpl.getReportableErrors());
                }
            }
        }
    }

    public static void cleanWorkingDirectory() {
        try {
            File workingDirectory = new File(System.getProperty("user.dir"));
            ExtractorUtils.cleanFiles(workingDirectory, extensionFilter);
            File ddDir = new File(workingDirectory, "datadictionary");
            if (ddDir.exists() && ddDir.isDirectory()) {
                FileUtils.deleteDirectory((File)ddDir);
            }
        }
        catch (Exception e) {
            GemFireXDDataExtractorImpl.logInfo("Error occured while cleaning the working directory", e);
        }
    }

    private static void cleanFiles(File dir, ExtensionFilter filter) {
        File[] files = dir.listFiles(filter);
        if (files != null && files.length > 0) {
            for (File file : files) {
                try {
                    FileUtils.forceDelete((File)file);
                }
                catch (IOException e) {
                    GemFireXDDataExtractorImpl.logInfo("Error occured while cleaning up the files", e);
                }
            }
        }
    }

    public static void cleanDiskStores(List<DiskStoreImpl> diskStores, boolean deleteDiskStoreFiles) {
        for (DiskStoreImpl diskStore : diskStores) {
            ExtractorUtils.cleanDiskStore(diskStore, deleteDiskStoreFiles);
        }
    }

    private static void cleanDiskStore(DiskStoreImpl diskStore, boolean deleteDiskStoreFiles) {
        GFXDDiskStoreImpl.closeDiskStoreFiles(diskStore);
        if (deleteDiskStoreFiles) {
            File[] diskDirs;
            for (File diskDir : diskDirs = diskStore.getDiskDirs()) {
                if (!diskDir.exists()) continue;
                ExtractorUtils.cleanFiles(diskDir, extensionFilter);
            }
        }
    }

    public static boolean checkDiskSpaceInTargetDirectory(Map<String, ServerInfo> serverInfoMap, String targetDirectory) throws IOException {
        long totalDiskDirSize = ExtractorUtils.getTotalSize(serverInfoMap);
        long totalSpaceAvailable = FileSystemUtils.freeSpaceKb((String)targetDirectory);
        GemFireXDDataExtractorImpl.logInfo("Total size of data to be extracted : " + (double)totalDiskDirSize / 1024.0 + "MB");
        GemFireXDDataExtractorImpl.logInfo("Disk space available in the output directory : " + (double)totalSpaceAvailable / 1024.0 + "MB");
        if (totalSpaceAvailable < totalDiskDirSize) {
            if ("n".equalsIgnoreCase(ExtractorUtils.getUserInput())) {
                return false;
            }
        } else {
            GemFireXDDataExtractorImpl.logInfo("Sufficient disk space to carry out data extraction");
        }
        return true;
    }

    protected static boolean checkDiskSpaceInTargetDirectory(String targetDirectory) throws IOException {
        long totalDiskDirSize = ExtractorUtils.getTotalSize(targetDirectory);
        long totalSpaceAvailable = FileSystemUtils.freeSpaceKb((String)targetDirectory);
        GemFireXDDataExtractorImpl.logInfo("Estimated data to be extracted : " + (double)totalDiskDirSize / 1024.0 + "MB");
        GemFireXDDataExtractorImpl.logInfo("Disk space available in the output directory : " + (double)totalSpaceAvailable / 1024.0 + "MB");
        if (totalSpaceAvailable < totalDiskDirSize) {
            if ("n".equalsIgnoreCase(ExtractorUtils.getUserInput())) {
                return false;
            }
        } else {
            GemFireXDDataExtractorImpl.logInfo("Sufficient disk space to carry out data extraction");
        }
        return true;
    }

    protected static String getUserInput() {
        Scanner in;
        GemFireXDDataExtractorImpl.logInfo("Possibly insufficient disk space to carry out data extraction");
        String userInput = null;
        do {
            System.out.println("Do you wish to continue [y\n] ?");
        } while (!"y".equalsIgnoreCase(userInput = (in = new Scanner(System.in)).next()) && !"n".equalsIgnoreCase(userInput));
        return userInput;
    }

    public static int getNumberOfThreads(List<ServerInfo> serverInfoList, List<DiskStoreImpl> diskStores) {
        long maxDiskStoreSizeOnDisk = 0L;
        int maxNumberOfServersInParallel = 1;
        double mbDiv = Math.pow(1024.0, 2.0);
        for (ServerInfo serverInfo : serverInfoList) {
            long maxDiskStoreSizeForServer = ExtractorUtils.getMaxDiskStoreSizeForServer(serverInfo, diskStores);
            if (maxDiskStoreSizeOnDisk >= maxDiskStoreSizeForServer) continue;
            maxDiskStoreSizeOnDisk = maxDiskStoreSizeForServer;
        }
        GemFireXDDataExtractorImpl.logInfo("Maximum disk-store size on disk " + (double)maxDiskStoreSizeOnDisk / mbDiv + " MB");
        MemoryMXBean memBean = ManagementFactory.getMemoryMXBean();
        MemoryUsage heapMemUsage = memBean.getHeapMemoryUsage();
        long usedMemory = heapMemUsage.getUsed();
        long committedMemory = heapMemUsage.getCommitted();
        long availableMemory = committedMemory - usedMemory;
        GemFireXDDataExtractorImpl.logInfo("Available memory : " + (double)availableMemory / mbDiv + " MB");
        double maxMemoryPerServer = 1.2 * (double)maxDiskStoreSizeOnDisk;
        if (maxMemoryPerServer < 1.0) {
            maxMemoryPerServer = 1.0;
        }
        GemFireXDDataExtractorImpl.logInfo("Estimated memory needed per server : " + maxMemoryPerServer / mbDiv + " MB");
        if ((double)availableMemory < maxMemoryPerServer) {
            GemFireXDDataExtractorImpl.logWarning("Not enough memory to extract the server, extractor could possibly run out of memory");
        }
        if ((maxNumberOfServersInParallel = (int)((double)availableMemory / maxMemoryPerServer)) < 1) {
            maxNumberOfServersInParallel = 1;
        }
        GemFireXDDataExtractorImpl.logInfo("Recommended number of threads to extract server(s) in parallel : " + maxNumberOfServersInParallel);
        return maxNumberOfServersInParallel;
    }

    private static long getTotalSize(Map<String, ServerInfo> serverInfoMap) {
        long size = 0L;
        for (Map.Entry<String, ServerInfo> entry : serverInfoMap.entrySet()) {
            ServerInfo serverInfo = entry.getValue();
            List<String> diskDirPaths = serverInfo.getDiskStoreDirectories();
            for (String diskDirPath : diskDirPaths) {
                size += ExtractorUtils.getTotalSize(diskDirPath);
            }
        }
        return size;
    }

    private static long getTotalSize(String directory) {
        File diskDirFile = new File(directory);
        return FileUtils.sizeOfDirectory((File)diskDirFile) / 1024L;
    }

    public static long getMaxDiskStoreSizeInDir(List<DiskStoreImpl> diskStores, String diskStoreDirPath) {
        File diskStoreDir = new File(diskStoreDirPath);
        long maxDiskStoreSizeOnDisk = 0L;
        for (DiskStoreImpl diskStore : diskStores) {
            String[] fileNames = diskStoreDir.list(new DiskStoreNameFilter(diskStore.getName()));
            long diskStoreSize = 0L;
            if (fileNames != null && fileNames.length > 0) {
                for (String fileName : fileNames) {
                    File file = new File(FilenameUtils.concat((String)diskStoreDirPath, (String)fileName));
                    if (!file.exists()) continue;
                    diskStoreSize += FileUtils.sizeOf((File)file);
                }
            }
            if (maxDiskStoreSizeOnDisk >= diskStoreSize) continue;
            maxDiskStoreSizeOnDisk = diskStoreSize;
        }
        return maxDiskStoreSizeOnDisk;
    }

    public static long getMaxDiskStoreSizeForServer(ServerInfo serverInfo, List<DiskStoreImpl> diskStores) {
        long maxDiskStoreSizeInServer = 0L;
        List<String> diskStoreDirPaths = serverInfo.getDiskStoreDirectories();
        for (String diskStoreDirPath : diskStoreDirPaths) {
            long maxDiskStoreSizeInDir = ExtractorUtils.getMaxDiskStoreSizeInDir(diskStores, diskStoreDirPath);
            if (maxDiskStoreSizeInServer >= maxDiskStoreSizeInDir) continue;
            maxDiskStoreSizeInServer = maxDiskStoreSizeInDir;
        }
        return maxDiskStoreSizeInServer;
    }

    static {
        extensionFilter.addExtension(LOCK_FILE_EXTENSION);
        extensionFilter.addExtension(CRF_EXTENSION);
        extensionFilter.addExtension(KRF_EXTENSION);
        extensionFilter.addExtension(IF_EXTENSION);
        extensionFilter.addExtension(DRF_EXTENSION);
        extensionFilter.addExtension(INDEX_KRF_EXTENSION);
    }

    private static final class DiskStoreNameFilter
    implements FilenameFilter {
        final String diskStoreName;

        public DiskStoreNameFilter(String diskStoreName) {
            this.diskStoreName = diskStoreName;
        }

        @Override
        public boolean accept(File file, String name) {
            return name.contains(this.diskStoreName);
        }
    }

    private static final class ExtensionFilter
    implements FilenameFilter {
        public final List<String> extensionList = new ArrayList<String>();

        private ExtensionFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            boolean isMatched = false;
            for (String extention : this.extensionList) {
                if (!name.endsWith(extention)) continue;
                isMatched = true;
                break;
            }
            return isMatched;
        }

        public void addExtension(String extention) {
            this.extensionList.add(extention);
        }
    }
}

