/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.report.views;

import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.pivotal.gemfirexd.internal.tools.dataextractor.domain.ServerInfo;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionView;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerGroup;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerMember;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class PersistentView {
    Map<String, PersistentMemberID> hostToPersistentMemberId;
    Map<String, RegionView> tableToRegionViewMap;

    public String toString() {
        return String.format("PersistentView [hostToPersistentMemberId=%s, tableToRegionViewMap=%s]", this.hostToPersistentMemberId, this.tableToRegionViewMap);
    }

    public Map<String, RegionView> getTableToRegionViewMap() {
        return this.tableToRegionViewMap;
    }

    private PersistentView() {
    }

    public Map<String, PersistentMemberID> getHostToPersistentMemberId() {
        return this.hostToPersistentMemberId;
    }

    public static PersistentView getPersistentViewForDdlStats(Map<ServerInfo, List<GFXDSnapshotExportStat>> hostToDdlMap) {
        HashMap<String, List<GFXDSnapshotExportStat>> hostToDdlMap2 = new HashMap<String, List<GFXDSnapshotExportStat>>();
        for (Map.Entry<ServerInfo, List<GFXDSnapshotExportStat>> entry : hostToDdlMap.entrySet()) {
            String host = entry.getKey().getServerName();
            List<GFXDSnapshotExportStat> listOfStats = entry.getValue();
            hostToDdlMap2.put(host, listOfStats);
        }
        return PersistentView.getPersistentView(hostToDdlMap2);
    }

    public static PersistentView getPersistentView(Map<String, List<GFXDSnapshotExportStat>> hostToStatsMap) {
        PersistentView pv = new PersistentView();
        HashMap<String, ArrayList<RegionViewInfoPerMember>> regionNameToRegionViewInfoPerMemberListMap = new HashMap<String, ArrayList<RegionViewInfoPerMember>>();
        pv.hostToPersistentMemberId = new HashMap<String, PersistentMemberID>();
        for (Map.Entry<String, List<GFXDSnapshotExportStat>> entry : hostToStatsMap.entrySet()) {
            String host = entry.getKey();
            List<GFXDSnapshotExportStat> listOfStats = entry.getValue();
            for (GFXDSnapshotExportStat stat : listOfStats) {
                ArrayList<RegionViewInfoPerMember> regionViewList;
                String regionName = stat.getSchemaTableName();
                RegionViewInfoPerMember regionViewInfo = stat.getRegionViewInfo();
                PersistentMemberID pmId = pv.hostToPersistentMemberId.get(host);
                if (pmId == null) {
                    pmId = regionViewInfo.getMyId();
                    pv.hostToPersistentMemberId.put(host, pmId);
                }
                if ((regionViewList = (ArrayList<RegionViewInfoPerMember>)regionNameToRegionViewInfoPerMemberListMap.get(regionName)) == null) {
                    regionViewList = new ArrayList<RegionViewInfoPerMember>();
                }
                regionViewList.add(regionViewInfo);
                regionNameToRegionViewInfoPerMemberListMap.put(regionName, regionViewList);
            }
        }
        Set regionNames = regionNameToRegionViewInfoPerMemberListMap.keySet();
        pv.tableToRegionViewMap = new HashMap<String, RegionView>();
        for (String regionName : regionNames) {
            List regionViewInfoList = (List)regionNameToRegionViewInfoPerMemberListMap.get(regionName);
            RegionView rv = pv.getRegionView(regionViewInfoList);
            pv.tableToRegionViewMap.put(regionName, rv);
        }
        return pv;
    }

    public void setRankAndSort(List<RegionViewInfoPerMember> regionViewInfoList) {
        for (RegionViewInfoPerMember regionViewInfo : regionViewInfoList) {
            PersistentMemberID myId = regionViewInfo.getMyId();
            int onlineScore = 0;
            for (RegionViewInfoPerMember otherRegionViewInfo : regionViewInfoList) {
                Set<PersistentMemberID> onlineMembers = otherRegionViewInfo.getOnlineMembers();
                if (!onlineMembers.contains(myId)) continue;
                ++onlineScore;
            }
            regionViewInfo.setOnlineScore(onlineScore);
        }
        Collections.sort(regionViewInfoList);
    }

    public RegionView getRegionView(List<RegionViewInfoPerMember> regionViewInfoList) {
        ArrayList<RegionViewInfoPerGroup> regionViewInfoGroupList = new ArrayList<RegionViewInfoPerGroup>();
        int len = regionViewInfoList.size();
        HashSet<Integer> skipSet = new HashSet<Integer>();
        for (int i = 0; i < len; ++i) {
            if (skipSet.contains(i)) continue;
            RegionViewInfoPerMember rvInfo1 = regionViewInfoList.get(0);
            ArrayList<RegionViewInfoPerMember> regionViewInfoGroup = new ArrayList<RegionViewInfoPerMember>();
            regionViewInfoGroup.add(rvInfo1);
            for (int j = i + 1; j < len; ++j) {
                RegionViewInfoPerMember rvInfo2;
                if (skipSet.contains(j) || !rvInfo1.isSameGroup(rvInfo2 = regionViewInfoList.get(j))) continue;
                skipSet.add(j);
                regionViewInfoGroup.add(rvInfo2);
            }
            this.setRankAndSort(regionViewInfoList);
            regionViewInfoGroupList.add(new RegionViewInfoPerGroup(regionViewInfoList));
        }
        RegionView rv = new RegionView(regionViewInfoGroupList);
        return rv;
    }
}

