/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.tools.dataextractor.comparators;

import com.gemstone.gemfire.internal.cache.persistence.PersistentMemberID;
import com.pivotal.gemfirexd.internal.tools.dataextractor.report.views.RegionViewInfoPerMember;
import com.pivotal.gemfirexd.internal.tools.dataextractor.snapshot.GFXDSnapshotExportStat;
import java.util.Comparator;

public class RegionViewSortComparator
implements Comparator<GFXDSnapshotExportStat> {
    private Comparator<GFXDSnapshotExportStat> parentComparator;

    public RegionViewSortComparator(Comparator<GFXDSnapshotExportStat> parentComparator) {
        this.parentComparator = parentComparator;
    }

    @Override
    public int compare(GFXDSnapshotExportStat arg0, GFXDSnapshotExportStat arg1) {
        if (arg0.isCorrupt()) {
            if (!arg1.isCorrupt()) {
                return -1;
            }
        } else if (arg1.isCorrupt()) {
            return 1;
        }
        RegionViewInfoPerMember m1View = arg0.getRegionViewInfo();
        RegionViewInfoPerMember m2View = arg1.getRegionViewInfo();
        PersistentMemberID m1Id = m1View.getMyId();
        PersistentMemberID m2Id = m2View.getMyId();
        int m1Score = 0;
        int m2Score = 0;
        if (m1View.getOfflineMembers().contains(m2Id) || m1View.getOfflineAndEqualMembers().contains(m2Id)) {
            --m2Score;
        } else if (m1View.getOnlineMembers().contains(m2Id)) {
            ++m2Score;
        }
        if (m2View.getOfflineMembers().contains(m1Id) || m2View.getOfflineAndEqualMembers().contains(m1Id)) {
            --m1Score;
        } else if (m2View.getOnlineMembers().contains(m1Id)) {
            ++m1Score;
        }
        if (m1Score < m2Score) {
            return 1;
        }
        if (m1Score > m2Score) {
            return -1;
        }
        if (this.parentComparator != null) {
            return this.parentComparator.compare(arg0, arg1);
        }
        return 0;
    }
}

