/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.jdbc;

import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnection;
import com.pivotal.gemfirexd.internal.iapi.jdbc.BrokeredConnectionControl;
import com.pivotal.gemfirexd.internal.iapi.jdbc.EngineConnection;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedCallableStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.Util;
import com.pivotal.gemfirexd.internal.jdbc.Driver20;
import com.pivotal.gemfirexd.internal.jdbc.ReferenceableDataSource;
import java.sql.CallableStatement;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

class EmbedPooledConnection
implements PooledConnection,
BrokeredConnectionControl {
    private static int idCounter = 0;
    private int connectionId = this.nextId();
    private String connString;
    private ArrayList eventListener;
    private int eventIterators;
    EmbedConnection realConnection;
    int defaultIsolationLevel;
    private boolean defaultReadOnly;
    BrokeredConnection currentConnectionHandle;
    final ReferenceableDataSource dataSource;
    private final String username;
    private final String password;
    private final boolean requestPassword;
    protected boolean isActive;

    private synchronized int nextId() {
        return idCounter++;
    }

    EmbedPooledConnection(ReferenceableDataSource ds, String u, String p, boolean requestPassword) throws SQLException {
        this.dataSource = ds;
        this.username = u;
        this.password = p;
        this.requestPassword = requestPassword;
        this.isActive = true;
        this.openRealConnection();
    }

    String getUsername() {
        if (this.username == null || this.username.equals("")) {
            return "APP";
        }
        return this.username;
    }

    String getPassword() {
        if (this.password == null) {
            return "";
        }
        return this.password;
    }

    @Override
    public synchronized Connection getConnection() throws SQLException {
        this.checkActive();
        if (this.realConnection == null) {
            this.openRealConnection();
        } else {
            this.resetRealConnection();
        }
        this.closeCurrentConnectionHandle();
        Connection c = this.getNewCurrentConnectionHandle();
        return c;
    }

    final void openRealConnection() throws SQLException {
        Connection rc = this.dataSource.getConnection(this.username, this.password, this.requestPassword);
        this.realConnection = (EmbedConnection)rc;
        this.defaultIsolationLevel = rc.getTransactionIsolation();
        this.defaultReadOnly = rc.isReadOnly();
        if (this.currentConnectionHandle != null) {
            this.realConnection.setApplicationConnection(this.currentConnectionHandle);
        }
    }

    final Connection getNewCurrentConnectionHandle() {
        BrokeredConnection applicationConnection = this.currentConnectionHandle = ((Driver20)this.realConnection.getLocalDriver()).newBrokeredConnection(this);
        this.realConnection.setApplicationConnection(applicationConnection);
        return applicationConnection;
    }

    private void closeCurrentConnectionHandle() throws SQLException {
        if (this.currentConnectionHandle != null) {
            ArrayList tmpEventListener = this.eventListener;
            this.eventListener = null;
            try {
                this.currentConnectionHandle.close();
            }
            finally {
                this.eventListener = tmpEventListener;
            }
            this.currentConnectionHandle = null;
        }
    }

    void resetRealConnection() throws SQLException {
        this.realConnection.rollback();
        this.realConnection.clearWarnings();
        if (this.realConnection.getTransactionIsolation() != this.defaultIsolationLevel) {
            this.realConnection.setTransactionIsolation(this.defaultIsolationLevel);
        }
        if (!this.realConnection.getAutoCommit()) {
            this.realConnection.setAutoCommit(true);
        }
        if (this.realConnection.isReadOnly() != this.defaultReadOnly) {
            this.realConnection.setReadOnly(this.defaultReadOnly);
        }
        if (this.realConnection.getHoldability() != 1) {
            this.realConnection.setHoldability(1);
        }
        this.realConnection.resetFromPool();
        SanityManager.ASSERT((boolean)this.realConnection.transactionIsIdle(), (String)"real connection should have been idle at this point");
    }

    @Override
    public synchronized void close() throws SQLException {
        if (!this.isActive) {
            return;
        }
        this.closeCurrentConnectionHandle();
        try {
            if (this.realConnection != null && !this.realConnection.isClosed()) {
                this.realConnection.close();
            }
        }
        finally {
            this.realConnection = null;
            this.isActive = false;
            this.eventListener = null;
        }
    }

    @Override
    public final synchronized void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this.isActive) {
            return;
        }
        if (listener == null) {
            return;
        }
        if (this.eventListener == null) {
            this.eventListener = new ArrayList();
        } else if (this.eventIterators > 0) {
            this.eventListener = (ArrayList)this.eventListener.clone();
        }
        this.eventListener.add(listener);
    }

    @Override
    public final synchronized void removeConnectionEventListener(ConnectionEventListener listener) {
        if (listener == null || this.eventListener == null) {
            return;
        }
        if (this.eventIterators > 0) {
            this.eventListener = (ArrayList)this.eventListener.clone();
        }
        this.eventListener.remove(listener);
    }

    @Override
    public synchronized EngineConnection getRealConnection() throws SQLException {
        this.checkActive();
        return this.realConnection;
    }

    public synchronized LanguageConnectionContext getLanguageConnection() throws SQLException {
        this.checkActive();
        return this.realConnection.getLanguageConnection();
    }

    public synchronized void notifyError(SQLException exception) {
        if (exception.getErrorCode() < 40000) {
            return;
        }
        this.fireConnectionEventListeners(exception);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fireConnectionEventListeners(SQLException exception) {
        if (this.eventListener != null && !this.eventListener.isEmpty()) {
            ConnectionEvent event = new ConnectionEvent(this, exception);
            ++this.eventIterators;
            try {
                for (ConnectionEventListener l : this.eventListener) {
                    if (exception == null) {
                        l.connectionClosed(event);
                        continue;
                    }
                    l.connectionErrorOccurred(event);
                }
            }
            finally {
                --this.eventIterators;
            }
        }
    }

    final void checkActive() throws SQLException {
        if (!this.isActive) {
            throw Util.noCurrentConnection();
        }
    }

    @Override
    public boolean isIsolationLevelSetUsingSQLorJDBC() throws SQLException {
        if (this.realConnection != null) {
            return this.realConnection.getLanguageConnection().isIsolationLevelSetUsingSQLorJDBC();
        }
        return false;
    }

    @Override
    public void resetIsolationLevelFlag() throws SQLException {
        this.realConnection.getLanguageConnection().resetIsolationLevelFlagUsedForSQLandJDBC();
    }

    @Override
    public void notifyException(SQLException sqle) {
        this.notifyError(sqle);
    }

    @Override
    public void checkAutoCommit(boolean autoCommit) throws SQLException {
    }

    @Override
    public int checkHoldCursors(int holdability, boolean downgrade) throws SQLException {
        return holdability;
    }

    @Override
    public void checkSavepoint() throws SQLException {
    }

    @Override
    public void checkRollback() throws SQLException {
    }

    @Override
    public void checkCommit() throws SQLException {
    }

    @Override
    public void checkClose() throws SQLException {
        if (this.realConnection != null) {
            this.realConnection.checkForTransactionInProgress();
        }
    }

    @Override
    public synchronized boolean closingConnection() throws SQLException {
        this.currentConnectionHandle = null;
        this.fireConnectionEventListeners(null);
        return false;
    }

    @Override
    public Statement wrapStatement(Statement s) throws SQLException {
        return s;
    }

    @Override
    public PreparedStatement wrapStatement(PreparedStatement ps, String sql, Object generatedKeys) throws SQLException {
        EmbedPreparedStatement ps_ = (EmbedPreparedStatement)ps;
        ps_.setBrokeredConnectionControl(this);
        return ps_;
    }

    @Override
    public CallableStatement wrapStatement(CallableStatement cs, String sql) throws SQLException {
        EmbedCallableStatement cs_ = (EmbedCallableStatement)cs;
        cs_.setBrokeredConnectionControl(this);
        return cs_;
    }

    public String toString() {
        if (this.connString == null) {
            String physicalConnString = this.isActive ? this.realConnection.toString() : "<none>";
            this.connString = this.getClass().getName() + "@" + this.hashCode() + " (ID = " + this.connectionId + "), Physical Connection = " + physicalConnString;
        }
        return this.connString;
    }

    @Override
    public void onStatementClose(PreparedStatement statement) {
    }

    @Override
    public void onStatementErrorOccurred(PreparedStatement statement, SQLException sqle) {
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new AssertionError((Object)"should have been overridden in JDBC 4.0");
    }
}

