/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.replication.slave;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleControl;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.ModuleSupportable;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogFactory;
import com.pivotal.gemfirexd.internal.iapi.store.replication.slave.SlaveFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogCounter;
import com.pivotal.gemfirexd.internal.impl.store.raw.log.LogToFile;
import com.pivotal.gemfirexd.internal.impl.store.replication.ReplicationLogger;
import com.pivotal.gemfirexd.internal.impl.store.replication.net.ReplicationMessage;
import com.pivotal.gemfirexd.internal.impl.store.replication.net.ReplicationMessageReceive;
import com.pivotal.gemfirexd.internal.impl.store.replication.net.SlaveAddress;
import com.pivotal.gemfirexd.internal.impl.store.replication.slave.ReplicationLogScan;
import java.io.EOFException;
import java.io.IOException;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import java.util.Properties;

public class SlaveController
implements SlaveFactory,
ModuleControl,
ModuleSupportable {
    private static final int DEFAULT_SOCKET_TIMEOUT = 1000;
    private RawStoreFactory rawStoreFactory;
    private LogToFile logToFile;
    private ReplicationMessageReceive receiver;
    private ReplicationLogger repLogger;
    private SlaveAddress slaveAddr;
    private String dbname;
    private volatile long highestLogInstant = -1L;
    private volatile boolean inReplicationSlaveMode = true;
    private volatile boolean startupSuccessful = false;
    private ReplicationLogScan logScan;
    private SlaveLogReceiverThread logReceiverThread;

    @Override
    public void boot(boolean create, Properties properties) throws StandardException {
        String port = properties.getProperty("slavePort");
        try {
            int slavePort = -1;
            if (port != null) {
                slavePort = Integer.valueOf(port);
            }
            this.slaveAddr = new SlaveAddress(properties.getProperty("slaveHost"), slavePort);
        }
        catch (UnknownHostException uhe) {
            throw StandardException.newException("XRE04.U.1", uhe, (Object)this.dbname, (Object)this.getHostName(), (Object)String.valueOf(this.getPortNumber()));
        }
        this.dbname = properties.getProperty("replication.slave.dbname");
        this.repLogger = new ReplicationLogger(this.dbname);
    }

    @Override
    public void stop() {
        if (this.inReplicationSlaveMode) {
            try {
                this.stopSlave(true);
            }
            catch (StandardException standardException) {
                // empty catch block
            }
        }
    }

    @Override
    public boolean canSupport(String identifier, Properties startParams) {
        String modeParam = startParams.getProperty("replication.slave.mode");
        return modeParam != null && modeParam.equals("slavemode");
    }

    @Override
    public void startSlave(RawStoreFactory rawStore, LogFactory logFac) throws StandardException {
        this.rawStoreFactory = rawStore;
        try {
            this.logToFile = (LogToFile)logFac;
        }
        catch (ClassCastException cce) {
            throw StandardException.newException("XRE00");
        }
        this.logToFile.initializeReplicationSlaveRole();
        this.receiver = new ReplicationMessageReceive(this.slaveAddr, this.dbname);
        while (!this.setupConnection()) {
            if (this.inReplicationSlaveMode) continue;
            return;
        }
        this.logScan = new ReplicationLogScan();
        this.startLogReceiverThread();
        this.startupSuccessful = true;
        Monitor.logTextMessage("R003", this.dbname);
    }

    private void stopSlave() throws StandardException {
        this.inReplicationSlaveMode = false;
        this.teardownNetwork();
        this.logToFile.stopReplicationSlaveRole();
        Monitor.logTextMessage("R004", this.dbname);
    }

    @Override
    public void stopSlave(boolean forcedStop) throws StandardException {
        if (!forcedStop && this.isConnectedToMaster()) {
            throw StandardException.newException("XRE41");
        }
        this.stopSlave();
    }

    @Override
    public void failover() throws StandardException {
        if (this.isConnectedToMaster()) {
            throw StandardException.newException("XRE41");
        }
        this.doFailover();
        this.teardownNetwork();
    }

    private void doFailover() {
        this.inReplicationSlaveMode = false;
        this.logToFile.failoverSlave();
        Monitor.logTextMessage("R020", this.dbname);
    }

    @Override
    public boolean isStarted() {
        return this.startupSuccessful;
    }

    private boolean setupConnection() throws StandardException {
        try {
            if (this.highestLogInstant != -1L) {
                this.receiver.initConnection(1000, this.highestLogInstant, this.dbname);
            } else {
                this.receiver.initConnection(1000, this.logToFile.getFirstUnflushedInstantAsLong(), this.dbname);
            }
            return true;
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Exception e) {
            Throwable cause = e.getCause();
            if (cause instanceof SocketTimeoutException) {
                return false;
            }
            throw StandardException.newException("XRE04.U.1", e, (Object)this.dbname, (Object)this.getHostName(), (Object)String.valueOf(this.getPortNumber()));
        }
    }

    private void handleDisconnect(Exception e) {
        if (!this.inReplicationSlaveMode) {
            return;
        }
        this.repLogger.logError("R006", e);
        try {
            while (!this.setupConnection()) {
                if (this.inReplicationSlaveMode) continue;
                return;
            }
            this.startLogReceiverThread();
        }
        catch (StandardException se) {
            this.handleFatalException(se);
        }
    }

    private boolean isConnectedToMaster() {
        if (this.receiver == null) {
            return false;
        }
        return this.receiver.isConnectedToMaster();
    }

    private void startLogReceiverThread() {
        this.logReceiverThread = new SlaveLogReceiverThread();
        this.logReceiverThread.setDaemon(true);
        this.logReceiverThread.start();
    }

    private void handleFatalException(Exception e) {
        if (!this.inReplicationSlaveMode) {
            return;
        }
        this.repLogger.logError("R005", e);
        try {
            this.stopSlave();
        }
        catch (StandardException se) {
            this.repLogger.logError("R005", se);
        }
    }

    private void teardownNetwork() {
        try {
            if (this.receiver != null) {
                this.receiver.tearDown();
                this.receiver = null;
            }
        }
        catch (IOException ioe) {
            this.repLogger.logError(null, ioe);
        }
    }

    private String getHostName() {
        return this.slaveAddr.getHostAddress().getHostName();
    }

    private int getPortNumber() {
        return this.slaveAddr.getPortNumber();
    }

    private class SlaveLogReceiverThread
    extends Thread {
        SlaveLogReceiverThread() {
            super("gemfirexd.slave.logger-" + SlaveController.this.dbname);
        }

        @Override
        public void run() {
            try {
                block9: while (SlaveController.this.inReplicationSlaveMode) {
                    ReplicationMessage message = SlaveController.this.receiver.readMessage();
                    switch (message.getType()) {
                        case 10: {
                            byte[] logChunk = (byte[])message.getMessage();
                            this.handleLogChunk(logChunk);
                            continue block9;
                        }
                        case 21: {
                            SlaveController.this.doFailover();
                            ReplicationMessage ack = new ReplicationMessage(11, "failover succeeded");
                            SlaveController.this.receiver.sendMessage(ack);
                            SlaveController.this.teardownNetwork();
                            continue block9;
                        }
                        case 20: {
                            SlaveController.this.stopSlave();
                            continue block9;
                        }
                    }
                    System.out.println("Not handling non-log messages yet - got a type " + message.getType());
                }
            }
            catch (EOFException eofe) {
                SlaveController.this.handleDisconnect(eofe);
            }
            catch (StandardException se) {
                SlaveController.this.handleFatalException(se);
            }
            catch (Exception e) {
                StandardException se = StandardException.newException("XRE03", e);
                SlaveController.this.handleFatalException(se);
            }
        }

        private void handleLogChunk(byte[] logChunk) throws StandardException {
            SlaveController.this.logScan.init(logChunk);
            while (SlaveController.this.logScan.next()) {
                if (SlaveController.this.logScan.isLogFileSwitch()) {
                    SlaveController.this.logToFile.switchLogFile();
                    continue;
                }
                long localInstant = SlaveController.this.logToFile.appendLogRecord(SlaveController.this.logScan.getData(), 0, SlaveController.this.logScan.getDataLength(), null, 0, 0);
                if (SlaveController.this.logScan.getInstant() != localInstant) {
                    throw StandardException.newException("XRE05", SlaveController.this.dbname, (Object)new Long(LogCounter.getLogFileNumber(SlaveController.this.logScan.getInstant())), (Object)new Long(LogCounter.getLogFilePosition(SlaveController.this.logScan.getInstant())), (Object)new Long(LogCounter.getLogFileNumber(localInstant)), (Object)new Long(LogCounter.getLogFilePosition(localInstant)));
                }
                SlaveController.this.highestLogInstant = localInstant;
            }
        }
    }
}

