/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.replication.master;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.impl.store.replication.ReplicationLogger;
import com.pivotal.gemfirexd.internal.impl.store.replication.buffer.ReplicationLogBuffer;
import com.pivotal.gemfirexd.internal.impl.store.replication.master.LogShipper;
import com.pivotal.gemfirexd.internal.impl.store.replication.master.MasterController;
import com.pivotal.gemfirexd.internal.impl.store.replication.net.ReplicationMessage;
import com.pivotal.gemfirexd.internal.impl.store.replication.net.ReplicationMessageTransmit;
import java.io.IOException;
import java.util.NoSuchElementException;

public class AsynchronousLogShipper
extends Thread
implements LogShipper {
    private final ReplicationLogBuffer logBuffer;
    private ReplicationMessageTransmit transmitter;
    private long shippingInterval;
    private long minShippingInterval;
    private long maxShippingInterval;
    private long lastShippingTime;
    private volatile boolean stopShipping = false;
    private MasterController masterController = null;
    private Object objLSTSync = new Object();
    private Object forceFlushSemaphore = new Object();
    public static final int DEFAULT_FORCEFLUSH_TIMEOUT = 5000;
    private ReplicationMessage failedChunk = null;
    private long failedChunkHighestInstant = -1L;
    private long highestShippedInstant = -1L;
    private static final int FI_LOW = 10;
    private static final int FI_HIGH = 80;
    private static final long MIN = 100L;
    private static final long MAX = 5000L;
    private final ReplicationLogger repLogger;

    public AsynchronousLogShipper(ReplicationLogBuffer logBuffer, ReplicationMessageTransmit transmitter, MasterController masterController, ReplicationLogger repLogger) {
        super("derby.master.logger-" + masterController.getDbName());
        this.logBuffer = logBuffer;
        this.transmitter = transmitter;
        this.masterController = masterController;
        this.stopShipping = false;
        this.repLogger = repLogger;
        this.getLogShipperProperties();
        this.shippingInterval = this.minShippingInterval;
        this.lastShippingTime = System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        while (!this.stopShipping) {
            try {
                this.shipALogChunk();
                Object object = this.forceFlushSemaphore;
                synchronized (object) {
                    this.forceFlushSemaphore.notify();
                }
                this.shippingInterval = this.calculateSIfromFI();
                if (this.shippingInterval == -1L) continue;
                object = this.objLSTSync;
                synchronized (object) {
                    this.objLSTSync.wait(this.shippingInterval);
                }
            }
            catch (InterruptedException ie) {
                return;
            }
            catch (IOException ioe) {
                this.transmitter = this.masterController.handleExceptions(ioe);
                if (this.transmitter == null) continue;
            }
            catch (StandardException se) {
                this.masterController.handleExceptions(se);
            }
        }
    }

    private synchronized boolean shipALogChunk() throws IOException, StandardException {
        byte[] logRecords = null;
        ReplicationMessage mesg = null;
        try {
            if (this.failedChunk != null) {
                this.transmitter.sendMessage(this.failedChunk);
                this.highestShippedInstant = this.failedChunkHighestInstant;
                this.failedChunk = null;
            }
            if (this.logBuffer.next()) {
                logRecords = this.logBuffer.getData();
                mesg = new ReplicationMessage(10, logRecords);
                this.transmitter.sendMessage(mesg);
                this.highestShippedInstant = this.logBuffer.getLastInstant();
                this.lastShippingTime = System.currentTimeMillis();
                return true;
            }
        }
        catch (NoSuchElementException nse) {
            this.masterController.handleExceptions(StandardException.newException("XRE03", nse));
        }
        catch (IOException ioe) {
            if (mesg != null) {
                this.failedChunk = mesg;
                this.failedChunkHighestInstant = this.logBuffer.getLastInstant();
            }
            throw ioe;
        }
        return false;
    }

    @Override
    public void flushBuffer() throws IOException, StandardException {
        while (this.shipALogChunk()) {
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void forceFlush() throws IOException, StandardException {
        if (this.stopShipping) {
            return;
        }
        Object object = this.forceFlushSemaphore;
        synchronized (object) {
            Object object2 = this.objLSTSync;
            synchronized (object2) {
                this.objLSTSync.notify();
            }
            try {
                this.forceFlushSemaphore.wait(5000L);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    public long getHighestShippedInstant() {
        return this.highestShippedInstant;
    }

    @Override
    public void flushedInstance(long latestInstanceFlushedToDisk) {
    }

    public void stopLogShipment() {
        this.stopShipping = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void workToDo() {
        int fi = this.logBuffer.getFillInformation();
        if (fi >= 80 || System.currentTimeMillis() - this.lastShippingTime > this.minShippingInterval) {
            Object object = this.objLSTSync;
            synchronized (object) {
                this.objLSTSync.notify();
            }
        }
    }

    private long calculateSIfromFI() {
        int fi = this.logBuffer.getFillInformation();
        long si = fi >= 80 ? -1L : (fi > 10 && fi < 80 ? this.minShippingInterval : this.maxShippingInterval);
        return si;
    }

    private void getLogShipperProperties() {
        this.minShippingInterval = PropertyUtil.getSystemInt("gemfirexd.replication.minLogShippingInterval", 100);
        this.maxShippingInterval = PropertyUtil.getSystemInt("gemfirexd.replication.maxLogShippingInterval", 5000);
        int buffers = 10;
        if (this.minShippingInterval > this.maxShippingInterval / (long)buffers) {
            this.minShippingInterval = this.maxShippingInterval / (long)buffers;
            this.repLogger.logText("Minimum log shipping interval too large to guarantee the current maximum interval (" + this.maxShippingInterval + "). New minimum interval: " + this.minShippingInterval, false);
        }
    }
}

