/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.replication.buffer;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.replication.master.MasterFactory;
import com.pivotal.gemfirexd.internal.impl.store.replication.buffer.LogBufferElement;
import com.pivotal.gemfirexd.internal.impl.store.replication.buffer.LogBufferFullException;
import java.util.LinkedList;
import java.util.NoSuchElementException;

public class ReplicationLogBuffer {
    public static final int DEFAULT_NUMBER_LOG_BUFFERS = 10;
    private final LinkedList dirtyBuffers;
    private final LinkedList freeBuffers;
    private LogBufferElement currentDirtyBuffer;
    private boolean validOutBuffer;
    private byte[] outBufferData;
    private int outBufferStored;
    private long outBufferLastInstant;
    private final Object listLatch = new Object();
    private final Object outputLatch = new Object();
    private int defaultBufferSize;
    private final MasterFactory mf;

    public ReplicationLogBuffer(int bufferSize, MasterFactory mf) {
        this.defaultBufferSize = bufferSize;
        this.mf = mf;
        this.outBufferData = new byte[bufferSize];
        this.outBufferStored = 0;
        this.outBufferLastInstant = 0L;
        this.validOutBuffer = false;
        this.dirtyBuffers = new LinkedList();
        this.freeBuffers = new LinkedList();
        for (int i = 0; i < 10; ++i) {
            LogBufferElement b = new LogBufferElement(bufferSize);
            this.freeBuffers.addLast(b);
        }
        this.currentDirtyBuffer = (LogBufferElement)this.freeBuffers.removeFirst();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void appendLog(long greatestInstant, byte[] log, int logOffset, int logLength) throws LogBufferFullException {
        boolean switchedBuffer = false;
        Object object = this.listLatch;
        synchronized (object) {
            if (this.currentDirtyBuffer == null) {
                this.switchDirtyBuffer();
            }
            if (logLength > this.currentDirtyBuffer.freeSize()) {
                this.switchDirtyBuffer();
                switchedBuffer = true;
            }
            if (logLength <= this.currentDirtyBuffer.freeSize()) {
                this.currentDirtyBuffer.appendLog(greatestInstant, log, logOffset, logLength);
            } else {
                LogBufferElement current = new LogBufferElement(logLength);
                current.setRecyclable(false);
                current.appendLog(greatestInstant, log, logOffset, logLength);
                this.dirtyBuffers.addLast(current);
            }
        }
        if (switchedBuffer) {
            this.mf.workToDo();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean next() {
        Object object = this.listLatch;
        synchronized (object) {
            if (this.dirtyBuffers.size() == 0) {
                try {
                    this.switchDirtyBuffer();
                }
                catch (LogBufferFullException lbfe) {
                    SanityManager.THROWASSERT((String)"Unexpected LogBufferFullException when trying to remove elements from the buffer", (Throwable)lbfe);
                }
            }
            Object object2 = this.outputLatch;
            synchronized (object2) {
                if (this.dirtyBuffers.size() > 0) {
                    LogBufferElement current = (LogBufferElement)this.dirtyBuffers.removeFirst();
                    int requiredOutBufferSize = Math.max(this.defaultBufferSize, current.size());
                    if (this.outBufferData.length != requiredOutBufferSize) {
                        this.outBufferData = new byte[requiredOutBufferSize];
                    }
                    System.arraycopy(current.getData(), 0, this.outBufferData, 0, current.size());
                    this.outBufferStored = current.size();
                    this.outBufferLastInstant = current.getLastInstant();
                    if (current.isRecyclable()) {
                        this.freeBuffers.addLast(current);
                    }
                    this.validOutBuffer = true;
                } else {
                    this.validOutBuffer = false;
                }
            }
        }
        return this.validOutBuffer;
    }

    public byte[] getData() throws NoSuchElementException {
        Object object = this.outputLatch;
        synchronized (object) {
            byte[] b = new byte[this.getSize()];
            if (this.validOutBuffer) {
                System.arraycopy(this.outBufferData, 0, b, 0, this.getSize());
                return b;
            }
            throw new NoSuchElementException();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean validData() {
        Object object = this.outputLatch;
        synchronized (object) {
            return this.validOutBuffer;
        }
    }

    public int getSize() throws NoSuchElementException {
        Object object = this.outputLatch;
        synchronized (object) {
            if (this.validOutBuffer) {
                return this.outBufferStored;
            }
            throw new NoSuchElementException();
        }
    }

    public long getLastInstant() throws NoSuchElementException {
        Object object = this.outputLatch;
        synchronized (object) {
            if (this.validOutBuffer) {
                return this.outBufferLastInstant;
            }
            throw new NoSuchElementException();
        }
    }

    private void switchDirtyBuffer() throws LogBufferFullException {
        if (this.currentDirtyBuffer != null && this.currentDirtyBuffer.size() > 0) {
            this.dirtyBuffers.addLast(this.currentDirtyBuffer);
            this.currentDirtyBuffer = null;
        }
        if (this.currentDirtyBuffer == null) {
            try {
                this.currentDirtyBuffer = (LogBufferElement)this.freeBuffers.removeFirst();
                this.currentDirtyBuffer.init();
            }
            catch (NoSuchElementException nsee) {
                throw new LogBufferFullException();
            }
        }
    }

    public int getFillInformation() {
        return this.dirtyBuffers.size() * 100 / 10;
    }
}

