/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.replication;

import com.pivotal.gemfirexd.internal.iapi.error.ErrorStringBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import java.util.Date;

public class ReplicationLogger {
    private final boolean verbose = PropertyUtil.getSystemBoolean("gemfirexd.replication.verbose", true);
    private final String dbname;

    public ReplicationLogger(String dbname) {
        this.dbname = dbname;
    }

    public void logError(String msgId, Throwable t) {
        if (this.verbose) {
            Monitor.logTextMessage("R001", new Date());
            if (msgId != null) {
                Monitor.logTextMessage(msgId, this.dbname);
            }
            if (t != null) {
                ErrorStringBuilder esb = new ErrorStringBuilder(Monitor.getStream().getHeader());
                esb.stackTrace(t);
                Monitor.logMessage(esb.get().toString());
                esb.reset();
            }
            Monitor.logTextMessage("R002");
        }
    }

    public void logText(String text, boolean writeHeader) {
        if (this.verbose) {
            if (writeHeader) {
                Monitor.logTextMessage("R001", new Date());
                Monitor.logMessage(text);
                Monitor.logTextMessage("R002");
            } else {
                Monitor.logTextMessage("R013", new Date(), text);
            }
        }
    }
}

