/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.xact;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.xa.XAResourceManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.xa.XAXactId;
import com.pivotal.gemfirexd.internal.iapi.store.raw.GlobalTransactionId;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.GlobalXactId;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.TransactionTable;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.TransactionTableEntry;
import com.pivotal.gemfirexd.internal.impl.store.raw.xact.Xact;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.transaction.xa.Xid;

public class XactXAResourceManager
implements XAResourceManager {
    private TransactionTable transaction_table;
    private RawStoreFactory rsf;

    public XactXAResourceManager(RawStoreFactory rsf, TransactionTable tt) {
        this.rsf = rsf;
        this.transaction_table = tt;
    }

    @Override
    public void commit(ContextManager cm, Xid xid, boolean onePhase) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        if (rawtran == null) {
            throw StandardException.newException("XSAX0.S");
        }
        SanityManager.ASSERT((rawtran != null ? 1 : 0) != 0);
        SanityManager.ASSERT((boolean)new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        rawtran.xa_commit(onePhase);
    }

    @Override
    public ContextManager find(Xid xid) {
        return this.transaction_table.findTransactionContextByGlobalId(new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()));
    }

    @Override
    public void forget(ContextManager cm, Xid xid) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        SanityManager.ASSERT((boolean)new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        throw StandardException.newException("XSAX0.S");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Xid[] recover(int flags) throws StandardException {
        Xid[] ret_xid_list;
        if ((flags & 0x1000000) != 0) {
            int i;
            Hashtable trans_hashtable = this.transaction_table.getTableForXA();
            XAXactId[] xid_list = new XAXactId[trans_hashtable.size()];
            int num_prepared = 0;
            Hashtable hashtable = trans_hashtable;
            synchronized (hashtable) {
                i = 0;
                Enumeration e = trans_hashtable.elements();
                while (e.hasMoreElements()) {
                    Xact xact = ((TransactionTableEntry)e.nextElement()).getXact();
                    if (xact.isPrepared()) {
                        GlobalTransactionId xa_id = xact.getGlobalId();
                        xid_list[i] = new XAXactId(xa_id.getFormat_Id(), xa_id.getGlobalTransactionId(), xa_id.getBranchQualifier());
                        ++num_prepared;
                    }
                    ++i;
                }
            }
            ret_xid_list = new XAXactId[num_prepared];
            int ret_index = 0;
            i = xid_list.length;
            while (i-- > 0) {
                if (xid_list[i] == null) continue;
                ret_xid_list[ret_index++] = xid_list[i];
            }
            SanityManager.ASSERT((ret_index == num_prepared ? 1 : 0) != 0);
        } else {
            ret_xid_list = new XAXactId[]{};
        }
        return ret_xid_list;
    }

    @Override
    public void rollback(ContextManager cm, Xid xid) throws StandardException {
        Transaction rawtran = this.rsf.findUserTransaction(cm, "UserTransaction");
        if (rawtran == null) {
            throw StandardException.newException("XSAX0.S");
        }
        SanityManager.ASSERT((boolean)new GlobalXactId(xid.getFormatId(), xid.getGlobalTransactionId(), xid.getBranchQualifier()).equals(rawtran.getGlobalId()));
        rawtran.xa_rollback();
    }
}

