/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.xact;

import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.GlobalXact;
import com.pivotal.gemfirexd.internal.iapi.store.raw.GlobalTransactionId;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public class GlobalXactId
extends GlobalXact
implements GlobalTransactionId {
    public GlobalXactId(int format_id, byte[] global_id, byte[] branch_id) {
        this.format_id = format_id;
        this.global_id = new byte[global_id.length];
        System.arraycopy(global_id, 0, this.global_id, 0, global_id.length);
        this.branch_id = new byte[branch_id.length];
        System.arraycopy(branch_id, 0, this.branch_id, 0, branch_id.length);
    }

    public GlobalXactId() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeInt(this.format_id);
        SanityManager.ASSERT((this.global_id.length <= 64 ? 1 : 0) != 0);
        SanityManager.ASSERT((this.global_id != null ? 1 : 0) != 0);
        SanityManager.ASSERT((this.branch_id != null ? 1 : 0) != 0);
        out.write(this.global_id.length);
        if (this.global_id.length > 0) {
            out.write(this.global_id);
        }
        out.write(this.branch_id.length);
        if (this.branch_id.length > 0) {
            out.write(this.branch_id);
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.format_id = in.readInt();
        int array_len = in.read();
        SanityManager.ASSERT((array_len >= 0 ? 1 : 0) != 0);
        this.global_id = new byte[array_len];
        if (array_len > 0) {
            in.read(this.global_id);
        }
        SanityManager.ASSERT(((array_len = in.read()) >= 0 ? 1 : 0) != 0);
        this.branch_id = new byte[array_len];
        if (array_len > 0) {
            in.read(this.branch_id);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 328;
    }

    @Override
    public int getFormat_Id() {
        return this.format_id;
    }

    @Override
    public byte[] getGlobalTransactionId() {
        return this.global_id;
    }

    @Override
    public byte[] getBranchQualifier() {
        return this.branch_id;
    }
}

