/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextService;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.FileResource;
import com.pivotal.gemfirexd.internal.iapi.store.raw.xact.RawTransaction;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BaseDataFileFactory;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.RemoveFile;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.RemoveFileOperation;
import com.pivotal.gemfirexd.internal.io.StorageFile;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

class RFResource
implements FileResource {
    private final BaseDataFileFactory factory;

    RFResource(BaseDataFileFactory dataFactory) {
        this.factory = dataFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long add(String name, InputStream source, LanguageConnectionContext lcc) throws StandardException {
        OutputStream os = null;
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        long generationId = this.factory.getNextId();
        try {
            StorageFile file = this.getAsFile(name, generationId);
            if (file.exists()) {
                throw StandardException.newException("XSDF0.S", file);
            }
            ContextManager cm = ContextService.getFactory().getCurrentContextManager();
            RawTransaction tran = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), cm, "UserTransaction");
            tran.blockBackup(true);
            StorageFile directory = file.getParentDir();
            if (!directory.exists() && !directory.mkdirs()) {
                throw StandardException.newException("XSDF3.S", directory);
            }
            os = file.getOutputStream();
            byte[] data = new byte[4096];
            this.factory.writeInProgress();
            try {
                int len;
                while ((len = source.read(data)) != -1) {
                    os.write(data, 0, len);
                }
                this.factory.writableStorageFactory.sync(os, false);
            }
            finally {
                this.factory.writeFinished();
            }
        }
        catch (IOException ioe) {
            throw StandardException.newException("XSDFF.S", ioe);
        }
        finally {
            try {
                if (os != null) {
                    os.close();
                }
            }
            catch (IOException iOException) {}
            try {
                if (source != null) {
                    source.close();
                }
            }
            catch (IOException iOException) {}
        }
        return generationId;
    }

    @Override
    public void remove(String name, long currentGenerationId, LanguageConnectionContext lcc) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        ContextManager cm = ContextService.getFactory().getCurrentContextManager();
        RawTransaction tran = this.factory.getRawStoreFactory().getXactFactory().findUserTransaction(this.factory.getRawStoreFactory(), cm, "UserTransaction");
        tran.blockBackup(true);
        tran.logAndDo(new RemoveFileOperation(name, currentGenerationId, true));
        RemoveFile s = new RemoveFile(this.getAsFile(name, currentGenerationId));
        tran.addPostCommitWork(s);
    }

    @Override
    public long replace(String name, long currentGenerationId, InputStream source, LanguageConnectionContext lcc) throws StandardException {
        if (this.factory.isReadOnly()) {
            throw StandardException.newException("XSDFB.S");
        }
        this.remove(name, currentGenerationId, lcc);
        long generationId = this.add(name, source, lcc);
        return generationId;
    }

    @Override
    public StorageFile getAsFile(String name, long generationId) {
        String versionedFileName = this.factory.getVersionedName(name, generationId);
        return this.factory.storageFactory.newStorageFile(versionedFileName);
    }

    @Override
    public char getSeparatorChar() {
        return this.factory.storageFactory.getSeparator();
    }

    @Override
    public long add(String name, byte[] source, long id) throws StandardException {
        throw new UnsupportedOperationException("this add overload method is supported only for GfxdJarResource");
    }

    @Override
    public void remove(String name, long currentGenerationId, boolean remote) throws StandardException {
        throw new UnsupportedOperationException("this remove overload method is supported only for GfxdJarResource");
    }

    @Override
    public long replace(String name, long currentGenerationId, long newGenerationId, byte[] source) throws StandardException {
        throw new UnsupportedOperationException("this replace overload method is supported only for GfxdJarResource");
    }
}

