/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Compensation;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Undoable;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.iapi.util.ByteArray;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PageBasicOperation;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PhysicalPageOperation;
import java.io.IOException;

public class PhysicalUndoOperation
extends PageBasicOperation
implements Compensation {
    private transient PhysicalPageOperation undoOp;

    protected PhysicalUndoOperation(BasePage page) {
        super(page);
    }

    public PhysicalUndoOperation(BasePage page, PhysicalPageOperation op) {
        super(page);
        this.undoOp = op;
    }

    public PhysicalUndoOperation() {
    }

    @Override
    public int getTypeFormatId() {
        return 105;
    }

    @Override
    public void setUndoOp(Undoable op) {
        SanityManager.ASSERT((boolean)(op instanceof PhysicalPageOperation));
        this.undoOp = (PhysicalPageOperation)op;
    }

    @Override
    public final void doMe(Transaction xact, LogInstant instant, LimitObjectInput in) throws StandardException, IOException {
        long oldversion = 0L;
        LogInstant oldLogInstant = null;
        oldLogInstant = this.page.getLastLogInstant();
        oldversion = this.page.getPageVersion();
        SanityManager.ASSERT((oldversion == this.getPageVersion() ? 1 : 0) != 0);
        SanityManager.ASSERT((oldLogInstant == null || instant == null || oldLogInstant.lessThan(instant) ? 1 : 0) != 0);
        this.undoOp.undoMe(xact, this.page, instant, in);
        if (oldversion >= this.page.getPageVersion()) {
            SanityManager.THROWASSERT((String)("oldversion = " + oldversion + ";page version = " + this.page.getPageVersion() + "page = " + this.page + "; my class name is " + this.getClass().getName() + " undoOp is " + this.undoOp.getClass().getName()));
        }
        SanityManager.ASSERT((oldversion < this.page.getPageVersion() ? 1 : 0) != 0);
        if (instant != null && !instant.equals(this.page.getLastLogInstant())) {
            SanityManager.THROWASSERT((String)("my class name is " + this.getClass().getName() + " undoOp is " + this.undoOp.getClass().getName()));
        }
        this.releaseResource(xact);
    }

    @Override
    public void releaseResource(Transaction xact) {
        if (this.undoOp != null) {
            this.undoOp.releaseResource(xact);
        }
        super.releaseResource(xact);
    }

    @Override
    public int group() {
        return super.group() | 4 | 0x100;
    }

    @Override
    public final ByteArray getPreparedLog() {
        return null;
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT((String)"cannot call restore me on PhysicalUndoOperation");
    }

    @Override
    public String toString() {
        String str = "CLR (Physical Undo): " + super.toString();
        str = this.undoOp != null ? str + "\n" + this.undoOp.toString() : str + "undo Operation not set";
        return str;
    }
}

