/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.CompressedNumber;
import com.pivotal.gemfirexd.internal.iapi.services.io.LimitObjectInput;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.store.raw.log.LogInstant;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.AllocPage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.BasePage;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.PhysicalPageOperation;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class ChainAllocPageOperation
extends PhysicalPageOperation {
    protected long newAllocPageNum;
    protected long newAllocPageOffset;

    public ChainAllocPageOperation(AllocPage allocPage, long pageNumber, long pageOffset) throws StandardException {
        super(allocPage);
        this.newAllocPageNum = pageNumber;
        this.newAllocPageOffset = pageOffset;
    }

    public ChainAllocPageOperation() {
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        CompressedNumber.writeLong(out, this.newAllocPageNum);
        CompressedNumber.writeLong(out, this.newAllocPageOffset);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.newAllocPageNum = CompressedNumber.readLong(in);
        this.newAllocPageOffset = CompressedNumber.readLong(in);
    }

    @Override
    public int getTypeFormatId() {
        return 97;
    }

    @Override
    public final void doMe(Transaction tran, LogInstant instant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT((boolean)(this.page instanceof AllocPage));
        ((AllocPage)this.page).chainNextAllocPage(instant, this.newAllocPageNum, this.newAllocPageOffset);
    }

    @Override
    public void undoMe(Transaction xact, BasePage undoPage, LogInstant CLRInstant, LimitObjectInput in) throws StandardException {
        SanityManager.ASSERT((undoPage != null ? 1 : 0) != 0, (String)"undo Page null");
        SanityManager.ASSERT((boolean)(undoPage instanceof AllocPage), (String)"undo Page is not an allocPage");
        ((AllocPage)undoPage).chainNextAllocPage(CLRInstant, -1L, 0L);
    }

    @Override
    public void restoreMe(Transaction xact, BasePage undoPage, LogInstant CLRinstant, LimitObjectInput in) {
        SanityManager.THROWASSERT((String)"cannot call restoreMe on BI_ChainAllocPageOperation");
    }

    @Override
    public String toString() {
        String str = super.toString();
        str = str + " Chain new alloc page number " + this.newAllocPageNum + " at " + this.newAllocPageOffset + " to " + this.getPageId();
        return str;
    }
}

