/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.raw.data;

import com.pivotal.gemfirexd.internal.impl.store.raw.data.ByteHolder;
import com.pivotal.gemfirexd.internal.impl.store.raw.data.ByteHolderInputStream;
import java.io.IOException;

public abstract class BufferedByteHolderInputStream
extends ByteHolderInputStream {
    public BufferedByteHolderInputStream(ByteHolder bh) {
        super(bh);
    }

    public abstract void fillByteHolder() throws IOException;

    @Override
    public int read() throws IOException {
        this.fillByteHolder();
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.fillByteHolder();
        return super.read(b, off, len);
    }

    @Override
    public long skip(long count) throws IOException {
        long bytesSkipped;
        long skipped;
        for (bytesSkipped = 0L; bytesSkipped < count; bytesSkipped += skipped) {
            this.fillByteHolder();
            skipped = super.skip(count - bytesSkipped);
            if (skipped <= 0L) break;
        }
        return bytesSkipped;
    }

    @Override
    public int available() throws IOException {
        this.fillByteHolder();
        return super.available();
    }
}

