/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanControllerRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.Scan;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.SortBuffer;

public class SortBufferRowSource
extends Scan
implements ScanControllerRowSource {
    SortBuffer sortBuffer = null;
    protected TransactionManager tran = null;
    private int maxFreeListSize;
    private boolean writingToDisk;
    private SortObserver sortObserver;

    SortBufferRowSource(SortBuffer sortBuffer, TransactionManager tran, SortObserver sortObserver, boolean writingToDisk, int maxFreeListSize) {
        this.sortBuffer = sortBuffer;
        this.tran = tran;
        this.sortObserver = sortObserver;
        this.writingToDisk = writingToDisk;
        this.maxFreeListSize = maxFreeListSize;
    }

    @Override
    public ExecRow getNextRowFromRowSource() {
        if (this.sortBuffer == null) {
            return null;
        }
        ExecRow retval = this.sortBuffer.removeFirst();
        if (retval != null && this.writingToDisk) {
            this.sortObserver.addToFreeList(retval, this.maxFreeListSize);
        }
        return retval;
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) {
        SanityManager.THROWASSERT((String)"unexpected call to RowSource.rowLocation");
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void close() {
        if (this.sortBuffer != null) {
            this.sortBuffer.close();
            this.sortBuffer = null;
        }
        this.tran.closeMe(this);
    }

    @Override
    public boolean closeForEndTransaction(boolean closeHeldScan) {
        SanityManager.ASSERT((boolean)closeHeldScan, (String)"Sort scan should not be held open across commit.");
        this.close();
        return true;
    }

    @Override
    public void closeRowSource() {
        this.close();
    }

    @Override
    public boolean next() throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    @Override
    public void fetchWithoutQualify(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    @Override
    public void fetch(DataValueDescriptor[] result) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }

    @Override
    public final boolean fetchNext(DataValueDescriptor[] row) throws StandardException {
        throw StandardException.newException("XSAS0.S");
    }
}

