/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.sort;

import com.gemstone.gemfire.DataSerializer;
import com.gemstone.gemfire.InternalGemFireError;
import com.gemstone.gemfire.cache.util.ObjectSizer;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.gemstone.gemfire.internal.cache.control.MemoryThresholdListener;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeDataInputStream;
import com.gemstone.gemfire.internal.shared.unsafe.ChannelBufferUnsafeDataOutputStream;
import com.gemstone.gemfire.internal.size.ReflectionSingleObjectSizer;
import com.gemstone.gemfire.internal.util.ArraySortedCollectionWithOverflow;
import com.gemstone.gemfire.internal.util.SortDuplicateObserver;
import com.gemstone.gemfire.internal.util.TIntObjectHashMapWithDups;
import com.gemstone.gnu.trove.TIntArrayList;
import com.gemstone.gnu.trove.TObjectHashingStrategy;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.jdbc.GemFireXDRuntimeException;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRow;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OffHeapRowWithLobs;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortObserver;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanControllerRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Sort;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataType;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.io.DirFile;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.ArraySortScan;
import com.pivotal.gemfirexd.internal.impl.store.access.sort.MergeSortInfo;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Comparator;

public final class ArraySorter
extends ArraySortedCollectionWithOverflow
implements Sort,
SortController {
    static final int DEFAULT_MAX_ARRAY_SIZE = 65536;
    static final TIntArrayList ZERO_LIST = new TIntArrayList(0);
    static final long BASE_CLASS_OVERHEAD = ReflectionSingleObjectSizer.sizeof(ArraySorter.class);
    final ExecRowSerializer serializer = new ExecRowSerializer();
    GemFireTransaction tran;
    final SortObserver sortObserver;
    private int numRowsInput;
    private int numRowsOutput;
    private TIntArrayList mergeRunsSize;
    private static final ObjectSizer rowSizer = new ObjectSizer(){

        public int sizeof(Object o) {
            try {
                long size = ((ExecRow)o).estimateRowSize();
                return size < Integer.MAX_VALUE ? (int)size : Integer.MAX_VALUE;
            }
            catch (StandardException se) {
                throw new GemFireXDRuntimeException(se);
            }
        }
    };

    protected ArraySorter(GemFireTransaction tran, RowCompare comparator, SortObserver sortObserver, int maxUnsortedArraySize, long maxSortLimit, MemoryThresholdListener mtl, String overflowDir, GemFireCacheImpl cache) {
        super((Comparator)comparator, (SortDuplicateObserver)sortObserver, (TObjectHashingStrategy)comparator, rowSizer, maxUnsortedArraySize, maxSortLimit, mtl, overflowDir, cache);
        this.tran = tran;
        this.sortObserver = sortObserver;
        this.mergeRunsSize = ZERO_LIST;
    }

    public static ArraySorter create(GemFireTransaction tran, ColumnOrdering[] columnOrdering, SortObserver sortObserver, boolean alreadyInOrder, long estimatedRows, int estimatedRowSize, long maxSortLimit) {
        String overflowDir;
        GemFireStore store = Misc.getMemStore();
        DirFile tmpDir = store.getDatabase().getTempDir();
        if (tmpDir != null) {
            overflowDir = tmpDir.getAbsolutePath();
        } else {
            overflowDir = PropertyUtil.getSystemProperty("java.io.tmpdir");
            if (overflowDir == null) {
                overflowDir = ".";
            }
        }
        if (estimatedRows <= 1L || estimatedRows > 32768L) {
            estimatedRows = 32768L;
        }
        return new ArraySorter(tran, new RowCompare(columnOrdering), sortObserver, (int)(estimatedRows << 1), maxSortLimit, store.thresholdListener(), overflowDir, store.getGemFireCache());
    }

    public final ExecRowSerializer getDataSerializer() {
        return this.serializer;
    }

    protected ArraySortedCollectionWithOverflow.OverflowData overflowElementArray(Object[] elements) {
        ArraySortedCollectionWithOverflow.OverflowData overflowData = super.overflowElementArray(elements);
        if (this.mergeRunsSize == ZERO_LIST) {
            this.mergeRunsSize = new TIntArrayList();
        }
        this.mergeRunsSize.add(overflowData.size());
        return overflowData;
    }

    protected int writeElements(Object[] elements, ChannelBufferUnsafeDataOutputStream dos) throws IOException {
        int numElements = 0;
        ExecRowSerializer rowSerializer = this.serializer;
        for (Object element : elements) {
            if (element == null) break;
            ExecRow row = (ExecRow)element;
            rowSerializer.toData(row, (DataOutput)dos);
            ++numElements;
        }
        return numElements;
    }

    protected Object readElement(ChannelBufferUnsafeDataInputStream in) throws ClassNotFoundException, IOException {
        return this.serializer.fromData((DataInput)in);
    }

    @Override
    public boolean insert(ExecRow row) throws StandardException {
        ++this.numRowsInput;
        SortObserver sortObserver = this.sortObserver;
        if (sortObserver != null && (row = sortObserver.insertNonDuplicateKey(row)) == null) {
            return false;
        }
        try {
            if (super.add((Object)row)) {
                ++this.numRowsOutput;
                return true;
            }
            return false;
        }
        catch (GemFireXDRuntimeException re) {
            if (re.getCause() instanceof StandardException) {
                throw (StandardException)re.getCause();
            }
            throw re;
        }
    }

    @Override
    public long estimateMemoryUsage(ExecRow sortResultRow) throws StandardException {
        long estimatedRowSize;
        TIntObjectHashMapWithDups dups;
        long numMemElements = 0L;
        long overheads = BASE_CLASS_OVERHEAD;
        Object[] elements = this.elements;
        overheads += (long)(elements.length * (ReflectionSingleObjectSizer.OBJECT_SIZE + ReflectionSingleObjectSizer.REFERENCE_SIZE));
        if (this.overflowOutputChannel != null) {
            overheads += 64L;
        }
        int currentArrayIndex = this.currentArrayIndex;
        for (int i = 0; i < currentArrayIndex; ++i) {
            Object elementArray = elements[i];
            if (elementArray instanceof Object[]) {
                Object[] elems = (Object[])elementArray;
                numMemElements += (long)elems.length;
                overheads += (long)(4 + elems.length * ReflectionSingleObjectSizer.REFERENCE_SIZE);
                continue;
            }
            overheads += (long)((ArraySortedCollectionWithOverflow.OverflowData)elementArray).bufferSize() + ArraySortedCollectionWithOverflow.OverflowData.BASE_CLASS_OVERHEAD;
        }
        Object[] currentArray = this.currentArray;
        if (currentArray != null) {
            numMemElements += (long)this.currentArrayPos;
            overheads += (long)(4 + currentArray.length * ReflectionSingleObjectSizer.REFERENCE_SIZE);
        }
        if ((dups = this.hashCodeToObjectMapWithDups) != null) {
            overheads += (long)(dups.capacity() * (5 + ReflectionSingleObjectSizer.REFERENCE_SIZE));
            overheads += (long)(3 * ReflectionSingleObjectSizer.OBJECT_SIZE);
        }
        if ((estimatedRowSize = (long)this.estimatedObjectSize) <= 0L) {
            estimatedRowSize = sortResultRow != null ? sortResultRow.estimateRowSize() : 1L;
        }
        return overheads + numMemElements * estimatedRowSize;
    }

    @Override
    public void completedInserts() {
        GemFireTransaction tran = this.tran;
        if (tran != null) {
            tran.closeMe(this);
            this.tran = null;
        }
    }

    public void clear() {
        super.clear();
        this.tran = null;
        this.numRowsInput = 0;
        this.numRowsOutput = 0;
        this.mergeRunsSize = ZERO_LIST;
    }

    @Override
    public SortInfo getSortInfo() throws StandardException {
        return new MergeSortInfo("external", this.numRowsInput, this.numRowsOutput, this.numOverflowedElements(), this.mergeRunsSize, ((RowCompare)this.comparator).getNumComparisons());
    }

    @Override
    public SortController open(TransactionManager tran) throws StandardException {
        return this;
    }

    @Override
    public ScanManager openSortScan(TransactionManager tran, boolean hold) throws StandardException {
        return new ArraySortScan(this, tran, hold);
    }

    @Override
    public ScanControllerRowSource openSortRowSource(TransactionManager tran) throws StandardException {
        return new ArraySortScan(this, tran, false);
    }

    @Override
    public void drop(TransactionController tran) throws StandardException {
        super.close();
    }

    public static final class RowCompare
    implements Comparator<Object>,
    TObjectHashingStrategy {
        private static final long serialVersionUID = -2971361542262894575L;
        private final long[] columnOrderingFlags;
        private int numComparisons;

        RowCompare(ColumnOrdering[] columnOrdering) {
            this.columnOrderingFlags = new long[columnOrdering.length];
            for (int i = 0; i < columnOrdering.length; ++i) {
                ColumnOrdering order = columnOrdering[i];
                long flags = order.getIsAscending() ? 2 : 0;
                if (order.getIsNullsOrderedLow()) {
                    flags |= 4L;
                }
                this.columnOrderingFlags[i] = flags |= (long)order.getColumnId() + 1L << 32;
            }
        }

        @Override
        public final int compare(Object o1, Object o2) {
            ExecRow r1 = (ExecRow)o1;
            ExecRow r2 = (ExecRow)o2;
            ++this.numComparisons;
            long[] columnOrderingFlags = this.columnOrderingFlags;
            int colsToCompare = columnOrderingFlags.length;
            try {
                for (int i = 0; i < colsToCompare; ++i) {
                    long flags = columnOrderingFlags[i];
                    int column = (int)(flags >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                    int iflags = (int)(flags & 0xFFFFFFFFFFFFFFFFL);
                    int r = r1.compare(r2, column, iflags > 2);
                    if (r == 0) continue;
                    return r * ((iflags & 2) - 1);
                }
                return 0;
            }
            catch (StandardException se) {
                throw new GemFireXDRuntimeException(se);
            }
        }

        public final int getNumComparisons() {
            return this.numComparisons;
        }

        public final int computeHashCode(Object o) {
            ExecRow r = (ExecRow)o;
            long[] columnOrderingFlags = this.columnOrderingFlags;
            int colsToCompare = columnOrderingFlags.length;
            int hash = 0;
            for (int i = 0; i < colsToCompare; ++i) {
                int column = (int)(columnOrderingFlags[i] >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                hash = r.computeHashCode(column, hash);
            }
            return hash;
        }

        public final boolean equals(Object o1, Object o2) {
            ExecRow r1 = (ExecRow)o1;
            ExecRow r2 = (ExecRow)o2;
            ++this.numComparisons;
            long[] columnOrderingFlags = this.columnOrderingFlags;
            int colsToCompare = columnOrderingFlags.length;
            try {
                for (int i = 0; i < colsToCompare; ++i) {
                    int column = (int)(columnOrderingFlags[i] >>> 32 & 0xFFFFFFFFFFFFFFFFL);
                    if (r1.compare(r2, column, false) == 0) continue;
                    return false;
                }
                return true;
            }
            catch (StandardException se) {
                throw new GemFireXDRuntimeException(se);
            }
        }
    }

    public static final class ExecRowSerializer
    extends DataSerializer {
        private ExecRow templateRow;
        private GemFireContainer container;
        private RowFormatter formatter;
        private byte rowType;
        private static final byte BYTEARRAY = 1;
        private static final byte ARRAY_OF_BYTEARRAY = 2;
        private static final byte OFFHEAP_ROW = 3;
        private static final byte OFFHEAP_ROW_WITH_LOBS = 4;
        private static final byte DVDARRAY = 5;
        private static final byte DYNAMIC = 6;
        private int rowsWritten;
        private int rowsRead;

        private static byte getRowType(Object rowData) {
            Class<?> cls = rowData.getClass();
            if (cls == byte[].class) {
                return 1;
            }
            if (cls == byte[][].class) {
                return 2;
            }
            if (cls == OffHeapRow.class) {
                return 3;
            }
            if (cls == OffHeapRowWithLobs.class) {
                return 4;
            }
            if (cls == DataValueDescriptor[].class) {
                return 5;
            }
            SanityManager.THROWASSERT((String)("ExecRowSerializer: unknown row format " + cls + ": " + rowData));
            throw new AssertionError((Object)"not expected to be reached");
        }

        void initialize(Object rowData) {
            boolean useRowTypeOnly = true;
            if (this.container != null) {
                useRowTypeOnly = this.container.isOffHeap() ? false : (this.container.hasLobs() ? this.container.hasLobsInAllSchema() : !this.container.hasLobsInAnySchema());
            }
            this.rowType = useRowTypeOnly ? ExecRowSerializer.getRowType(rowData) : (byte)6;
            if (GemFireXDUtils.TraceTempFileIO) {
                SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Writing rows of type = " + ExecRowSerializer.getRowType(this.rowType)));
            }
        }

        private static String getRowType(byte rowType) {
            switch (rowType) {
                case 1: {
                    return "BYTEARRAY";
                }
                case 2: {
                    return "ARRAY_OF_BYTEARRAY";
                }
                case 3: {
                    return "OFFHEAP_ROW";
                }
                case 4: {
                    return "OFFHEAP_ROW_WITH_LOBS";
                }
                case 5: {
                    return "DVDARRAY";
                }
                case 6: {
                    return "DYNAMIC";
                }
            }
            return "UNKNOWN";
        }

        public boolean toData(Object o, DataOutput out) throws IOException {
            return this.toData((ExecRow)o, out);
        }

        final boolean toData(ExecRow row, DataOutput out) throws IOException {
            byte rowType;
            Object rowData = row.getRawRowValue(false);
            if (this.rowType == 0) {
                this.templateRow = row;
                if (row instanceof AbstractCompactExecRow) {
                    this.formatter = ((AbstractCompactExecRow)row).getRowFormatter();
                    this.container = this.formatter.container;
                    if (this.formatter.isTableFormatter() && this.formatter.container.singleSchema == null) {
                        this.formatter = null;
                    }
                }
                this.initialize(rowData);
            }
            if ((rowType = this.rowType) == 6) {
                rowType = ExecRowSerializer.getRowType(rowData);
                out.writeByte(rowType);
            }
            switch (rowType) {
                case 2: {
                    DataSerializer.writeArrayOfByteArrays((byte[][])((byte[][])rowData), (DataOutput)out);
                    break;
                }
                case 1: {
                    DataSerializer.writeByteArray((byte[])((byte[])rowData), (DataOutput)out);
                    break;
                }
                case 3: {
                    OffHeapRow bs = (OffHeapRow)((Object)rowData);
                    if (bs != null) {
                        if (GemFireXDUtils.TraceTempFileIO) {
                            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Writing OffHeap data of length " + bs.getLength()));
                        }
                        bs.toData(out);
                        break;
                    }
                    DataSerializer.writeByteArray(null, (DataOutput)out);
                    break;
                }
                case 4: {
                    OffHeapRowWithLobs bsLobs = (OffHeapRowWithLobs)((Object)rowData);
                    if (bsLobs != null) {
                        if (GemFireXDUtils.TraceTempFileIO) {
                            SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)("Writing OffHeap lobs data of length " + bsLobs.getLength()));
                        }
                        bsLobs.toData(out);
                        break;
                    }
                    DataSerializer.writeArrayOfByteArrays((byte[][])null, (DataOutput)out);
                    break;
                }
                default: {
                    DataValueDescriptor[] dvds = (DataValueDescriptor[])rowData;
                    if (GemFireXDUtils.TraceTempFileIO) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Writing DataValueDescriptors of length ").append(dvds.length);
                        sb.append(" values ");
                        try {
                            StringBuilder dvdS = this.toString(dvds, new StringBuilder());
                            sb.append((CharSequence)dvdS);
                        }
                        catch (StandardException se) {
                            throw new GemFireXDRuntimeException(se);
                        }
                        SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)sb.toString());
                    }
                    DataType.writeDVDArray(dvds, out);
                }
            }
            DataSerializer.writeTreeSet(row.getAllRegionAndKeyInfo(), (DataOutput)out);
            ++this.rowsWritten;
            return true;
        }

        public Object fromData(DataInput in) throws IOException, ClassNotFoundException {
            ExecRow row;
            byte rowType = this.rowType;
            if (rowType == 6) {
                rowType = in.readByte();
            }
            switch (rowType) {
                case 1: 
                case 3: {
                    byte[] bytes = DataSerializer.readByteArray((DataInput)in);
                    GemFireContainer container = this.container;
                    RowFormatter formatter = this.formatter;
                    row = container.newExecRowFromBytes(bytes, formatter != null ? formatter : container.getRowFormatter(bytes));
                    break;
                }
                case 2: 
                case 4: {
                    byte[][] byteArrays = DataSerializer.readArrayOfByteArrays((DataInput)in);
                    GemFireContainer container = this.container;
                    RowFormatter formatter = this.formatter;
                    row = container.newExecRowFromByteArrays(byteArrays, formatter != null ? formatter : container.getRowFormatter(byteArrays));
                    break;
                }
                default: {
                    DataValueDescriptor[] dvds = DataType.readDVDArray(in);
                    if (GemFireXDUtils.TraceTempFileIO) {
                        StringBuilder sb = new StringBuilder();
                        sb.append("Read DataValueDescriptors of length ").append(dvds.length);
                        sb.append(" values ");
                        try {
                            StringBuilder dvdS = this.toString(dvds, new StringBuilder());
                            sb.append((CharSequence)dvdS);
                        }
                        catch (StandardException se) {
                            throw new GemFireXDRuntimeException(se);
                        }
                        SanityManager.DEBUG_PRINT((String)"TraceTempFileIO", (String)sb.toString());
                    }
                    row = this.templateRow.getNewNullRow();
                    row.setRowArray(dvds);
                }
            }
            row.setAllRegionAndKeyInfo(DataSerializer.readTreeSet((DataInput)in));
            ++this.rowsRead;
            return row;
        }

        public int getRowsWritten() {
            return this.rowsWritten;
        }

        public int getRowsRead() {
            return this.rowsRead;
        }

        public ExecRow getTemplateRow() {
            return this.templateRow;
        }

        private StringBuilder toString(DataValueDescriptor[] dvd, StringBuilder sb) throws StandardException {
            for (int i = 0; i < dvd.length; ++i) {
                sb.append(dvd[i].getString()).append("(").append(dvd[i].getTypeName()).append("),");
            }
            return sb;
        }

        public int getId() {
            throw new InternalGemFireError("ExecRowSerializer.getId: not expected to be invoked");
        }

        public Class<?>[] getSupportedClasses() {
            throw new InternalGemFireError("ExecRowSerializer.getSupportedClasses: not expected to be invoked");
        }
    }
}

