/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.heap;

import com.gemstone.gemfire.cache.execute.FunctionContext;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.cache.ClassSize;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.StoreCostController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.Conglomerate;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.ScanManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerHandle;
import com.pivotal.gemfirexd.internal.iapi.store.raw.ContainerKey;
import com.pivotal.gemfirexd.internal.iapi.store.raw.LockingPolicy;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Page;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.ConglomerateUtil;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.GenericConglomerate;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.GenericConglomerateController;
import com.pivotal.gemfirexd.internal.impl.store.access.conglomerate.OpenConglomerateScratchSpace;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapCompressScan;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapController;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapCostController;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.HeapScan;
import com.pivotal.gemfirexd.internal.impl.store.access.heap.OpenHeap;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class Heap
extends GenericConglomerate
implements Conglomerate,
StaticCompiledOpenConglomInfo {
    protected int conglom_format_id;
    private ContainerKey id;
    int[] format_ids;
    protected int[] collation_ids;
    private static final int BASE_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(Heap.class);
    private static final int CONTAINER_KEY_MEMORY_USAGE = ClassSize.estimateBaseFromCatalog(ContainerKey.class);

    @Override
    public int estimateMemoryUsage() {
        int sz = BASE_MEMORY_USAGE;
        if (null != this.id) {
            sz += CONTAINER_KEY_MEMORY_USAGE;
        }
        if (null != this.format_ids) {
            sz += this.format_ids.length * ClassSize.getIntSize();
        }
        return sz;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void create(Transaction rawtran, int segmentId, long input_containerid, DataValueDescriptor[] template, ColumnOrdering[] columnOrder, int[] collationIds, Properties properties, int conglom_format_id, int tmpFlag) throws StandardException {
        long containerid;
        if (properties != null) {
            int minimumRecordSize;
            String value = properties.getProperty("gemfirexd.storage.minimumRecordSize");
            int n = minimumRecordSize = value == null ? 12 : Integer.parseInt(value);
            if (minimumRecordSize < 12) {
                properties.put("gemfirexd.storage.minimumRecordSize", Integer.toString(12));
            }
        }
        if ((containerid = rawtran.addContainer(segmentId, input_containerid, 0, properties, tmpFlag)) < 0L) {
            throw StandardException.newException("XSCH0.S");
        }
        this.id = new ContainerKey(segmentId, containerid);
        if (template == null || template.length == 0) {
            throw StandardException.newException("XSCH4.S");
        }
        this.format_ids = ConglomerateUtil.createFormatIds(template);
        this.conglom_format_id = conglom_format_id;
        this.collation_ids = ConglomerateUtil.createCollationIds(this.format_ids.length, collationIds);
        ContainerHandle container = null;
        Page page = null;
        try {
            container = rawtran.openContainer(this.id, null, 4 | (this.isTemporary() ? 2048 : 0));
            Object[] control_row = new DataValueDescriptor[]{this};
            page = container.getPage(1L);
            page.insertAtSlot(0, control_row, null, null, (byte)8, 100);
            page.unlatch();
            page = null;
            container.setEstimatedRowCount(0L, 0);
        }
        finally {
            if (container != null) {
                container.close();
            }
            if (page != null) {
                page.unlatch();
            }
        }
    }

    public void boot_create(long containerid, DataValueDescriptor[] template) {
        this.id = new ContainerKey(0L, containerid);
        this.format_ids = ConglomerateUtil.createFormatIds(template);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void addColumn(TransactionManager xact_manager, int column_id, Storable template_column, int collation_id) throws StandardException {
        ContainerHandle container = null;
        Page page = null;
        Transaction rawtran = xact_manager.getRawStoreXact();
        try {
            container = rawtran.openContainer(this.id, rawtran.newLockingPolicy(2, 5, true), 4 | (this.isTemporary() ? 2048 : 0));
            if (column_id != this.format_ids.length) {
                SanityManager.THROWASSERT((String)("column_id = " + column_id + "format_ids.length = " + this.format_ids.length + "format_ids = " + this.format_ids));
                throw StandardException.newException("XSCH5.S", (Object)new Long(column_id), (Object)new Long(this.format_ids.length));
            }
            int[] old_format_ids = this.format_ids;
            this.format_ids = new int[old_format_ids.length + 1];
            System.arraycopy(old_format_ids, 0, this.format_ids, 0, old_format_ids.length);
            this.format_ids[old_format_ids.length] = template_column.getTypeFormatId();
            int[] old_collation_ids = this.collation_ids;
            this.collation_ids = new int[old_collation_ids.length + 1];
            System.arraycopy(old_collation_ids, 0, this.collation_ids, 0, old_collation_ids.length);
            this.collation_ids[old_collation_ids.length] = collation_id;
            Object[] control_row = new DataValueDescriptor[]{this};
            page = container.getPage(1L);
            page.updateAtSlot(0, control_row, null);
            page.unlatch();
            page = null;
        }
        finally {
            if (container != null) {
                container.close();
            }
            if (page != null) {
                page.unlatch();
            }
        }
    }

    @Override
    public void drop(TransactionManager xact_manager) throws StandardException {
        xact_manager.getRawStoreXact().dropContainer(this.id);
    }

    @Override
    public boolean fetchMaxOnBTree(TransactionManager xact_manager, Transaction rawtran, long conglomId, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] fetchRow) throws StandardException {
        throw StandardException.newException("XSCH8.S");
    }

    @Override
    public final ContainerKey getId() {
        return this.id;
    }

    @Override
    public final long getContainerid() {
        return this.id.getContainerId();
    }

    @Override
    public DynamicCompiledOpenConglomInfo getDynamicCompiledConglomInfo() throws StandardException {
        return new OpenConglomerateScratchSpace(this.format_ids, this.collation_ids);
    }

    @Override
    public StaticCompiledOpenConglomInfo getStaticCompiledConglomInfo(TransactionController tc, long conglomId) throws StandardException {
        return this;
    }

    @Override
    public boolean isTemporary() {
        return this.id.getSegmentId() == -1L;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long load(TransactionManager xact_manager, boolean createConglom, RowLocationRetRowSource rowSource) throws StandardException {
        long num_rows_loaded = 0L;
        try (HeapController heapcontroller = new HeapController();){
            num_rows_loaded = heapcontroller.load(xact_manager, this, createConglom, rowSource);
        }
        return num_rows_loaded;
    }

    @Override
    public ConglomerateController open(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        OpenHeap open_conglom = new OpenHeap();
        if (open_conglom.init(null, this, this.format_ids, this.collation_ids, xact_manager, rawtran, hold, open_mode, lock_level, locking_policy, dynamic_info) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()).toString());
        }
        HeapController heapcontroller = new HeapController();
        heapcontroller.init(open_conglom);
        return heapcontroller;
    }

    @Override
    public ScanManager openScan(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info) throws StandardException {
        if (!RowUtil.isRowEmpty(startKeyValue) || !RowUtil.isRowEmpty(stopKeyValue)) {
            throw StandardException.newException("XSCH8.S");
        }
        OpenHeap open_conglom = new OpenHeap();
        if (open_conglom.init(null, this, this.format_ids, this.collation_ids, xact_manager, rawtran, hold, open_mode, lock_level, locking_policy, dynamic_info) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
        }
        HeapScan heapscan = new HeapScan();
        heapscan.init(open_conglom, scanColumnList, startKeyValue, startSearchOperator, qualifier, stopKeyValue, stopSearchOperator);
        return heapscan;
    }

    public ScanManager openScan(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level, FormatableBitSet scanColumnList, DataValueDescriptor[] startKeyValue, int startSearchOperator, Qualifier[][] qualifier, DataValueDescriptor[] stopKeyValue, int stopSearchOperator, StaticCompiledOpenConglomInfo static_info, DynamicCompiledOpenConglomInfo dynamic_info, FunctionContext fc) throws StandardException {
        throw new AssertionError((Object)"Open scan with local data set should never be calledon Heap.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void purgeConglomerate(TransactionManager xact_manager, Transaction rawtran) throws StandardException {
        OpenHeap open_for_ddl_lock = null;
        GenericConglomerateController heapcontroller = null;
        TransactionController nested_xact = null;
        try {
            open_for_ddl_lock = new OpenHeap();
            if (open_for_ddl_lock.init(null, this, this.format_ids, this.collation_ids, xact_manager, rawtran, false, 4, 6, null, null) == null) {
                throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
            }
            OpenHeap open_conglom = new OpenHeap();
            nested_xact = (TransactionManager)xact_manager.startNestedUserTransaction(false);
            if (open_conglom.init(null, this, this.format_ids, this.collation_ids, (TransactionManager)nested_xact, nested_xact.getRawStoreXact(), true, 4, 6, nested_xact.getRawStoreXact().newLockingPolicy(1, 4, true), null) == null) {
                throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()).toString());
            }
            heapcontroller = new HeapController();
            heapcontroller.init(open_conglom);
            Page page = open_conglom.getContainer().getFirstPage();
            boolean purgingDone = false;
            while (page != null) {
                long pageno = page.getPageNumber();
                purgingDone = ((HeapController)heapcontroller).purgeCommittedDeletes(page);
                if (purgingDone) {
                    page = null;
                    open_conglom.getXactMgr().commitNoSync(1);
                    heapcontroller.closeForEndTransaction(false);
                    open_conglom.reopen();
                } else {
                    page.unlatch();
                    page = null;
                }
                page = open_conglom.getContainer().getNextPage(pageno);
            }
        }
        finally {
            if (open_for_ddl_lock != null) {
                open_for_ddl_lock.close();
            }
            if (heapcontroller != null) {
                heapcontroller.close();
            }
            if (nested_xact != null) {
                nested_xact.commitNoSync(1);
                nested_xact.destroy();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void compressConglomerate(TransactionManager xact_manager, Transaction rawtran) throws StandardException {
        HeapController heapcontroller = null;
        try (OpenHeap open_conglom = null;){
            open_conglom = new OpenHeap();
            if (open_conglom.init(null, this, this.format_ids, this.collation_ids, xact_manager, rawtran, false, 4, 7, rawtran.newLockingPolicy(2, 4, true), null) == null) {
                throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
            }
            heapcontroller = new HeapController();
            heapcontroller.init(open_conglom);
            open_conglom.getContainer().compressContainer();
        }
    }

    @Override
    public ScanManager defragmentConglomerate(TransactionManager xact_manager, Transaction rawtran, boolean hold, int open_mode, int lock_level, LockingPolicy locking_policy, int isolation_level) throws StandardException {
        OpenHeap open_conglom = new OpenHeap();
        if (open_conglom.init(null, this, this.format_ids, this.collation_ids, xact_manager, rawtran, hold, open_mode, lock_level, rawtran.newLockingPolicy(1, 4, true), null) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
        }
        HeapCompressScan heap_compress_scan = new HeapCompressScan();
        heap_compress_scan.init(open_conglom, null, null, 0, null, null, 0);
        return heap_compress_scan;
    }

    @Override
    public StoreCostController openStoreCost(TransactionManager xact_manager, Transaction rawtran) throws StandardException {
        OpenHeap open_conglom = new OpenHeap();
        if (open_conglom.init(null, this, this.format_ids, this.collation_ids, xact_manager, rawtran, false, 8, 7, null, null) == null) {
            throw StandardException.newException("XSCH1.S", new Long(this.id.getContainerId()));
        }
        HeapCostController heapcost = new HeapCostController();
        heapcost.init(open_conglom);
        return heapcost;
    }

    public String toString() {
        return this.id == null ? "null" : this.id.toString();
    }

    @Override
    public DataValueDescriptor getConglom() {
        return this;
    }

    @Override
    public int getTypeFormatId() {
        return 467;
    }

    @Override
    public boolean isNull() {
        return this.id == null;
    }

    @Override
    public void restoreToNull() {
        this.id = null;
    }

    protected void writeExternal_v10_2(ObjectOutput out) throws IOException {
        FormatIdUtil.writeFormatIdInteger(out, this.conglom_format_id);
        out.writeInt((int)this.id.getSegmentId());
        out.writeLong(this.id.getContainerId());
        out.writeInt(this.format_ids.length);
        ConglomerateUtil.writeFormatIdArray(this.format_ids, out);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        this.writeExternal_v10_2(out);
        if (this.conglom_format_id == 467) {
            ConglomerateUtil.writeCollationIdArray(this.collation_ids, out);
        }
    }

    private final void localReadExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.conglom_format_id = FormatIdUtil.readFormatIdInteger(in);
        int segmentid = in.readInt();
        long containerid = in.readLong();
        this.id = new ContainerKey(segmentid, containerid);
        int num_columns = in.readInt();
        this.format_ids = ConglomerateUtil.readFormatIdArray(num_columns, in);
        this.collation_ids = new int[this.format_ids.length];
        for (int i = 0; i < this.format_ids.length; ++i) {
            this.collation_ids[i] = 0;
        }
        if (this.conglom_format_id == 467) {
            ConglomerateUtil.readCollationIdArray(this.collation_ids, in);
        } else if (this.conglom_format_id != 91) {
            SanityManager.THROWASSERT((String)("Unexpected format id: " + this.conglom_format_id));
        }
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.localReadExternal(in);
    }

    @Override
    public void readExternalFromArray(ArrayInputStream in) throws IOException, ClassNotFoundException {
        this.localReadExternal(in);
    }
}

