/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access.conglomerate;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.Storable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.raw.Transaction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;

public final class TemplateRow {
    private TemplateRow() {
    }

    private static DataValueDescriptor[] allocate_objects(Transaction rawtran, int num_cols_to_allocate, FormatableBitSet column_list, int[] format_ids, int[] collation_ids) throws StandardException {
        DataValueDescriptor[] ret_row = new DataValueDescriptor[num_cols_to_allocate];
        int num_cols = column_list == null ? format_ids.length : column_list.getLength();
        DataValueFactory dvf = rawtran.getDataValueFactory();
        for (int i = 0; i < num_cols; ++i) {
            if (column_list != null && !column_list.get(i)) continue;
            ret_row[i] = dvf.getNull(format_ids[i], collation_ids[i]);
            DataValueDescriptor o = ret_row[i];
            if (o == null) {
                SanityManager.THROWASSERT((String)("obj from DataValueFactory.newNull(" + format_ids[i] + ", " + collation_ids[i] + ") null.;src column position = " + i + ";dest column position = " + i + ";num_cols = " + num_cols + ";format_ids.length = " + format_ids.length));
            }
            if (o instanceof Storable) continue;
            SanityManager.THROWASSERT((String)("object:(" + o.getClass() + "):(" + o + ") not an instanceof Storable"));
        }
        return ret_row;
    }

    public static DataValueDescriptor[] newU8Row(int nkeys) {
        DataValueDescriptor[] columns = new DataValueDescriptor[nkeys];
        for (int i = 0; i < columns.length; ++i) {
            columns[i] = new SQLLongint(Long.MIN_VALUE);
        }
        return columns;
    }

    public static DataValueDescriptor[] newRow(DataValueDescriptor[] template) throws StandardException {
        DataValueDescriptor[] columns = new DataValueDescriptor[template.length];
        int i = template.length;
        while (i-- > 0) {
            columns[i] = template[i].getNewNull();
        }
        return columns;
    }

    public static DataValueDescriptor[] newRow(Transaction rawtran, FormatableBitSet column_list, int[] format_ids, int[] collation_ids) throws StandardException {
        return TemplateRow.allocate_objects(rawtran, format_ids.length, column_list, format_ids, collation_ids);
    }

    public static DataValueDescriptor[] newBranchRow(Transaction rawtran, int[] format_ids, int[] collation_ids, DataValueDescriptor page_ptr) throws StandardException {
        DataValueDescriptor[] columns = TemplateRow.allocate_objects(rawtran, format_ids.length + 1, null, format_ids, collation_ids);
        columns[format_ids.length] = page_ptr;
        return columns;
    }

    public static boolean checkColumnTypes(DataValueFactory dvf, int[] format_ids, int[] collation_ids, DataValueDescriptor[] row) throws StandardException {
        boolean ret_val = true;
        int nCols = row.length;
        if (format_ids.length != row.length) {
            SanityManager.THROWASSERT((String)("format_ids[] length (" + format_ids.length + ") expected to be = row length (" + row.length + ")"));
            ret_val = false;
        } else {
            for (int colid = 0; colid < nCols; ++colid) {
                DataValueDescriptor column = row[colid];
                if (column == null) {
                    SanityManager.THROWASSERT((String)("column[" + colid + "] is null"));
                }
                DataValueDescriptor column_template = dvf.getNull(format_ids[colid], collation_ids[colid]);
                if (column.getClass() == column_template.getClass()) continue;
                SanityManager.DEBUG_PRINT((String)"check", (String)("row = " + RowUtil.toString(row)));
                SanityManager.THROWASSERT((String)("input column[" + colid + "] (" + column.getClass() + ") did not match expected template class (" + column_template.getClass() + ")\ncolumn value = " + column + "\nformat_ids = " + ArrayUtil.toString(format_ids) + "\ncollation  = " + ArrayUtil.toString(collation_ids)));
            }
        }
        return ret_val;
    }

    public static boolean checkPartialColumnTypes(int[] format_ids, FormatableBitSet validColumns, int[] fieldStates, DataValueDescriptor[] row) throws StandardException {
        boolean ret_val = true;
        return ret_val;
    }
}

