/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.store.access;

import com.gemstone.gemfire.cache.AttributesFactory;
import com.gemstone.gemfire.cache.Scope;
import com.pivotal.gemfirexd.internal.engine.GfxdConstants;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.services.locks.CompatibilitySpace;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockFactory;
import com.pivotal.gemfirexd.internal.iapi.services.locks.LockOwner;
import com.pivotal.gemfirexd.internal.iapi.services.locks.ShExQual;
import com.pivotal.gemfirexd.internal.iapi.services.monitor.Monitor;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyFactory;
import com.pivotal.gemfirexd.internal.iapi.services.property.PropertyUtil;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.store.access.AccessFactory;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.store.access.conglomerate.TransactionManager;
import com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.UserType;
import com.pivotal.gemfirexd.internal.impl.store.access.CacheLock;
import com.pivotal.gemfirexd.internal.impl.store.access.PC_XenaVersion;
import com.pivotal.gemfirexd.internal.impl.store.access.RAMTransaction;
import com.pivotal.gemfirexd.internal.impl.store.access.UTF;
import com.pivotal.gemfirexd.internal.impl.store.access.UTFQualifier;
import java.io.Serializable;
import java.util.Dictionary;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;

class PropertyConglomerate {
    protected long propertiesConglomId;
    protected Properties serviceProperties;
    private LockFactory lf;
    private Dictionary cachedSet;
    private CacheLock cachedLock;
    private PropertyFactory pf;

    PropertyConglomerate(TransactionController tc, boolean create, Properties serviceProperties, PropertyFactory pf) throws StandardException {
        this.pf = pf;
        if (!create) {
            String id = serviceProperties.getProperty("gemfirexd.storage.propertiesId");
            if (id == null) {
                create = true;
            } else {
                try {
                    this.propertiesConglomId = Long.valueOf(id);
                }
                catch (NumberFormatException nfe) {
                    throw Monitor.exceptionStartingModule(nfe);
                }
            }
        }
        if (create) {
            DataValueDescriptor[] template = this.makeNewTemplate();
            Properties conglomProperties = new Properties();
            conglomProperties.put("gemfirexd.storage.pageSize", "2048");
            conglomProperties.put("gemfirexd.storage.pageReservedSpace", "0");
            AttributesFactory af = new AttributesFactory();
            af.setScope(Scope.LOCAL);
            af.setConcurrencyChecksEnabled(false);
            conglomProperties.put("GEMFIRE_REGION_ATTRIBUTES", af.create());
            conglomProperties.setProperty(GfxdConstants.PROPERTY_SCHEMA_NAME, "SYS");
            conglomProperties.setProperty(GfxdConstants.PROPERTY_TABLE_NAME, "Properties_{id}");
            this.propertiesConglomId = tc.createConglomerate("heap", template, null, null, conglomProperties, 0);
            serviceProperties.put("gemfirexd.storage.propertiesId", Long.toString(this.propertiesConglomId));
        }
        this.serviceProperties = serviceProperties;
        this.lf = ((RAMTransaction)tc).getAccessManager().getLockFactory();
        this.cachedLock = new CacheLock(this);
        PC_XenaVersion softwareVersion = new PC_XenaVersion();
        if (create) {
            this.setProperty(tc, "PropertyConglomerateVersion", softwareVersion, true);
        } else {
            softwareVersion.upgradeIfNeeded(tc, this, serviceProperties);
        }
        this.getCachedDbProperties(tc);
    }

    private DataValueDescriptor[] makeNewTemplate(String key, Serializable value) {
        DataValueDescriptor[] template = new DataValueDescriptor[]{new UTF(key), new UserType(value)};
        return template;
    }

    private DataValueDescriptor[] makeNewTemplate() {
        DataValueDescriptor[] template = new DataValueDescriptor[]{new UTF(), new UserType()};
        return template;
    }

    private ScanController openScan(TransactionController tc, String key, int open_mode) throws StandardException {
        Qualifier[][] qualifiers = null;
        if (key != null) {
            qualifiers = new Qualifier[][]{new Qualifier[1]};
            qualifiers[0][0] = new UTFQualifier(0, key);
        }
        ScanController scan = tc.openScan(this.propertiesConglomId, false, open_mode, 7, 5, null, null, 0, qualifiers, null, 0, null);
        return scan;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setPropertyDefault(TransactionController tc, String key, Serializable value) throws StandardException {
        this.lockProperties(tc);
        Serializable valueToSave = null;
        if (this.propertyDefaultIsVisible(tc, key)) {
            valueToSave = this.validateApplyAndMap(tc, key, value, false);
        } else {
            PropertyConglomerate propertyConglomerate = this;
            synchronized (propertyConglomerate) {
                Hashtable defaults = new Hashtable();
                this.getProperties(tc, defaults, false, true);
                this.validate(key, value, defaults);
                valueToSave = this.map(key, value, defaults);
            }
        }
        this.savePropertyDefault(tc, key, valueToSave);
    }

    boolean propertyDefaultIsVisible(TransactionController tc, String key) throws StandardException {
        this.lockProperties(tc);
        return this.readProperty(tc, key) == null;
    }

    void saveProperty(TransactionController tc, String key, Serializable value) throws StandardException {
        DataValueDescriptor[] row;
        if (this.saveServiceProperty(key, value)) {
            return;
        }
        ScanController scan = this.openScan(tc, key, 4);
        if (scan.fetchNext(row = this.makeNewTemplate())) {
            if (value == null) {
                scan.delete();
            } else {
                row[1] = new UserType(value);
                scan.replace(row, null);
            }
            scan.close();
        } else {
            scan.close();
            scan = null;
            if (value != null) {
                row = this.makeNewTemplate(key, value);
                ConglomerateController cc = tc.openConglomerate(this.propertiesConglomId, false, 4, 7, 5);
                cc.insert(row);
                cc.close();
            }
        }
    }

    private boolean saveServiceProperty(String key, Serializable value) {
        if (PropertyUtil.isServiceProperty(key)) {
            if (value != null) {
                this.serviceProperties.put(key, value);
            } else {
                this.serviceProperties.remove(key);
            }
            return true;
        }
        return false;
    }

    void savePropertyDefault(TransactionController tc, String key, Serializable value) throws StandardException {
        if (this.saveServiceProperty(key, value)) {
            return;
        }
        Dictionary defaults = (Dictionary)((Object)this.readProperty(tc, "gemfirexd.defaultPropertyName"));
        if (defaults == null) {
            defaults = new FormatableHashtable();
        }
        if (value == null) {
            defaults.remove(key);
        } else {
            defaults.put(key, value);
        }
        if (defaults.size() == 0) {
            defaults = null;
        }
        this.saveProperty(tc, "gemfirexd.defaultPropertyName", (Serializable)((Object)defaults));
    }

    private Serializable validateApplyAndMap(TransactionController tc, String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        Hashtable d = new Hashtable();
        this.getProperties(tc, d, false, false);
        Serializable mappedValue = this.pf.doValidateApplyAndMap(tc, key, value, d, dbOnlyProperty);
        if (key.equals("logDevice")) {
            throw StandardException.newException("XSRS8.S");
        }
        if (mappedValue == null) {
            return value;
        }
        return mappedValue;
    }

    private Serializable map(String key, Serializable value, Dictionary set) throws StandardException {
        return this.pf.doMap(key, value, set);
    }

    private void validate(String key, Serializable value, Dictionary set) throws StandardException {
        this.pf.validateSingleProperty(key, value, set);
    }

    private boolean bootPasswordChange(TransactionController tc, String key, Serializable value) throws StandardException {
        if (key.equals("bootPassword")) {
            AccessFactory af = ((TransactionManager)tc).getAccessManager();
            RawStoreFactory rsf = (RawStoreFactory)Monitor.findServiceModule(af, "com.pivotal.gemfirexd.internal.iapi.store.raw.RawStoreFactory");
            this.serviceProperties.remove("bootPassword");
            value = rsf.changeBootPassword(this.serviceProperties, value);
            this.serviceProperties.put("encryptedBootPassword", value);
            return true;
        }
        return false;
    }

    void setProperty(TransactionController tc, String key, Serializable value, boolean dbOnlyProperty) throws StandardException {
        if (value != null && !(value instanceof Formatable) && !value.getClass().getName().startsWith("java.")) {
            SanityManager.THROWASSERT((String)("Non-formattable, non-java class - " + value.getClass().getName()));
        }
        this.lockProperties(tc);
        Serializable valueToValidateAndApply = value;
        if (value == null) {
            valueToValidateAndApply = this.getPropertyDefault(tc, key);
        }
        Serializable valueToSave = this.validateApplyAndMap(tc, key, valueToValidateAndApply, dbOnlyProperty);
        if (this.bootPasswordChange(tc, key, value)) {
            return;
        }
        if (value == null) {
            this.saveProperty(tc, key, null);
        } else {
            this.saveProperty(tc, key, valueToSave);
        }
    }

    private Serializable readProperty(TransactionController tc, String key) throws StandardException {
        ScanController scan = this.openScan(tc, key, 0);
        DataValueDescriptor[] row = this.makeNewTemplate();
        boolean isThere = scan.fetchNext(row);
        scan.close();
        if (!isThere) {
            return null;
        }
        return (Serializable)((UserType)row[1]).getObject();
    }

    private Serializable getCachedProperty(TransactionController tc, String key) throws StandardException {
        Dictionary dbProps = this.getCachedDbProperties(tc);
        if (dbProps.get(key) != null) {
            return (Serializable)dbProps.get(key);
        }
        return this.getCachedPropertyDefault(tc, key, dbProps);
    }

    private Serializable getCachedPropertyDefault(TransactionController tc, String key, Dictionary dbProps) throws StandardException {
        Dictionary defaults;
        if (dbProps == null) {
            dbProps = this.getCachedDbProperties(tc);
        }
        if ((defaults = (Dictionary)dbProps.get("gemfirexd.defaultPropertyName")) == null) {
            return null;
        }
        return (Serializable)defaults.get(key);
    }

    Serializable getProperty(TransactionController tc, String key) throws StandardException {
        if (PropertyUtil.isServiceProperty(key)) {
            return this.serviceProperties.getProperty(key);
        }
        if (this.iHoldTheUpdateLock(tc)) {
            Serializable v = this.readProperty(tc, key);
            if (v != null) {
                return v;
            }
            return this.getPropertyDefault(tc, key);
        }
        return this.getCachedProperty(tc, key);
    }

    Serializable getPropertyDefault(TransactionController tc, String key) throws StandardException {
        if (this.iHoldTheUpdateLock(tc)) {
            Dictionary defaults = (Dictionary)((Object)this.readProperty(tc, "gemfirexd.defaultPropertyName"));
            if (defaults == null) {
                return null;
            }
            return (Serializable)defaults.get(key);
        }
        return this.getCachedPropertyDefault(tc, key, null);
    }

    private Dictionary copyValues(Dictionary to, Dictionary from, boolean stringsOnly) {
        if (from == null) {
            return to;
        }
        Enumeration keys = from.keys();
        while (keys.hasMoreElements()) {
            String key = (String)keys.nextElement();
            Object value = from.get(key);
            if (!(value instanceof String) && stringsOnly) continue;
            to.put(key, value);
        }
        return to;
    }

    Properties getProperties(TransactionController tc) throws StandardException {
        Properties p = new Properties();
        this.getProperties(tc, p, true, false);
        return p;
    }

    public void getProperties(TransactionController tc, Dictionary d, boolean stringsOnly, boolean defaultsOnly) throws StandardException {
        if (this.iHoldTheUpdateLock(tc)) {
            Dictionary dbProps = this.readDbProperties(tc);
            Dictionary defaults = (Dictionary)dbProps.get("gemfirexd.defaultPropertyName");
            this.copyValues(d, defaults, stringsOnly);
            if (!defaultsOnly) {
                this.copyValues(d, dbProps, stringsOnly);
            }
        } else {
            Dictionary dbProps = this.getCachedDbProperties(tc);
            Dictionary defaults = (Dictionary)dbProps.get("gemfirexd.defaultPropertyName");
            this.copyValues(d, defaults, stringsOnly);
            if (!defaultsOnly) {
                this.copyValues(d, dbProps, stringsOnly);
            }
        }
    }

    void resetCache() {
        this.cachedSet = null;
    }

    private Dictionary readDbProperties(TransactionController tc) throws StandardException {
        Object value;
        Hashtable<Object, Object> set = new Hashtable<Object, Object>();
        ScanController scan = this.openScan(tc, null, 0);
        DataValueDescriptor[] row = this.makeNewTemplate();
        while (scan.fetchNext(row)) {
            Object key = ((UserType)row[0]).getObject();
            value = ((UserType)row[1]).getObject();
            if (!(key instanceof String)) {
                SanityManager.THROWASSERT((String)("Key is not a string " + key.getClass().getName()));
            }
            ((Dictionary)set).put(key, value);
        }
        scan.close();
        for (int i = 0; i < PropertyUtil.servicePropertyList.length; ++i) {
            value = this.serviceProperties.getProperty(PropertyUtil.servicePropertyList[i]);
            if (value == null) continue;
            ((Dictionary)set).put(PropertyUtil.servicePropertyList[i], value);
        }
        return set;
    }

    private Dictionary getCachedDbProperties(TransactionController tc) throws StandardException {
        Dictionary dbProps = this.cachedSet;
        if (dbProps == null) {
            this.cachedSet = dbProps = this.readDbProperties(tc);
        }
        return dbProps;
    }

    void lockProperties(TransactionController tc) throws StandardException {
        CompatibilitySpace cs = tc.getLockSpace();
        LockOwner csGroup = cs.getOwner();
        this.lf.lockObject(cs, csGroup, this.cachedLock, ShExQual.EX, -2);
    }

    private boolean iHoldTheUpdateLock(TransactionController tc) throws StandardException {
        CompatibilitySpace cs = tc.getLockSpace();
        LockOwner csGroup = cs.getOwner();
        return this.lf.isLockHeld(cs, csGroup, this.cachedLock, ShExQual.EX);
    }
}

