/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.engine.GfxdVTITemplate;
import com.pivotal.gemfirexd.internal.engine.UpdateVTITemplate;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.sql.execute.UpdatableResultSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdInputStream;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatIdUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableHashtable;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassInspector;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecutionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.types.VariableSizeDataValue;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.GenericPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdatableVTIConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import com.pivotal.gemfirexd.internal.vti.DeferModification;
import com.pivotal.gemfirexd.internal.vti.IFastPath;
import com.pivotal.gemfirexd.internal.vti.IQualifyable;
import com.pivotal.gemfirexd.internal.vti.Pushable;
import com.pivotal.gemfirexd.internal.vti.VTIEnvironment;
import java.io.ByteArrayInputStream;
import java.io.Serializable;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;

public class VTIResultSet
extends NoPutResultSetImpl
implements CursorResultSet,
VTIEnvironment {
    public int rowsReturned;
    public String javaClassName;
    private boolean next;
    private ClassInspector classInspector;
    private GeneratedMethod row;
    private GeneratedMethod constructor;
    private PreparedStatement userPS;
    private ResultSet userVTI;
    private ExecRow allocatedRow;
    private FormatableBitSet referencedColumns;
    private boolean version2;
    private boolean reuseablePs;
    private boolean isTarget;
    private FormatableHashtable compileTimeConstants;
    private int ctcNumber;
    private boolean pushedProjection;
    private IFastPath fastPath;
    private Qualifier[][] pushedQualifiers;
    private boolean[] runtimeNullableColumn;
    private boolean isDerbyStyleTableFunction;
    private String returnType;
    private DataTypeDescriptor[] returnColumnTypes;
    private int scanIsolationLevel = 0;

    VTIResultSet(Activation activation, GeneratedMethod row, int resultSetNumber, GeneratedMethod constructor, String javaClassName, Qualifier[][] pushedQualifiers, int erdNumber, boolean version2, boolean reuseablePs, int ctcNumber, boolean isTarget, int scanIsolationLevel, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean isDerbyStyleTableFunction, String returnType) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.row = row;
        this.constructor = constructor;
        this.javaClassName = javaClassName;
        this.version2 = version2;
        this.reuseablePs = reuseablePs;
        this.isTarget = isTarget;
        this.pushedQualifiers = pushedQualifiers;
        this.scanIsolationLevel = scanIsolationLevel;
        this.isDerbyStyleTableFunction = isDerbyStyleTableFunction;
        this.returnType = returnType;
        if (erdNumber != -1) {
            this.referencedColumns = (FormatableBitSet)activation.getSavedObject(erdNumber);
        }
        this.ctcNumber = ctcNumber;
        this.compileTimeConstants = (FormatableHashtable)activation.getSavedObject(ctcNumber);
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"VTIResultSet already open");
        this.isOpen = true;
        ++this.numOpens;
        try {
            if (this.version2) {
                this.userPS = (PreparedStatement)this.constructor.invoke(this.activation);
                if (this.userPS instanceof Pushable) {
                    Pushable p = (Pushable)((Object)this.userPS);
                    if (this.referencedColumns != null) {
                        this.pushedProjection = p.pushProjection(this, this.getProjectedColList());
                    }
                }
                if (this.userPS instanceof IQualifyable) {
                    IQualifyable q = (IQualifyable)((Object)this.userPS);
                    q.setQualifiers(this, this.pushedQualifiers);
                }
                IFastPath iFastPath = this.fastPath = this.userPS instanceof IFastPath ? (IFastPath)((Object)this.userPS) : null;
                if (this.isTarget && this.userPS instanceof DeferModification && this.activation.getConstantAction() instanceof UpdatableVTIConstantAction) {
                    UpdatableVTIConstantAction constants = (UpdatableVTIConstantAction)this.activation.getConstantAction();
                    ((DeferModification)((Object)this.userPS)).modificationNotify(constants.statementType, constants.deferred);
                }
                if (this.fastPath == null || !this.fastPath.executeAsFastPath()) {
                    this.userVTI = this.userPS.executeQuery();
                }
                if (this.isTarget) {
                    this.activation.setTargetVTI(this.userVTI);
                }
            } else {
                this.userVTI = (ResultSet)this.constructor.invoke(this.activation);
                this.fastPath = this.userVTI instanceof IFastPath ? (IFastPath)((Object)this.userVTI) : null;
            }
            this.setNullableColumnList();
            if (this.userVTI instanceof UpdateVTITemplate) {
                ((UpdateVTITemplate)this.userVTI).setActivation(this.activation);
            }
            this.setSharedStateInUserVTI();
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    private boolean[] setNullableColumnList() throws SQLException, StandardException {
        if (this.runtimeNullableColumn != null) {
            return this.runtimeNullableColumn;
        }
        if (this.isDerbyStyleTableFunction) {
            int count = this.getAllocatedRow().nColumns() + 1;
            this.runtimeNullableColumn = new boolean[count];
            for (int i = 0; i < count; ++i) {
                this.runtimeNullableColumn[i] = true;
            }
            return this.runtimeNullableColumn;
        }
        if (this.userVTI == null) {
            return null;
        }
        ResultSetMetaData rsmd = this.userVTI.getMetaData();
        boolean[] nullableColumn = new boolean[rsmd.getColumnCount() + 1];
        for (int i = 1; i < nullableColumn.length; ++i) {
            nullableColumn[i] = rsmd.isNullable(i) != 0;
        }
        this.runtimeNullableColumn = nullableColumn;
        return nullableColumn;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void reopenCore() throws StandardException {
        if (this.reuseablePs) {
            if (this.userVTI == null) return;
            try {
                this.userVTI.close();
                this.userVTI = this.userPS.executeQuery();
                if (!this.isTarget) return;
                this.activation.setTargetVTI(this.userVTI);
                return;
            }
            catch (SQLException se) {
                throw StandardException.unexpectedUserException(se);
            }
        } else {
            this.close(false);
            this.openCore();
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow result = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            try {
                int action;
                if ((this.userVTI == null || this.userVTI instanceof IFastPath) && this.fastPath != null && (action = this.fastPath.nextRow(result = this.getAllocatedRow(), this)) != 0) {
                    if (action == -1) {
                        result = null;
                    } else if (action == 1) {
                        this.userVTI = this.userPS.executeQuery();
                    }
                }
                if (this.userVTI != null && !(this.userVTI instanceof IFastPath)) {
                    if (!this.userVTI.next()) {
                        if (null != this.fastPath) {
                            this.fastPath.rowsDone();
                        }
                        result = null;
                    } else {
                        result = this.getAllocatedRow();
                        this.populateFromResultSet(result);
                        if (this.fastPath != null) {
                            this.fastPath.currentRow(this.userVTI, result.getRowArray());
                        }
                    }
                }
            }
            catch (Throwable t) {
                throw StandardException.unexpectedUserException(t);
            }
        }
        this.setCurrentRow(result);
        if (result != null) {
            ++this.rowsReturned;
            ++this.rowsSeen;
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.next = false;
            if (this.userVTI != null) {
                try {
                    this.userVTI.close();
                }
                catch (SQLException se) {
                    throw StandardException.unexpectedUserException(se);
                }
                finally {
                    this.userVTI = null;
                }
            }
            if (this.userPS != null && !this.reuseablePs) {
                try {
                    this.userPS.close();
                }
                catch (SQLException se) {
                    throw StandardException.unexpectedUserException(se);
                }
                finally {
                    this.userPS = null;
                }
            }
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of VTIResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        if (this.userPS != null && !this.reuseablePs) {
            try {
                this.userPS.close();
                this.userPS = null;
            }
            catch (SQLException se) {
                throw StandardException.unexpectedUserException(se);
            }
        }
        this.finishAndRTS();
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        return time;
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.THROWASSERT((String)"RowResultSet used in positioned update/delete");
        return null;
    }

    @Override
    public ExecRow getCurrentRow() {
        SanityManager.THROWASSERT((String)"RowResultSet used in positioned update/delete");
        return null;
    }

    GeneratedMethod getVTIConstructor() {
        return this.constructor;
    }

    boolean isReuseablePs() {
        return this.reuseablePs;
    }

    private ExecRow getAllocatedRow() throws StandardException {
        if (this.allocatedRow == null) {
            this.allocatedRow = (ExecRow)this.row.invoke(this.activation);
        }
        return this.allocatedRow;
    }

    private int[] getProjectedColList() {
        FormatableBitSet refs = this.referencedColumns;
        int size = refs.getLength();
        int arrayLen = 0;
        for (int i = 0; i < size; ++i) {
            if (!refs.isSet(i)) continue;
            ++arrayLen;
        }
        int[] colList = new int[arrayLen];
        int offset = 0;
        for (int i = 0; i < size; ++i) {
            if (!refs.isSet(i)) continue;
            colList[offset++] = i + 1;
        }
        return colList;
    }

    public void populateFromResultSet(ExecRow row) throws StandardException {
        try {
            DataTypeDescriptor[] columnTypes = null;
            if (this.isDerbyStyleTableFunction) {
                columnTypes = this.getReturnColumnTypes();
            }
            boolean[] nullableColumn = this.setNullableColumnList();
            DataValueDescriptor[] columns = row.getRowArray();
            int rsColNumber = 1;
            for (int index = 0; index < columns.length; ++index) {
                if (this.referencedColumns != null && !this.referencedColumns.get(index)) {
                    if (this.pushedProjection) continue;
                    ++rsColNumber;
                    continue;
                }
                columns[index].setValueFromResultSet(this.userVTI, rsColNumber, nullableColumn[rsColNumber]);
                ++rsColNumber;
                if (!this.isDerbyStyleTableFunction) continue;
                DataTypeDescriptor dtd = columnTypes[index];
                DataValueDescriptor dvd = columns[index];
                this.cast(dtd, dvd);
            }
        }
        catch (StandardException se) {
            throw se;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    @Override
    public final int getScanIsolationLevel() {
        return this.scanIsolationLevel;
    }

    @Override
    public final boolean isCompileTime() {
        return false;
    }

    @Override
    public final String getOriginalSQL() {
        return this.activation.getPreparedStatement().getUserQueryString(this.activation.getLanguageConnectionContext());
    }

    @Override
    public final int getStatementIsolationLevel() {
        return ExecutionContext.CS_TO_JDBC_ISOLATION_LEVEL_MAP[this.getScanIsolationLevel()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     * Converted monitor instructions to comments
     * Lifted jumps to return sites
     */
    @Override
    public final void setSharedState(String key, Serializable value) {
        if (key == null) {
            return;
        }
        if (this.compileTimeConstants == null) {
            Object[] savedObjects;
            Object[] objectArray = savedObjects = this.activation.getPreparedStatement().getSavedObjects();
            // MONITORENTER : savedObjects
            this.compileTimeConstants = (FormatableHashtable)savedObjects[this.ctcNumber];
            if (this.compileTimeConstants == null) {
                this.compileTimeConstants = new FormatableHashtable();
                savedObjects[this.ctcNumber] = this.compileTimeConstants;
            }
            // MONITOREXIT : objectArray
        }
        if (value == null) {
            this.compileTimeConstants.remove(key);
            return;
        }
        this.compileTimeConstants.put(key, value);
    }

    @Override
    public Object getSharedState(String key) {
        if (key == null || this.compileTimeConstants == null) {
            return null;
        }
        return this.compileTimeConstants.get(key);
    }

    private DataTypeDescriptor[] getReturnColumnTypes() throws StandardException {
        if (this.returnColumnTypes == null) {
            TypeDescriptor td = this.thawReturnType(this.returnType);
            TypeDescriptor[] columnTypes = td.getRowTypes();
            int count = columnTypes.length;
            this.returnColumnTypes = new DataTypeDescriptor[count];
            for (int i = 0; i < count; ++i) {
                this.returnColumnTypes[i] = DataTypeDescriptor.getType(columnTypes[i]);
            }
        }
        return this.returnColumnTypes;
    }

    private TypeDescriptor thawReturnType(String ice) throws StandardException {
        try {
            byte[] bytes = FormatIdUtil.fromString(ice);
            ByteArrayInputStream bais = new ByteArrayInputStream(bytes);
            FormatIdInputStream fiis = new FormatIdInputStream(bais);
            TypeDescriptor td = (TypeDescriptor)fiis.readObject();
            return td;
        }
        catch (Throwable t) {
            throw StandardException.unexpectedUserException(t);
        }
    }

    private void cast(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        TypeId typeID = dtd.getTypeId();
        if (!typeID.isBlobTypeId() && !typeID.isClobTypeId()) {
            if (typeID.isLongVarcharTypeId()) {
                this.castLongvarchar(dtd, dvd);
            } else if (typeID.isLongVarbinaryTypeId()) {
                this.castLongvarbinary(dtd, dvd);
            } else if (typeID.isDecimalTypeId()) {
                this.castDecimal(dtd, dvd);
            } else {
                Object o = dvd.getObject();
                dvd.setObjectForCast(o, true, typeID.getCorrespondingJavaTypeName());
                if (typeID.variableLength()) {
                    VariableSizeDataValue vsdv = (VariableSizeDataValue)((Object)dvd);
                    int width = typeID.isNumericTypeId() ? dtd.getPrecision() : dtd.getMaximumWidth();
                    vsdv.setWidth(width, dtd.getScale(), false);
                }
            }
        }
    }

    private void castLongvarchar(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        if (dvd.getLength() > 32700) {
            dvd.setValue(dvd.getString().substring(0, 32700));
        }
    }

    private void castLongvarbinary(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        if (dvd.getLength() > 32700) {
            byte[] original = dvd.getBytes();
            byte[] result = new byte[32700];
            System.arraycopy(original, 0, result, 0, 32700);
            dvd.setValue(result);
        }
    }

    private void castDecimal(DataTypeDescriptor dtd, DataValueDescriptor dvd) throws StandardException {
        VariableSizeDataValue vsdv = (VariableSizeDataValue)((Object)dvd);
        vsdv.setWidth(dtd.getPrecision(), dtd.getScale(), false);
    }

    @Override
    public boolean isForUpdate() {
        if (this.userVTI instanceof UpdatableResultSet) {
            return ((UpdatableResultSet)((Object)this.userVTI)).isForUpdate();
        }
        return super.isForUpdate();
    }

    @Override
    public boolean canUpdateInPlace() {
        if (this.userVTI instanceof UpdatableResultSet) {
            return ((UpdatableResultSet)((Object)this.userVTI)).canUpdateInPlace();
        }
        return super.canUpdateInPlace();
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        if (this.userVTI instanceof UpdateVTITemplate) {
            ((UpdateVTITemplate)this.userVTI).updateRow(row);
        } else {
            super.updateRow(row);
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) {
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public void resetStatistics() {
        this.rowsReturned = 0;
        super.resetStatistics();
    }

    private void setSharedStateInUserVTI() throws SQLException {
        if (this.userVTI instanceof GfxdVTITemplate) {
            ((GfxdVTITemplate)this.userVTI).setSharedState(this.compileTimeConstants);
        }
        if (this.userVTI instanceof Pushable) {
            Pushable p = (Pushable)((Object)this.userVTI);
            if (this.referencedColumns != null) {
                this.pushedProjection = p.pushProjection(this, this.getProjectedColList());
            }
        }
        if (this.userVTI instanceof IQualifyable) {
            IQualifyable q = (IQualifyable)((Object)this.userVTI);
            q.setQualifiers(this, this.pushedQualifiers);
        }
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        GenericPreparedStatement gps;
        super.buildQueryPlan(builder, context);
        if (this.userVTI != null) {
            PlanUtils.xmlAttribute(builder, "userVTI", this.userVTI.getClass().getSimpleName());
        }
        if (this.userPS != null && (gps = this.userPS instanceof EmbedPreparedStatement ? ((EmbedPreparedStatement)this.userPS).getGPS() : (this.userPS instanceof GenericPreparedStatement ? (GenericPreparedStatement)((Object)this.userPS) : null)) != null) {
            PlanUtils.xmlAttribute(builder, "userPS", gps.getUserQueryString(this.lcc));
        }
        PlanUtils.xmlTermTag(builder, context, "VTI");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    public IFastPath getFastPath() {
        return this.fastPath;
    }

    public ResultSet getUserVTI() {
        return this.userVTI;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber));
        }
    }
}

