/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayUtil;
import com.pivotal.gemfirexd.internal.iapi.services.io.Formatable;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GenericDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Enumeration;

public final class TriggerInfo
implements Formatable {
    TriggerDescriptor[] triggerArray;
    String[] columnNames;
    int[] columnIds;

    public TriggerInfo() {
    }

    public TriggerInfo(TableDescriptor td, int[] changedCols, GenericDescriptorList triggers) {
        this.columnIds = changedCols;
        if (this.columnIds != null) {
            this.columnNames = new String[this.columnIds.length];
            for (int i = 0; i < this.columnIds.length; ++i) {
                this.columnNames[i] = td.getColumnDescriptor(this.columnIds[i]).getColumnName();
            }
        }
        SanityManager.ASSERT((triggers != null ? 1 : 0) != 0, (String)"null trigger descriptor list");
        SanityManager.ASSERT((triggers.size() > 0 ? 1 : 0) != 0, (String)"trigger descriptor list has no elements");
        Enumeration descs = triggers.elements();
        int size = triggers.size();
        this.triggerArray = new TriggerDescriptor[size];
        for (int i = 0; i < size; ++i) {
            this.triggerArray[i] = (TriggerDescriptor)descs.nextElement();
        }
    }

    boolean hasTrigger(boolean isBefore, boolean isRow) {
        if (this.triggerArray == null) {
            return false;
        }
        return this.hasTrigger((Boolean)isBefore, (Boolean)isRow);
    }

    private boolean hasTrigger(Boolean isBefore, Boolean isRow) {
        if (this.triggerArray == null) {
            return false;
        }
        for (int i = 0; i < this.triggerArray.length; ++i) {
            if (isBefore != null && this.triggerArray[i].isBeforeTrigger() != isBefore.booleanValue() || isRow != null && this.triggerArray[i].isRowTrigger() != isRow.booleanValue()) continue;
            return true;
        }
        return false;
    }

    TriggerDescriptor[] getTriggerArray() {
        return this.triggerArray;
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        ArrayUtil.writeArray(out, this.triggerArray);
        ArrayUtil.writeIntArray(out, this.columnIds);
        ArrayUtil.writeArray(out, this.columnNames);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.triggerArray = new TriggerDescriptor[ArrayUtil.readArrayLength(in)];
        ArrayUtil.readArrayItems(in, this.triggerArray);
        this.columnIds = ArrayUtil.readIntArray(in);
        int len = ArrayUtil.readArrayLength(in);
        if (len > 0) {
            this.columnNames = new String[len];
            ArrayUtil.readArrayItems(in, this.columnNames);
        }
    }

    @Override
    public int getTypeFormatId() {
        return 317;
    }

    public String toString() {
        int i;
        StringBuilder str = new StringBuilder();
        str.append("\nColumn names modified:\t\t(");
        for (i = 0; i < this.columnNames.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.columnNames[i]);
        }
        str.append(")");
        str.append("\nColumn ids modified:\t\t(");
        for (i = 0; i < this.columnIds.length; ++i) {
            if (i > 0) {
                str.append(",");
            }
            str.append(this.columnIds[i]);
        }
        str.append(")");
        str.append("\nTriggers:");
        for (i = 0; i < this.triggerArray.length; ++i) {
            str.append("\n" + this.triggerArray[i]);
        }
        return str.toString();
    }
}

