/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TargetResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import java.sql.SQLWarning;
import java.sql.Timestamp;
import java.util.ArrayList;

public final class TemporaryRowHolderResultSet
implements CursorResultSet,
NoPutResultSet,
Cloneable {
    private ExecRow[] rowArray;
    private int numRowsOut;
    private ScanController scan;
    private TransactionController tc;
    private boolean isOpen;
    private boolean finished;
    private ExecRow currentRow;
    private boolean isAppendable = false;
    private long positionIndexConglomId;
    private boolean isVirtualMemHeap;
    private boolean currRowFromMem;
    private TemporaryRowHolderImpl holder;
    ConglomerateController heapCC;
    private RowLocation baseRowLocation;
    DataValueDescriptor[] indexRow;
    ScanController indexsc;
    private boolean closeHolder;
    private boolean hasLockReference;

    TemporaryRowHolderResultSet(TransactionController tc, ExecRow[] rowArray, boolean isVirtualMemHeap, TemporaryRowHolderImpl holder) {
        this(tc, rowArray, isVirtualMemHeap, false, 0L, holder);
    }

    TemporaryRowHolderResultSet(TransactionController tc, ExecRow[] rowArray, boolean isVirtualMemHeap, boolean isAppendable, long positionIndexConglomId, TemporaryRowHolderImpl holder) {
        this.tc = tc;
        this.rowArray = rowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        this.isVirtualMemHeap = isVirtualMemHeap;
        this.isAppendable = isAppendable;
        this.positionIndexConglomId = positionIndexConglomId;
        SanityManager.ASSERT((rowArray != null ? 1 : 0) != 0, (String)"rowArray is null");
        SanityManager.ASSERT((rowArray.length > 0 ? 1 : 0) != 0, (String)"rowArray has no elements, need at least one");
        this.holder = holder;
    }

    public void reset(ExecRow[] rowArray) {
        this.rowArray = rowArray;
        this.numRowsOut = 0;
        this.isOpen = false;
        this.finished = false;
        SanityManager.ASSERT((rowArray != null ? 1 : 0) != 0, (String)"rowArray is null");
        SanityManager.ASSERT((rowArray.length > 0 ? 1 : 0) != 0, (String)"rowArray has no elements, need at least one");
    }

    public void reStartScan(long currentConglomId, long pconglomId) throws StandardException {
        if (this.isAppendable) {
            if (currentConglomId != this.holder.getTemporaryConglomId()) {
                SanityManager.ASSERT((currentConglomId == this.holder.getTemporaryConglomId() ? 1 : 0) != 0, (String)("currentConglomId(" + currentConglomId + ") == holder.getTemporaryConglomeateId (" + this.holder.getTemporaryConglomId() + ")"));
            }
            this.positionIndexConglomId = pconglomId;
            this.setupPositionBasedScan(this.numRowsOut);
        } else {
            --this.numRowsOut;
        }
    }

    static TemporaryRowHolderResultSet getNewRSOnCurrentRow(Activation activation, CursorResultSet rs) throws StandardException {
        TemporaryRowHolderImpl singleRow = new TemporaryRowHolderImpl(activation, null);
        singleRow.insert(rs.getCurrentRow());
        return (TemporaryRowHolderResultSet)singleRow.getResultSet();
    }

    @Override
    public void markAsTopResultSet() {
    }

    @Override
    public void openCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.numRowsOut = 0;
        this.isOpen = true;
        this.currentRow = null;
        if (this.isAppendable) {
            this.setupPositionBasedScan(this.numRowsOut);
            return;
        }
        if (this.scan != null) {
            this.scan.reopenScan(null, 0, null, null, 0, null);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.isAppendable) {
            return this.getNextAppendedRow();
        }
        if (this.isVirtualMemHeap && this.holder.lastArraySlot >= 0) {
            ++this.numRowsOut;
            this.currentRow = this.rowArray[this.holder.lastArraySlot];
            this.currRowFromMem = true;
            return this.currentRow;
        }
        if (this.numRowsOut++ <= this.holder.lastArraySlot) {
            this.currentRow = this.rowArray[this.numRowsOut - 1];
            return this.currentRow;
        }
        if (this.holder.getTemporaryConglomId() == 0L) {
            return null;
        }
        if (this.scan == null) {
            this.scan = this.tc.openScan(this.holder.getTemporaryConglomId(), false, 0, 7, 5, null, null, 0, null, null, 0, null);
        } else if (this.isVirtualMemHeap && this.holder.state == 1) {
            this.holder.state = 2;
            this.scan.reopenScan(null, 0, null, null, 0, null);
        }
        if (this.scan.next()) {
            this.currentRow = this.rowArray[0].getNewNullRow();
            this.scan.fetch(this.currentRow);
            this.currRowFromMem = false;
            return this.currentRow;
        }
        return null;
    }

    public void deleteCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isVirtualMemHeap, (String)"deleteCurrentRow is not implemented");
        if (this.currRowFromMem) {
            if (this.holder.lastArraySlot > 0) {
                this.rowArray[this.holder.lastArraySlot] = null;
            }
            --this.holder.lastArraySlot;
        } else {
            if (this.baseRowLocation == null) {
                this.baseRowLocation = this.scan.newRowLocationTemplate();
            }
            this.baseRowLocation = this.scan.fetchLocation(this.baseRowLocation);
            if (this.heapCC == null) {
                this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 4, 7, 5);
            }
            this.heapCC.delete(this.baseRowLocation);
        }
    }

    private void setupPositionBasedScan(long position) throws StandardException {
        if (this.holder.getTemporaryConglomId() == 0L) {
            return;
        }
        if (this.heapCC == null) {
            this.heapCC = this.tc.openConglomerate(this.holder.getTemporaryConglomId(), false, 0, 7, 5);
        }
        this.currentRow = this.rowArray[0].getNewNullRow();
        this.indexRow = new DataValueDescriptor[2];
        this.indexRow[0] = new SQLLongint(position);
        this.indexRow[1] = this.heapCC.newRowLocationTemplate();
        DataValueDescriptor[] searchRow = new DataValueDescriptor[]{new SQLLongint(position)};
        if (this.indexsc == null) {
            this.indexsc = this.tc.openScan(this.positionIndexConglomId, false, 0, 7, 5, null, searchRow, 1, null, null, -1, null);
        } else {
            this.indexsc.reopenScan(searchRow, 1, null, null, -1, null);
        }
    }

    private ExecRow getNextAppendedRow() throws StandardException {
        boolean base_row_exists;
        if (this.indexsc == null) {
            return null;
        }
        if (!this.indexsc.fetchNext(this.indexRow)) {
            return null;
        }
        RowLocation baseRowLocation = (RowLocation)this.indexRow[1];
        boolean bl = base_row_exists = (baseRowLocation = this.heapCC.fetch(baseRowLocation, this.currentRow, (FormatableBitSet)null, false)) != null;
        if (base_row_exists) {
            this.indexRow[1] = baseRowLocation;
        }
        if (!base_row_exists) {
            SanityManager.THROWASSERT((String)("base row disappeared: " + this.indexRow[1]));
        }
        ++this.numRowsOut;
        return this.currentRow;
    }

    @Override
    public int getPointOfAttachment() {
        return -1;
    }

    @Override
    public int getScanIsolationLevel() {
        return 5;
    }

    @Override
    public void setTargetResultSet(TargetResultSet trs) {
    }

    @Override
    public void setNeedsRowLocation(boolean needsRowLocation) {
    }

    @Override
    public double getEstimatedRowCount() {
        return 0.0;
    }

    @Override
    public int resultSetNumber() {
        return 0;
    }

    @Override
    public void setCurrentRow(ExecRow row) {
        this.currentRow = row;
    }

    @Override
    public void clearCurrentRow() {
        this.currentRow = null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"resultSet expected to be open");
        return this.currentRow;
    }

    @Override
    public RowLocation getRowLocation() {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"resultSet expected to be open");
        return null;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        this.isOpen = false;
        this.numRowsOut = 0;
        this.currentRow = null;
        if (this.scan != null) {
            this.scan.close();
            this.scan = null;
        }
        if (this.closeHolder) {
            this.holder.close();
        }
    }

    @Override
    public boolean returnsRows() {
        return true;
    }

    @Override
    public int modifiedRowCount() {
        return 0;
    }

    @Override
    public void open() throws StandardException {
        this.openCore();
    }

    @Override
    public ExecRow getAbsoluteRow(int row) throws StandardException {
        SanityManager.THROWASSERT((String)"getAbsoluteRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getRelativeRow(int row) throws StandardException {
        SanityManager.THROWASSERT((String)"getRelativeRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow setBeforeFirstRow() throws StandardException {
        SanityManager.THROWASSERT((String)"setBeforeFirstRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getFirstRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getFirstRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getNextRow() throws StandardException {
        return this.getNextRowCore();
    }

    @Override
    public ExecRow getPreviousRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getPreviousRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow getLastRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getLastRow() not expected to be called yet.");
        return null;
    }

    @Override
    public ExecRow setAfterLastRow() throws StandardException {
        SanityManager.THROWASSERT((String)"getLastRow() not expected to be called yet.");
        return null;
    }

    @Override
    public boolean checkRowPosition(int isType) {
        return false;
    }

    @Override
    public int getRowNumber() {
        return 0;
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        this.close(cleanupOnError);
    }

    @Override
    public boolean isClosed() {
        return !this.isOpen;
    }

    @Override
    public void finish() throws StandardException {
        this.finished = true;
        this.close(false);
    }

    @Override
    public long getExecuteTime() {
        return 0L;
    }

    @Override
    public ResultSet getAutoGeneratedKeysResultset() {
        return null;
    }

    @Override
    public Timestamp getBeginExecutionTimestamp() {
        return null;
    }

    @Override
    public Timestamp getEndExecutionTimestamp() {
        return null;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        return 0L;
    }

    @Override
    public NoPutResultSet[] getSubqueryTrackingArray(int numSubqueries) {
        return null;
    }

    @Override
    public String getCursorName() {
        return null;
    }

    @Override
    public boolean requiresRelocking() {
        SanityManager.THROWASSERT((String)("requiresRelocking() not expected to be called for " + this.getClass().getName()));
        return false;
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        return null;
    }

    @Override
    public boolean needsToClone() {
        return false;
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return null;
    }

    @Override
    public void closeRowSource() {
    }

    @Override
    public boolean needsRowLocation() {
        return false;
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public void positionScanAtRowLocation(RowLocation rl) throws StandardException {
    }

    @Override
    public boolean isForUpdate() {
        return false;
    }

    public Object clone() {
        Object clo = null;
        try {
            clo = super.clone();
        }
        catch (CloneNotSupportedException cloneNotSupportedException) {
            // empty catch block
        }
        return clo;
    }

    @Override
    public SQLWarning getWarnings() {
        return null;
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
    }

    @Override
    public void deleteRowDirectly() throws StandardException {
        throw new UnsupportedOperationException("This method should not have been invoked");
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
    }

    @Override
    public final Activation getActivation() {
        return this.holder.activation;
    }

    public void closeHolderOnClose(boolean close) {
        this.closeHolder = close;
    }

    @Override
    public final boolean canUpdateInPlace() {
        return false;
    }

    @Override
    public TXState initLocalTXState() {
        SanityManager.THROWASSERT((String)"not expected to be invoked");
        return null;
    }

    @Override
    public void upgradeReadLockToWrite(RowLocation rl, GemFireContainer container) throws StandardException {
        SanityManager.THROWASSERT((String)"not expected to be invoked");
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        SanityManager.THROWASSERT((String)"not expected to be invoked");
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (this.isAppendable) {
            if (this.indexsc != null) {
                this.indexsc.releaseCurrentRowLocationReadLock();
            }
        } else if (this.scan != null) {
            this.scan.releaseCurrentRowLocationReadLock();
        }
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return false;
    }

    @Override
    public int getScanKeyGroupID() {
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public boolean hasAutoGeneratedKeysResultSet() {
        return false;
    }

    @Override
    public void flushBatch() {
    }

    @Override
    public void closeBatch() {
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.visit(this);
    }

    @Override
    public UUID getExecutionPlanID() {
        return null;
    }

    @Override
    public void markLocallyExecuted() {
    }

    @Override
    public void resetStatistics() {
    }

    @Override
    public boolean isDistributedResultSet() {
        return false;
    }

    @Override
    public boolean addLockReference(GemFireTransaction tran) {
        tran.getLockSpace().addResultSetRef();
        this.hasLockReference = true;
        return true;
    }

    @Override
    public boolean releaseLocks(GemFireTransaction tran) {
        if (this.hasLockReference) {
            tran.releaseAllLocks(false, true);
            this.hasLockReference = false;
            return true;
        }
        return false;
    }

    @Override
    public void setGfKeysForNCJoin(ArrayList<DataValueDescriptor> keys) throws StandardException {
        throw StandardException.newException("0A000.S", " Currently this method is not implemented or overridden for class " + this.getClass().getSimpleName());
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, (GemFireTransaction)this.tc.getLanguageConnectionContext().getTransactionExecute());
    }

    @Override
    public PlanUtils.Context getNewPlanContext() {
        return new PlanUtils.Context();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        PlanUtils.xmlBeginTag(builder, context, this);
        PlanUtils.xmlTermTag(builder, context, "AUTO-GEN-KEYS");
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void releasePreviousByteSource() {
    }

    @Override
    public void setMaxSortingLimit(long limit) {
    }

    @Override
    public void checkCancellationFlag() throws StandardException {
        if (this.holder.activation != null) {
            this.holder.activation.checkCancellationFlag();
        }
    }

    @Override
    public void forceReOpenCore() throws StandardException {
    }
}

