/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.sql.compile.types.DVDSet;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregatorInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

abstract class SystemAggregator
implements ExecAggregator,
Comparable<Object> {
    protected boolean eliminatedNulls;
    protected int inputColumnPos;
    protected int resultColumnPos;
    protected boolean isDistinct;
    protected boolean isAccumulateDistinctValues;

    SystemAggregator() {
    }

    protected final void setup(AggregatorInfo aggInfo) {
        this.inputColumnPos = aggInfo.inputColumn + 1;
        this.resultColumnPos = aggInfo.outputColumn + 1;
        this.isDistinct = aggInfo.isDistinct;
    }

    @Override
    public void accumulate(ExecRow inputRow) throws StandardException {
        DataValueDescriptor addend = inputRow.getColumn(this.inputColumnPos);
        if (this.isAccumulateDistinctValues) {
            GenericAggregator.addEntryToDVDSet(addend, inputRow.getColumn(this.resultColumnPos));
        } else if (addend != null && !addend.isNull()) {
            this.basicAccumulate(addend);
        } else {
            this.eliminatedNulls = true;
        }
    }

    @Override
    public void setResult(ExecRow row, int columnPos) throws StandardException {
        row.setValue(columnPos - 1, this.getResult());
    }

    @Override
    public boolean finish(ExecRow row, boolean isByteArray) throws StandardException {
        boolean eliminatedNulls = this.eliminatedNulls;
        this.eliminatedNulls = false;
        if (this.isAccumulateDistinctValues) {
            this.clear();
            DataValueDescriptor outputColumn = row.getColumn(this.resultColumnPos);
            if (outputColumn.getClass() != DVDSet.class) {
                SanityManager.THROWASSERT((String)("aggregate Result must be of type " + DVDSet.class.getSimpleName() + ", but was " + outputColumn.getClass().getName()));
            }
            return false;
        }
        row.setValue(this.resultColumnPos - 1, this.getResult());
        this.clear();
        return eliminatedNulls;
    }

    public void clear() {
        this.eliminatedNulls = false;
    }

    @Override
    public final boolean didEliminateNulls() {
        return this.eliminatedNulls;
    }

    @Override
    public void accumulate(DataValueDescriptor addend) throws StandardException {
        if (addend == null || addend.isNull()) {
            this.eliminatedNulls = true;
            return;
        }
        this.basicAccumulate(addend);
    }

    protected abstract void basicAccumulate(DataValueDescriptor var1) throws StandardException;

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        out.writeBoolean(this.eliminatedNulls);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        this.eliminatedNulls = in.readBoolean();
    }
}

