/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.NanoTimer;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.ResultHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.message.StatementExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.procedure.coordinate.ProcedureProcessorResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.AbstractGemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDeleteResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireDistributedResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireInsertResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireRegionSizeResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GemFireUpdateResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.GfxdSubqueryResultSet;
import com.pivotal.gemfirexd.internal.engine.sql.execute.NcjPullResultSet;
import com.pivotal.gemfirexd.internal.engine.store.GemFireStore;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedConnection;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AbstractStatisticsCollector;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AnyResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.BulkTableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DMLWriteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DistinctGroupedAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GroupedAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.HashScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRowToBaseRowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.InsertResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.JoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.LastIndexKeyResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.MergeJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.MiscResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.MultiProbeTableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NestedLoopJoinResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.OnceResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ProjectRestrictResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowCountResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScalarAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SortResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UnionResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.UpdateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.WindowResultSet;
import java.sql.Timestamp;

public final class StatementStatisticsCollector
extends AbstractStatisticsCollector {
    private StatementStats stats = null;
    private GemFireStore.StoreStatistics selfStats = Misc.getMemStore().getStoreStatistics();
    private boolean isQueryNode;
    private boolean statisticsTimingOn;

    public StatementStatisticsCollector(ResultSetStatisticsVisitor nextCollector) {
        super(nextCollector);
    }

    @Override
    public ResultSetStatisticsVisitor getClone() {
        return new StatementStatisticsCollector(super.getClone());
    }

    @Override
    public <T> void process(EmbedConnection conn, StatementExecutorMessage<T> msg, EmbedStatement est, boolean isLocallyExecuted) throws StandardException {
        long beginTime = NanoTimer.getTime();
        ResultSet rs = est.getResultsToWrap();
        Activation act = rs.getActivation();
        this.init(act, est.getGPrepStmt());
        this.stats = est.getStatementStats();
        if (this.stats == null) {
            return;
        }
        if (msg.getSender() != null) {
            this.sender = msg.getSender().toString();
        }
        Timestamp beginExecTS = msg.getConstructTime();
        Timestamp endExecTS = msg.getEndProcessTime();
        if (beginExecTS != null && endExecTS != null) {
            long totalExecTime = (endExecTS.getTime() - beginExecTS.getTime()) * 1000000L;
            this.stats.incStat(13, false, totalExecTime);
        }
        this.doXPLAIN(rs, act, false, this.statisticsTimingOn, isLocallyExecuted);
        this.processDistributionMessage(msg, null);
        this.selfStats.collectStatementStatisticsStats(NanoTimer.getTime() - beginTime);
        if (this.nextCollector != null) {
            this.nextCollector.process(conn, msg, est, isLocallyExecuted);
        } else {
            rs.resetStatistics();
        }
    }

    @Override
    public <T> void process(EmbedConnection conn, StatementExecutorMessage<T> msg, ResultHolder rh, boolean isLocallyExecuted) throws StandardException {
        long beginTime = NanoTimer.getTime();
        ResultSet rs = rh.getERS().getSourceResultSet();
        Activation act = rs.getActivation();
        this.init(act, rh.getGPrepStmt());
        if (this.stats == null) {
            return;
        }
        if (msg.getSender() != null) {
            this.sender = msg.getSender().toString();
        }
        Timestamp beginExecTS = msg.getConstructTime();
        Timestamp endExecTS = msg.getEndProcessTime();
        if (beginExecTS != null && endExecTS != null) {
            long totalExecTime = (endExecTS.getTime() - beginExecTS.getTime()) * 1000000L;
            this.stats.incStat(13, false, totalExecTime);
        }
        this.doXPLAIN(rs, act, false, this.statisticsTimingOn, isLocallyExecuted);
        this.processDistributionMessage(msg, rh);
        this.selfStats.collectStatementStatisticsStats(NanoTimer.getTime() - beginTime);
        if (this.nextCollector != null) {
            this.nextCollector.process(conn, msg, rh, isLocallyExecuted);
        } else {
            rs.resetStatistics();
        }
    }

    @Override
    public void doXPLAIN(ResultSet rs, Activation activation, boolean genStatementDesc, boolean timeStatsEnabled, boolean isLocallyExecuted) throws StandardException {
        long beginTime = NanoTimer.getTime();
        if (genStatementDesc) {
            this.init(activation, activation.getPreparedStatement());
            this.statisticsTimingOn = timeStatsEnabled;
            if (this.stats == null) {
                return;
            }
            Timestamp beginExecTS = rs.getBeginExecutionTimestamp();
            Timestamp endExecTS = rs.getEndExecutionTimestamp();
            if (beginExecTS != null && endExecTS != null) {
                long totalExecTime = endExecTS.getTime() - beginExecTS.getTime();
                this.stats.incStat(13, this.isQueryNode, totalExecTime * 1000000L);
            }
        }
        rs.accept(this);
        this.selfStats.collectStatementStatisticsStats(NanoTimer.getTime() - beginTime);
        if (genStatementDesc && this.nextCollector != null) {
            this.nextCollector.doXPLAIN(rs, activation, genStatementDesc, timeStatsEnabled, isLocallyExecuted);
        }
    }

    private void init(Activation activation, PreparedStatement preparedStatement) {
        ExecPreparedStatement eps = (ExecPreparedStatement)preparedStatement;
        this.stats = eps.getStatementStats();
        this.isQueryNode = eps.getStatement().createQueryInfo();
        this.statisticsTimingOn = activation.getLanguageConnectionContext().getStatisticsTiming();
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)("StatementStatisticsCollector: Time Statistics is " + this.statisticsTimingOn));
        }
    }

    private final void record(int stmt_id, boolean incQN, long value) {
        this.stats.incStat(stmt_id, incQN, value);
    }

    @Override
    public void clear() {
    }

    @Override
    public void setNumberOfChildren(int noChildren) {
    }

    public final <T> void processDistributionMessage(StatementExecutorMessage<T> msg, ResultHolder rh) {
        if (this.statisticsTimingOn) {
            this.record(26, false, msg.getSerializeDeSerializeTime());
            this.record(27, false, msg.getProcessTime());
            if (rh != null) {
                this.record(28, false, rh.process_time);
                this.record(29, false, rh.ser_deser_time);
                this.record(30, false, rh.throttle_time);
            }
        }
    }

    public final void recordMessageProcessTime(long process_time) {
        this.record(27, false, process_time);
    }

    @Override
    public void visit(ProjectRestrictResultSet rs) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)("StatementStatisticsCollector::visit ProjectRestrictResultSet " + rs.isTopResultSet));
        }
        if (!rs.isTopResultSet) {
            return;
        }
        if (this.statisticsTimingOn) {
            this.record(12, false, rs.getTimeSpent(0, 0));
        }
        this.record(15, false, rs.rowsSeen - rs.rowsFiltered);
    }

    private void handleDMLWriteResultSetDataNode(DMLWriteResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(14, false, rs.getExecuteTime());
        }
        this.record(4, false, rs.modifiedRowCount());
    }

    @Override
    public void visit(DeleteResultSet rs, int overridable) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit DeleteResultSet ");
        }
        this.handleDMLWriteResultSetDataNode(rs);
    }

    @Override
    public void visit(InsertResultSet rs) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit InsertResultSet ");
        }
        this.handleDMLWriteResultSetDataNode(rs);
    }

    @Override
    public void visit(UpdateResultSet rs) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit UpdateResultSet ");
        }
        this.handleDMLWriteResultSetDataNode(rs);
    }

    private void handleDMLWriteResultSetQueryNode(AbstractGemFireResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(14, true, rs.getTimeSpent(0, 0));
        }
        this.record(4, true, rs.modifiedRowCount());
    }

    @Override
    public void visit(GemFireUpdateResultSet rs, int overridable) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit GemFireUpdateResultSet ");
        }
        this.handleDMLWriteResultSetQueryNode(rs);
    }

    @Override
    public void visit(GemFireDeleteResultSet rs) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit GemFireDeleteResultSet ");
        }
        this.handleDMLWriteResultSetQueryNode(rs);
    }

    @Override
    public void visit(GemFireInsertResultSet rs) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit GemFireInsertResultSet ");
        }
        this.handleDMLWriteResultSetQueryNode(rs);
    }

    @Override
    public void visit(GroupedAggregateResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(37, false, rs.getTimeSpent(0, 0));
        }
        this.record(23, false, rs.rowsSeen);
    }

    @Override
    public void visit(DistinctGroupedAggregateResultSet rs) {
        this.visit((GroupedAggregateResultSet)rs);
    }

    @Override
    public void visit(HashScanResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(34, false, rs.getTimeSpent(0, 0));
        }
        this.record(19, false, rs.rowsSeen);
    }

    @Override
    public void visit(MergeJoinResultSet rs) {
    }

    @Override
    public void visit(NestedLoopJoinResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(31, false, rs.getTimeSpent(0, 0));
        }
        this.record(16, false, rs.rowsReturned);
    }

    @Override
    public void visit(HashJoinResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(32, false, rs.getTimeSpent(0, 0));
        }
        this.record(17, false, rs.rowsReturned);
    }

    @Override
    public void visit(ScalarAggregateResultSet rs, int overridable) {
    }

    @Override
    public void visit(BulkTableScanResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(33, false, rs.getTimeSpent(0, 0));
        }
        this.record(18, false, rs.rowsSeen - rs.rowsFiltered);
    }

    @Override
    public void visit(IndexRowToBaseRowResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(35, false, rs.getTimeSpent(0, 0));
        }
        this.record(20, false, rs.rowsSeen - rs.rowsFiltered);
    }

    @Override
    public void visit(MultiProbeTableScanResultSet rs) {
    }

    @Override
    public void visit(AnyResultSet anyResultSet) {
    }

    @Override
    public void visit(GemFireDistributedResultSet rs) {
    }

    @Override
    public void visit(SortResultSet rs) {
        if (this.statisticsTimingOn) {
            this.record(36, false, rs.getTimeSpent(0, 0));
        }
        this.record(21, false, rs.rowsSeen - rs.rowsFiltered);
    }

    @Override
    public void visit(LastIndexKeyResultSet lastIndexKeyResultSet) {
    }

    @Override
    public void visit(MiscResultSet miscResultSet) {
    }

    @Override
    public void visit(OnceResultSet onceResultSet) {
    }

    @Override
    public void visit(ProcedureProcessorResultSet procedureProcessorResultSet) {
    }

    @Override
    public void visit(GfxdSubqueryResultSet gfxdSubqueryResultset) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit GfxdSubqueryResultSet ");
        }
        if (this.statisticsTimingOn) {
            this.record(38, false, gfxdSubqueryResultset.getTimeSpent(0, 0));
        }
        this.record(25, false, gfxdSubqueryResultset.rowsSeen - gfxdSubqueryResultset.rowsFiltered);
    }

    @Override
    public void visit(NcjPullResultSet ncjPullResultSet) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit NcjPullResultSet ");
        }
        if (this.statisticsTimingOn) {
            this.record(38, false, ncjPullResultSet.getTimeSpent(0, 0));
        }
        this.record(25, false, ncjPullResultSet.rowsSeen - ncjPullResultSet.rowsFiltered);
    }

    @Override
    public void visit(TemporaryRowHolderResultSet temporaryRowHolderResultSet) {
    }

    @Override
    public void visit(WindowResultSet windowResultSet) {
    }

    @Override
    public void visit(TableScanResultSet rs, int overridable) {
    }

    @Override
    public void visit(JoinResultSet rs, int overridable) {
    }

    @Override
    public void visit(HashScanResultSet rs, int overridable) {
    }

    @Override
    public void visit(GemFireRegionSizeResultSet regionSizeResultSet) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit GemFireRegionSizeResultSet ");
        }
        if (this.statisticsTimingOn) {
            this.record(11, true, regionSizeResultSet.getTimeSpent(0, 0));
        }
    }

    @Override
    public void visit(RowCountResultSet rs) {
    }

    @Override
    public void visit(RowResultSet rs) {
    }

    @Override
    public void visit(UnionResultSet rs) {
    }

    @Override
    public void visit(GemFireResultSet rs) {
        if (GemFireXDUtils.TraceStatsGeneration) {
            SanityManager.DEBUG_PRINT((String)"TraceStatsGeneration", (String)"StatementStatisticsCollector::visit GemFireResultSet ");
        }
        if (this.statisticsTimingOn) {
            this.record(11, true, rs.getTimeSpent(0, 0));
        }
        this.record(15, true, rs.modifiedRowCount());
    }
}

