/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ParameterValueSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;

class SetSchemaConstantAction
implements ConstantAction {
    private final String schemaName;
    private final int type;

    SetSchemaConstantAction(String schemaName, int type) {
        this.schemaName = schemaName;
        this.type = type;
    }

    public String toString() {
        return "SET SCHEMA " + (this.type == 1 ? "USER" : (this.type == 2 && this.schemaName == null ? "?" : this.schemaName));
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        String thisSchemaName = this.schemaName;
        if (this.type == 2) {
            ParameterValueSet pvs = activation.getParameterValueSet();
            DataValueDescriptor dvs = pvs.getParameter(0);
            thisSchemaName = dvs.getString();
            if (thisSchemaName == null || thisSchemaName.length() > 128) {
                throw StandardException.newException("42815.S.713", "CURRENT SCHEMA");
            }
        } else if (this.type == 1) {
            thisSchemaName = lcc.getAuthorizationId();
        }
        SchemaDescriptor sd = dd.getSchemaDescriptor(thisSchemaName, lcc.getTransactionExecute(), true);
        lcc.setDefaultSchema(sd);
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

