/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLSingleTableConstantAction;

class RenameConstantAction
extends DDLSingleTableConstantAction {
    private String fullTableName;
    private String tableName;
    private String newTableName;
    private String oldObjectName;
    private String newObjectName;
    private UUID schemaId;
    private SchemaDescriptor sd;
    private boolean usedAlterTable;
    private int renamingWhat;

    public RenameConstantAction(String fullTableName, String tableName, String oldObjectName, String newObjectName, SchemaDescriptor sd, UUID tableId, boolean usedAlterTable, int renamingWhat) {
        super(tableId);
        this.fullTableName = fullTableName;
        this.tableName = tableName;
        this.sd = sd;
        this.usedAlterTable = usedAlterTable;
        this.renamingWhat = renamingWhat;
        switch (this.renamingWhat) {
            case 1: {
                this.newTableName = newObjectName;
                this.oldObjectName = null;
                this.newObjectName = newObjectName;
                break;
            }
            case 2: 
            case 3: {
                this.oldObjectName = oldObjectName;
                this.newObjectName = newObjectName;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)"Unexpected rename action in RenameConstantAction");
            }
        }
        SanityManager.ASSERT((sd != null ? 1 : 0) != 0, (String)"SchemaDescriptor is null");
    }

    public String toString() {
        String renameString = this.usedAlterTable ? "ALTER TABLE " : "RENAME ";
        switch (this.renamingWhat) {
            case 1: {
                if (this.usedAlterTable) {
                    renameString = renameString + this.fullTableName + " RENAME TO " + this.newTableName;
                    break;
                }
                renameString = renameString + " TABLE " + this.fullTableName + " TO " + this.newTableName;
                break;
            }
            case 2: {
                if (this.usedAlterTable) {
                    renameString = renameString + this.fullTableName + " RENAME " + this.oldObjectName + " TO " + this.newObjectName;
                    break;
                }
                renameString = renameString + " COLUMN " + this.fullTableName + "." + this.oldObjectName + " TO " + this.newObjectName;
                break;
            }
            case 3: {
                renameString = renameString + " INDEX " + this.oldObjectName + " TO " + this.newObjectName;
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)"Unexpected rename action in RenameConstantAction");
            }
        }
        return renameString;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        throw StandardException.newException("0A000.S", "RENAME statement not yet implemented");
    }

    private void execGutsRenameTable(TableDescriptor td, Activation activation) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(td, 34, lcc);
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(td);
        for (int index = 0; index < constraintDescriptorList.size(); ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            if (!(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor)) continue;
            dm.invalidateFor(constraintDescriptor, 34, lcc);
        }
        dd.dropTableDescriptor(td, this.sd, tc);
        td.setTableName(this.newTableName);
        dd.addDescriptor(td, this.sd, 1, false, tc);
    }

    private void execGutsRenameColumn(TableDescriptor td, Activation activation) throws StandardException {
        ColumnDescriptor columnDescriptor = null;
        int columnPosition = 0;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        columnDescriptor = td.getColumnDescriptor(this.oldObjectName);
        columnPosition = columnDescriptor.getPosition();
        FormatableBitSet toRename = new FormatableBitSet(td.getColumnDescriptorList().size() + 1);
        toRename.set(columnPosition);
        td.setReferencedColumnMap(toRename);
        dm.invalidateFor(td, 34, lcc);
        ConstraintDescriptorList constraintDescriptorList = dd.getConstraintDescriptors(td);
        for (int index = 0; index < constraintDescriptorList.size(); ++index) {
            ConstraintDescriptor constraintDescriptor = constraintDescriptorList.elementAt(index);
            int[] referencedColumns = constraintDescriptor.getReferencedColumns();
            int numRefCols = referencedColumns.length;
            for (int j = 0; j < numRefCols; ++j) {
                if (referencedColumns[j] != columnPosition || !(constraintDescriptor instanceof ReferencedKeyConstraintDescriptor)) continue;
                dm.invalidateFor(constraintDescriptor, 34, lcc);
            }
        }
        dd.dropColumnDescriptor(td.getUUID(), this.oldObjectName, tc);
        columnDescriptor.setColumnName(this.newObjectName);
        dd.addDescriptor(columnDescriptor, td, 2, false, tc);
        td = dd.getTableDescriptor(td.getObjectID());
    }

    private void execGutsRenameIndex(TableDescriptor td, Activation activation) throws StandardException {
        this.updateIndex(this.sd, td, activation, this.oldObjectName, this.newObjectName, -1L);
    }

    @Override
    public String getTableName() {
        return this.tableName;
    }

    @Override
    public String getSchemaName() {
        return this.sd.getSchemaName();
    }

    @Override
    public boolean isCancellable() {
        return true;
    }
}

