/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.jdbc.EmbedStatement;
import com.pivotal.gemfirexd.internal.impl.sql.execute.NoPutResultSetImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class NormalizeResultSet
extends NoPutResultSetImpl
implements CursorResultSet {
    public NoPutResultSet source;
    private ExecRow normalizedRow;
    private int numCols;
    private int startCol;
    private ResultDescription resultDescription;
    private DataTypeDescriptor[] desiredTypes;

    public NormalizeResultSet(NoPutResultSet source, Activation activation, int resultSetNumber, int erdNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost, boolean forUpdate) throws StandardException {
        super(activation, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.source = source;
        if (!(activation.getSavedObject(erdNumber) instanceof ResultDescription)) {
            SanityManager.THROWASSERT((String)"activation.getPreparedStatement().getSavedObject(erdNumber) expected to be instanceof ResultDescription");
        }
        SanityManager.ASSERT((source != null ? 1 : 0) != 0, (String)"NRS(), source expected to be non-null");
        this.resultDescription = (ResultDescription)activation.getSavedObject(erdNumber);
        this.numCols = this.resultDescription.getColumnCount();
        this.startCol = forUpdate ? (this.numCols - 1) / 2 + 1 : 1;
        this.normalizedRow = activation.getExecutionFactory().getValueRow(this.numCols);
        this.initLocalTXState();
        this.recordConstructorTime();
        this.printResultSetHierarchy();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"NormalizeResultSet already open");
        SanityManager.ASSERT((this.source != null ? 1 : 0) != 0, (String)"NRS().openCore(), source expected to be non-null");
        this.isOpen = true;
        this.source.openCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"NormalizeResultSet already open");
        this.source.reopenCore();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecRow sourceRow = null;
        ExecRow result = null;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen) {
            throw StandardException.newException("XCL16.S.0", "next");
        }
        sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            result = this.normalizeRow(sourceRow);
            ++this.rowsSeen;
        }
        this.setCurrentRow(result);
        if (this.localTXState != null && this.isTopResultSet && result != null && this.isForUpdate()) {
            this.updateRowLocationPostRead();
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return result;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.currentRow = null;
            this.source.close(cleanupOnError);
            this.normalizedRow.resetRowArray();
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of NormalizeResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        SanityManager.ASSERT((boolean)(this.source instanceof CursorResultSet), (String)"source is not a cursorresultset");
        return ((CursorResultSet)((Object)this.source)).getRowLocation();
    }

    @Override
    public ExecRow getCurrentRow() {
        return this.currentRow;
    }

    private ExecRow normalizeRow(ExecRow sourceRow) throws StandardException {
        int whichCol;
        if (this.desiredTypes == null) {
            this.desiredTypes = new DataTypeDescriptor[this.numCols];
            for (whichCol = 1; whichCol <= this.numCols; ++whichCol) {
                DataTypeDescriptor dtd;
                this.desiredTypes[whichCol - 1] = dtd = this.resultDescription.getColumnDescriptor(whichCol).getType();
            }
        }
        for (whichCol = 1; whichCol <= this.numCols; ++whichCol) {
            DataValueDescriptor normalizedCol;
            DataValueDescriptor sourceCol = sourceRow.getColumn(whichCol);
            if (sourceCol == null) continue;
            if (whichCol < this.startCol) {
                normalizedCol = sourceCol;
            } else {
                try {
                    normalizedCol = this.desiredTypes[whichCol - 1].normalize(sourceCol, this.normalizedRow.getColumn(whichCol));
                }
                catch (StandardException se) {
                    if (se.getMessageId().startsWith("23502")) {
                        ResultColumnDescriptor columnDescriptor = this.resultDescription.getColumnDescriptor(whichCol);
                        throw StandardException.newException("23502", columnDescriptor.getName());
                    }
                    EmbedStatement.fillInColumnName(se, this.resultDescription.getColumnDescriptor(whichCol).getName(), this.getActivation());
                    throw se;
                }
            }
            this.normalizedRow.setColumn(whichCol, normalizedCol);
        }
        return this.normalizedRow;
    }

    @Override
    public void updateRow(ExecRow row) throws StandardException {
        this.source.updateRow(row);
    }

    @Override
    public void markRowAsDeleted() throws StandardException {
        this.source.markRowAsDeleted();
    }

    @Override
    public boolean isForUpdate() {
        return this.source.isForUpdate();
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.source.updateRowLocationPostRead();
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        this.source.filteredRowLocationPostRead(localTXState);
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.source.supportsMoveToNextKey();
    }

    @Override
    public int getScanKeyGroupID() {
        return this.source.getScanKeyGroupID();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        if (this.source != null) {
            visitor.setNumberOfChildren(1);
        } else {
            visitor.setNumberOfChildren(0);
        }
        visitor.visit(this);
        if (this.source != null) {
            this.source.accept(visitor);
        }
    }

    @Override
    public void releasePreviousByteSource() {
        this.source.releasePreviousByteSource();
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "TABLESCAN");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public void printResultSetHierarchy() {
        if (GemFireXDUtils.TraceNCJ) {
            SanityManager.DEBUG_PRINT((String)"TraceNCJ", (String)("ResultSet Created: " + this.getClass().getSimpleName() + " with resultSetNumber=" + this.resultSetNumber + " with source = " + (this.source != null ? this.source.getClass().getSimpleName() : null) + " and source ResultSetNumber = " + (this.source != null && this.source instanceof NoPutResultSetImpl ? ((NoPutResultSetImpl)this.source).resultSetNumber() : -1)));
        }
    }
}

