/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.iapi.services.io.ArrayUtil;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.WriteCursorConstantAction;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import java.util.Properties;

public class InsertConstantAction
extends WriteCursorConstantAction {
    boolean[] indexedCols;
    private String schemaName;
    private String tableName;
    private String[] columnNames;
    protected RowLocation[] autoincRowLocation;
    private long[] autoincIncrement;

    public InsertConstantAction() {
    }

    public InsertConstantAction(TableDescriptor tableDescriptor, long conglomId, StaticCompiledOpenConglomInfo heapSCOCI, IndexRowGenerator[] irgs, long[] indexCIDS, StaticCompiledOpenConglomInfo[] indexSCOCIs, String[] indexNames, boolean deferred, Properties targetProperties, UUID targetUUID, int lockMode, FKInfo[] fkInfo, TriggerInfo triggerInfo, int[] streamStorableHeapColIds, boolean[] indexedCols, boolean singleRowSource, RowLocation[] autoincRowLocation) {
        super(conglomId, heapSCOCI, irgs, indexCIDS, indexSCOCIs, indexNames, deferred, targetProperties, targetUUID, lockMode, fkInfo, triggerInfo, null, null, null, streamStorableHeapColIds, singleRowSource);
        this.indexedCols = indexedCols;
        this.autoincRowLocation = autoincRowLocation;
        this.schemaName = tableDescriptor.getSchemaName();
        this.tableName = tableDescriptor.getName();
        this.columnNames = tableDescriptor.getColumnNamesArray();
        this.autoincIncrement = tableDescriptor.getAutoincIncrementArray();
        this.indexNames = indexNames;
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        int i;
        Object[] objectArray = null;
        super.readExternal(in);
        this.indexedCols = ArrayUtil.readBooleanArray(in);
        objectArray = ArrayUtil.readObjectArray(in);
        if (objectArray != null) {
            this.autoincRowLocation = new RowLocation[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                this.autoincRowLocation[i] = (RowLocation)objectArray[i];
            }
        }
        this.schemaName = (String)in.readObject();
        this.tableName = (String)in.readObject();
        objectArray = ArrayUtil.readObjectArray(in);
        if (objectArray != null) {
            this.columnNames = new String[objectArray.length];
            for (i = 0; i < objectArray.length; ++i) {
                this.columnNames[i] = (String)objectArray[i];
            }
        }
        this.autoincIncrement = ArrayUtil.readLongArray(in);
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        ArrayUtil.writeBooleanArray(out, this.indexedCols);
        ArrayUtil.writeArray(out, this.autoincRowLocation);
        out.writeObject(this.schemaName);
        out.writeObject(this.tableName);
        ArrayUtil.writeArray(out, this.columnNames);
        ArrayUtil.writeLongArray(out, this.autoincIncrement);
    }

    public String getSchemaName() {
        return this.schemaName;
    }

    public String getTableName() {
        return this.tableName;
    }

    public String getColumnName(int i) {
        return this.columnNames[i];
    }

    public long getAutoincIncrement(int i) {
        return this.autoincIncrement[i];
    }

    public boolean hasAutoincrement() {
        return this.autoincRowLocation != null;
    }

    public RowLocation[] getAutoincRowLocation() {
        return this.autoincRowLocation;
    }

    @Override
    public int getTypeFormatId() {
        return 38;
    }
}

