/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.RegionAndKey;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.AbstractCompactExecRow;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregateSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SystemAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Properties;
import java.util.TreeSet;

public class GroupedAggregateResultSet
extends GenericAggregateResultSet
implements CursorResultSet {
    public int rowsInput;
    public int rowsReturned;
    private ColumnOrdering[] order;
    private ExecRow sortTemplateRow;
    public boolean hasDistinctAggregate;
    public boolean isInSortedOrder;
    private int maxRowSize;
    private ScanController scanController;
    private ExecRow sortResultRow;
    private ExecRow currSortedRow;
    private ExecAggregator[] aggregators;
    private boolean supportsMoveToNextKey;
    private boolean byteArrayStore;
    private int currentGroupID;
    private long maxSortLimit;
    private long distinctAggSortId;
    private boolean dropDistinctAggSort;
    private long genericSortId;
    private boolean dropGenericSort;
    private TransactionController tc;
    public Properties sortProperties = new Properties();

    GroupedAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, int orderingItem, Activation a, GeneratedMethod ra, int maxRowSize, int resultSetNumber, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, aggregateItem, a, ra, resultSetNumber, optimizerEstimatedRowCount, optimizerEstimatedCost, false);
        this.isInSortedOrder = isInSortedOrder;
        this.sortTemplateRow = (ExecRow)this.rowAllocator.invoke(this.activation);
        this.order = (ColumnOrdering[])((FormatableArrayHolder)a.getSavedObject(orderingItem)).getArray(ColumnOrdering.class);
        this.aggregators = this.getExecAggregators(this.aggInfoList, false, this.lcc);
        SanityManager.DEBUG((String)"AggregateTrace", (String)("execution time: " + a.getSavedObject(aggregateItem)));
        this.recordConstructorTime();
    }

    public void basicOpenCore(boolean isReopen) throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"GroupedAggregateResultSet already open");
        this.isOpen = true;
        this.sortResultRow = this.isInSortedOrder ? this.sortTemplateRow : this.sortTemplateRow.getClone();
        if (this.aggregators != null) {
            for (ExecAggregator aggregator : this.aggregators) {
                SystemAggregator sa = (SystemAggregator)aggregator;
                if (sa == null) continue;
                sa.clear();
            }
        }
        if (isReopen) {
            this.source.reopenCore();
        } else {
            this.source.openCore();
        }
        if (this.isInSortedOrder) {
            this.supportsMoveToNextKey = this.source.supportsMoveToNextKey();
            this.currSortedRow = this.getRowFromResultSet();
            if (this.supportsMoveToNextKey) {
                this.currentGroupID = this.source.getScanKeyGroupID();
            } else {
                this.byteArrayStore = this.currSortedRow instanceof AbstractCompactExecRow;
            }
            if (this.currSortedRow != null) {
                this.accumulate(this.currSortedRow);
            }
        } else {
            this.scanController = this.loadSorter();
        }
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final void setMaxSortingLimit(long limit) {
        this.maxSortLimit = limit;
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow inputRow;
        SortController sorter;
        long sortId;
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        boolean inOrder = this.isInSortedOrder;
        this.tc = this.getTransactionController();
        ColumnOrdering[] currentOrdering = this.order;
        if (this.aggregates == null) {
            this.aggregates = this.getSortAggregators(this.aggInfoList, false, this.lcc, this.source);
            int numAggregates = this.aggregates.length;
            for (int index = 0; index < numAggregates; ++index) {
                this.aggregates[index].cachedAggregator = this.aggregators[index];
            }
        }
        if (this.aggInfoList.hasDistinct()) {
            ExecRow sourceRow;
            this.hasDistinctAggregate = true;
            GenericAggregator[] aggsNoDistinct = this.getSortAggregators(this.aggInfoList, true, this.activation.getLanguageConnectionContext(), this.source);
            AggregateSortObserver sortObserver = new AggregateSortObserver(true, aggsNoDistinct, this.aggregates, this.sortTemplateRow);
            sortId = this.tc.createSort(null, this.sortTemplateRow, this.order, sortObserver, false, inputRowCountEstimate, this.maxRowSize, 0L);
            sorter = this.tc.openSort(sortId);
            this.distinctAggSortId = sortId;
            this.dropDistinctAggSort = true;
            boolean isOffHeapEnabled = GemFireXDUtils.isOffHeapEnabled();
            while ((sourceRow = this.source.getNextRowCore()) != null) {
                boolean rowInserted = false;
                rowInserted = sorter.insert(sourceRow);
                ++this.rowsInput;
                if (!isOffHeapEnabled) continue;
                this.source.releasePreviousByteSource();
            }
            this.sortProperties = sorter.getSortInfo().getAllSortInfo(this.sortProperties);
            sorter.completedInserts();
            this.scanController = this.tc.openSortScan(sortId, this.activation.getResultSetHoldability());
            inOrder = true;
            inputRowCountEstimate = this.rowsInput;
            if (this.order.length == 1) {
                return this.scanController;
            }
            ColumnOrdering[] newOrder = new ColumnOrdering[this.order.length - 1];
            System.arraycopy(this.order, 0, newOrder, 0, this.order.length - 1);
            currentOrdering = newOrder;
        }
        AggregateSortObserver sortObserver = new AggregateSortObserver(true, this.aggregates, this.aggregates, this.sortTemplateRow);
        sortId = this.tc.createSort(null, this.sortTemplateRow, currentOrdering, sortObserver, inOrder, inputRowCountEstimate, this.maxRowSize, this.maxSortLimit);
        sorter = this.tc.openSort(sortId);
        this.genericSortId = sortId;
        this.dropGenericSort = true;
        while ((inputRow = this.getNextRowFromRS()) != null) {
            sorter.insert(inputRow);
        }
        this.sortProperties = sorter.getSortInfo().getAllSortInfo(this.sortProperties);
        sorter.completedInserts();
        return this.tc.openSortScan(sortId, this.activation.getResultSetHoldability());
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isInSortedOrder) {
            if (this.currSortedRow == null) {
                if (this.statisticsTimingOn) {
                    this.nextTime += this.getElapsedNanos(this.beginTime);
                }
                return null;
            }
            this.copyOrderingColumns(this.sortResultRow, this.currSortedRow);
            TreeSet<RegionAndKey> raks = this.currSortedRow.getAllRegionAndKeyInfo();
            if (raks != null && raks.size() > 0) {
                this.sortResultRow.addAllKeys(raks);
            }
            this.source.releasePreviousByteSource();
            ExecRow nextRow = this.getRowFromResultSet();
            while (nextRow != null) {
                if (!this.sameGroupingValues(nextRow)) {
                    ExecRow result = this.sortResultRow;
                    this.finishOutput(result);
                    this.accumulate(nextRow);
                    this.currSortedRow = nextRow;
                    if (this.statisticsTimingOn) {
                        this.nextTime += this.getElapsedNanos(this.beginTime);
                    }
                    ++this.rowsReturned;
                    return result;
                }
                this.accumulate(nextRow);
                this.source.releasePreviousByteSource();
                nextRow = this.getRowFromResultSet();
            }
            ExecRow result = this.sortResultRow;
            this.sortResultRow = null;
            this.currSortedRow = null;
            this.finishOutput(result);
            if (this.statisticsTimingOn) {
                this.nextTime += this.getElapsedNanos(this.beginTime);
            }
            ++this.rowsReturned;
            return result;
        }
        ExecRow sortResult = null;
        sortResult = this.getNextRowFromRS();
        if (sortResult != null) {
            this.setCurrentRow(sortResult);
        }
        if (sortResult != null) {
            this.currentRow = sortResult = this.finishAggregation(sortResult);
        }
        if (sortResult != null) {
            ++this.rowsReturned;
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return sortResult;
    }

    private boolean sameGroupingValues(ExecRow newRow) throws StandardException {
        if (this.supportsMoveToNextKey) {
            int groupID = this.source.getScanKeyGroupID();
            if (this.currentGroupID == groupID) {
                return true;
            }
            this.currentGroupID = groupID;
            return false;
        }
        for (ColumnOrdering colOrder : this.order) {
            if (this.sortResultRow.compare(newRow, colOrder.getColumnId() + 1, true) == 0) continue;
            return false;
        }
        return true;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.close(false, false);
        this.basicOpenCore(true);
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        this.close(true, cleanupOnError);
    }

    @Override
    public void openCore() throws StandardException {
        GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();
        if (observer != null) {
            observer.onGroupedAggregateResultSetOpen(this);
        }
        this.basicOpenCore(false);
    }

    public void close(boolean closeSourceResultSet, boolean cleanupOnError) throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            this.clearCurrentRow();
            this.sortResultRow = null;
            this.closeSource(closeSourceResultSet, cleanupOnError);
            if (this.dropDistinctAggSort) {
                this.tc.dropSort(this.distinctAggSortId);
                this.dropDistinctAggSort = false;
            }
            if (this.dropGenericSort) {
                this.tc.dropSort(this.genericSortId);
                this.dropGenericSort = false;
            }
            super.close(cleanupOnError);
        } else {
            SanityManager.DEBUG((String)"CloseRepeatInfo", (String)"Close of SortResultSet repeated");
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
        this.isOpen = false;
    }

    @Override
    public final long getTimeSpent(int type, int timeType) {
        long time = PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
        if (type == 0) {
            return time - this.source.getTimeSpent(1, timeType);
        }
        return timeType == 0 ? time - this.constructorTime : time;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (!this.isOpen) {
            return null;
        }
        if (this.scanController == null) {
            if (this.source instanceof CursorResultSet) {
                return ((CursorResultSet)((Object)this.source)).getRowLocation();
            }
            return null;
        }
        return null;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        SanityManager.ASSERT((boolean)this.isOpen, (String)"SortResultSet expected to be open");
        return this.currentRow;
    }

    private ExecRow getNextRowFromRS() throws StandardException {
        return this.scanController == null ? this.getRowFromResultSet() : this.getRowFromSorter();
    }

    private ExecRow getRowFromResultSet() throws StandardException {
        this.source.releasePreviousByteSource();
        ExecRow sourceRow = this.source.getNextRowCore();
        if (sourceRow != null) {
            ++this.rowsInput;
        }
        return sourceRow;
    }

    private ExecRow getRowFromSorter() throws StandardException {
        if (this.scanController.next()) {
            this.currentRow = this.sortResultRow = this.scanController.fetchRow(this.sortResultRow);
            return this.currentRow;
        }
        this.currentRow = null;
        return null;
    }

    public void closeSource(boolean closeSourceResultSet, boolean cleanupOnError) throws StandardException {
        if (this.scanController == null) {
            if (closeSourceResultSet) {
                this.source.close(cleanupOnError);
            }
        } else {
            this.scanController.close();
            this.scanController = null;
            if (closeSourceResultSet) {
                this.source.close(cleanupOnError);
            }
        }
    }

    protected final void accumulate(ExecRow inputRow) throws StandardException {
        for (ExecAggregator agg : this.aggregators) {
            agg.accumulate(inputRow);
        }
    }

    protected final void finishOutput(ExecRow outputRow) throws StandardException {
        this.setCurrentRow(outputRow);
        boolean eliminatedNulls = false;
        for (ExecAggregator agg : this.aggregators) {
            if (!agg.finish(outputRow, this.byteArrayStore)) continue;
            eliminatedNulls = true;
        }
        if (eliminatedNulls) {
            this.activation.addNullEliminatedWarning();
        }
    }

    private void copyOrderingColumns(ExecRow resultRow, ExecRow currRow) throws StandardException {
        for (ColumnOrdering colOrder : this.order) {
            int colIndex = colOrder.getColumnId();
            resultRow.setValue(colIndex, currRow.getColumn(colIndex + 1));
        }
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        if (this.scanController == null) {
            this.source.updateRowLocationPostRead();
        }
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
    }

    @Override
    public boolean supportsMoveToNextKey() {
        return this.supportsMoveToNextKey;
    }

    @Override
    public int getScanKeyGroupID() {
        if (this.scanController == null) {
            return this.source.getScanKeyGroupID();
        }
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }

    @Override
    public void resetStatistics() {
        this.rowsInput = 0;
        this.rowsReturned = 0;
        super.resetStatistics();
    }

    public final long estimateMemoryUsage() throws StandardException {
        ExecRow templateRow = this.sortTemplateRow;
        if (templateRow != null) {
            long sz = templateRow.estimateRowSize();
            ExecRow resultRow = this.sortResultRow;
            if (resultRow != templateRow && resultRow != null) {
                sz += resultRow.estimateRowSize();
            }
            return sz;
        }
        return 1L;
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "GROUPBY");
        if (this.source != null) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }
}

