/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.Region;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.management.GfxdManagementService;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DefaultDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GenericDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TriggerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLSingleTableConstantAction;
import java.util.Enumeration;

public final class DropTableConstantAction
extends DDLSingleTableConstantAction {
    private final long conglomerateNumber;
    private final String fullTableName;
    private final String tableName;
    private final SchemaDescriptor sd;
    private final boolean onlyIfExists;
    private final boolean cascade;

    DropTableConstantAction(String fullTableName, String tableName, SchemaDescriptor sd, long conglomerateNumber, UUID tableId, boolean onlyIfExists, int behavior) {
        super(tableId);
        this.fullTableName = fullTableName;
        this.tableName = tableName;
        this.sd = sd;
        this.conglomerateNumber = conglomerateNumber;
        this.onlyIfExists = onlyIfExists;
        this.cascade = behavior == 0;
        SanityManager.ASSERT((onlyIfExists || sd != null ? 1 : 0) != 0, (String)"SchemaDescriptor is null");
    }

    public String toString() {
        return "DROP TABLE " + this.fullTableName;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        TableDescriptor td;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        if (this.onlyIfExists) {
            if (this.sd == null) {
                return;
            }
            if (this.tableId == null) {
                if (dd.getTableDescriptor(this.tableName, this.sd, tc) != null) {
                    ExecPreparedStatement pstmt = activation.getPreparedStatement();
                    if (pstmt != null) {
                        pstmt.makeInvalid(23, lcc);
                    }
                    throw StandardException.newException("XCL32.S");
                }
                return;
            }
        }
        if (this.sd != null && this.sd.getSchemaName().equals("SESSION")) {
            td = lcc.getTableDescriptorForDeclaredGlobalTempTable(this.tableName);
            if (td == null) {
                td = dd.getTableDescriptor(this.tableName, this.sd, tc);
            }
            if (td == null) {
                if (this.onlyIfExists) {
                    return;
                }
                throw StandardException.newException("X0X05.S", this.fullTableName);
            }
            if (td.getTableType() == 3) {
                dm.invalidateFor(td, 1, lcc);
                tc.dropConglomerate(td.getHeapConglomerateId());
                lcc.dropDeclaredGlobalTempTable(this.tableName);
                return;
            }
        }
        td = dd.getTableDescriptor(this.tableId);
        lcc.verifyNoOpenResultSets(null, td, 1);
        dd.startWriting(lcc);
        td = dd.getTableDescriptor(this.tableId);
        if (td == null) {
            if (this.onlyIfExists) {
                return;
            }
            throw StandardException.newException("X0X05.S", this.fullTableName);
        }
        long heapId = td.getHeapConglomerateId();
        this.lockTableForDDL(tc, heapId, true);
        td = dd.getTableDescriptor(this.tableId);
        Region region = Misc.getRegionByPath(Misc.getRegionPath(td, lcc), false);
        if (region != null && region instanceof PartitionedRegion) {
            try {
                ((PartitionedRegion)region).checkForColocatedChildren(true);
            }
            catch (IllegalStateException ex) {
                throw StandardException.newException("X0Y98.S", ex, (Object)td.getQualifiedName(), (Object)ex.getMessage());
            }
        }
        GenericDescriptorList tdl = dd.getTriggerDescriptors(td);
        Enumeration descs = tdl.elements();
        while (descs.hasMoreElements()) {
            TriggerDescriptor trd = (TriggerDescriptor)descs.nextElement();
            trd.drop(lcc);
        }
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int cdlSize = cdl.size();
        for (int index = 0; index < cdlSize; ++index) {
            ColumnDescriptor cd = cdl.elementAt(index);
            if (cd.getDefaultInfo() == null) continue;
            DefaultDescriptor defaultDesc = cd.getDefaultDescriptor(dd);
            dm.clearDependencies(lcc, defaultDesc);
        }
        dd.dropAllColumnDescriptors(this.tableId, tc);
        dd.dropAllTableAndColPermDescriptors(this.tableId, tc);
        this.dropAllConstraintDescriptors(td, activation);
        ConglomerateDescriptor[] cds = td.getConglomerateDescriptors();
        long[] dropped = new long[cds.length - 1];
        int numDropped = 0;
        for (int index = 0; index < cds.length; ++index) {
            int i;
            ConglomerateDescriptor cd = cds[index];
            if (cd.getConglomerateNumber() == heapId) continue;
            long thisConglom = cd.getConglomerateNumber();
            for (i = 0; i < numDropped && dropped[i] != thisConglom; ++i) {
            }
            if (i != numDropped) continue;
            dropped[numDropped++] = thisConglom;
            tc.dropConglomerate(thisConglom);
            dd.dropStatisticsDescriptors(td.getUUID(), cd.getUUID(), tc);
        }
        dm.invalidateFor(td, 1, lcc);
        this.adjustUDTDependencies(lcc, dd, td, null, true);
        dd.dropTableDescriptor(td, this.sd, tc);
        dd.dropAllConglomerateDescriptors(td, tc);
        tc.dropConglomerate(heapId);
        GfxdManagementService.handleEvent(6, this.fullTableName);
    }

    private void dropAllConstraintDescriptors(TableDescriptor td, Activation activation) throws StandardException {
        ConstraintDescriptor cd;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        ConstraintDescriptorList cdl = dd.getConstraintDescriptors(td);
        int index = 0;
        while (index < cdl.size()) {
            TableDescriptor parentDesc;
            cd = cdl.elementAt(index);
            if (cd instanceof ReferencedKeyConstraintDescriptor) {
                ++index;
                continue;
            }
            if (cd instanceof ForeignKeyConstraintDescriptor && !(parentDesc = ((ForeignKeyConstraintDescriptor)cd).getReferencedConstraint().getTableDescriptor()).tableNameEquals(td.getName(), td.getSchemaName())) {
                dm.invalidateFor(((ForeignKeyConstraintDescriptor)cd).getReferencedConstraint().getTableDescriptor(), 19, lcc);
            }
            dm.invalidateFor(cd, 19, lcc);
            this.dropConstraint(cd, td, activation, lcc, true);
        }
        while (cdl.size() > 0) {
            cd = cdl.elementAt(0);
            if (!(cd instanceof ReferencedKeyConstraintDescriptor)) {
                SanityManager.THROWASSERT((String)("Constraint descriptor not an instance of ReferencedKeyConstraintDescriptor as expected.  Is a " + cd.getClass().getName()));
            }
            this.dropConstraint(cd, td, activation, lcc, false);
            if (this.cascade) {
                ConstraintDescriptorList fkcdl = dd.getForeignKeys(cd.getUUID());
                for (int inner = 0; inner < fkcdl.size(); ++inner) {
                    ConstraintDescriptor fkcd = fkcdl.elementAt(inner);
                    dm.invalidateFor(fkcd, 19, lcc);
                    this.dropConstraint(fkcd, td, activation, lcc, true);
                    activation.addWarning(StandardException.newWarning("01500", fkcd.getConstraintName(), fkcd.getTableDescriptor().getName()));
                }
            }
            dm.invalidateFor(cd, 19, lcc);
            dm.clearDependencies(lcc, cd);
        }
    }

    @Override
    public final boolean isReplayable() {
        return !"SESSION".equalsIgnoreCase(this.getSchemaName());
    }

    @Override
    public final String getSchemaName() {
        int dotIndex;
        if (this.sd != null) {
            return this.sd.getSchemaName();
        }
        if (this.fullTableName != null && (dotIndex = this.fullTableName.indexOf(46)) > 0) {
            return this.fullTableName.substring(0, dotIndex);
        }
        return null;
    }

    @Override
    public final String getTableName() {
        return this.tableName;
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

