/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.access.operations.ReceiverDropOperation;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;

public class DropGatewayReceiverConstantAction
extends DDLConstantAction {
    private final String id;
    private final Boolean onlyIfExists;

    DropGatewayReceiverConstantAction(String id, boolean onlyIfExists) {
        this.id = id;
        this.onlyIfExists = onlyIfExists;
    }

    public String toString() {
        return "DROP GATEWAYRECEIVER " + this.id;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return "__GFXD_INTERNAL_GATEWAYRECEIVER_" + this.id;
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        if (!ServerGroupUtils.isDataStore()) {
            return;
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        TransactionController tc = lcc.getTransactionExecute();
        ReceiverDropOperation dropOp = new ReceiverDropOperation(this.id, null, this.onlyIfExists);
        tc.logAndDo(dropOp);
    }

    @Override
    public boolean isCancellable() {
        return false;
    }
}

