/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gnu.trove.THashMap;
import com.gemstone.gnu.trove.TObjectObjectProcedure;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.operations.AsyncQueueDropOperation;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdAsyncEventListenerDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.SQLVarchar;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.DataDictionaryImpl;
import com.pivotal.gemfirexd.internal.impl.sql.catalog.TabInfoImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.List;
import java.util.Set;

public class DropAsyncEventListenerConstantAction
extends DDLConstantAction {
    final String id;
    final boolean onlyIfExists;

    DropAsyncEventListenerConstantAction(String id, boolean onlyIfExists) {
        this.id = id;
        this.onlyIfExists = onlyIfExists;
    }

    public String toString() {
        return "DROP ASYNCEVENTLISTENER " + this.id;
    }

    @Override
    public boolean isDropIfExists() {
        return this.onlyIfExists;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return "__GFXD_INTERNAL_ASYNCLISTENER_" + this.id;
    }

    @Override
    public final boolean isDropStatement() {
        return true;
    }

    @Override
    public boolean isCancellable() {
        return false;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        int rowsDeleted = 0;
        if (!ServerGroupUtils.isDataStore()) {
            return;
        }
        List<GemFireContainer> containers = Misc.getMemStore().getAllContainers();
        for (GemFireContainer container : containers) {
            Set senderIds;
            if (container.getRegion() == null || !container.isApplicationTable() || (senderIds = container.getRegionAttributes().getAsyncEventQueueIds()) == null || senderIds.isEmpty() || !senderIds.contains(this.id)) continue;
            throw StandardException.newException("X0Y25.S", "DROP", (Object)("AsyncEventListener " + this.id), (Object)"table", (Object)container.getQualifiedTableName());
        }
        final LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        final DataDictionaryImpl dd = (DataDictionaryImpl)lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        ExecIndexRow keyRow = dd.getExecutionFactory().getIndexableRow(1);
        keyRow.setColumn(1, new SQLVarchar(this.id));
        TabInfoImpl ti = dd.getNonCoreTI(22);
        rowsDeleted = ti.deleteRow(tc, keyRow, 0);
        if (rowsDeleted == 0) {
            if (this.onlyIfExists) {
                return;
            }
            throw StandardException.newException("42Y55", (Object)"DROP ASYNCEVENTLISTENER", (Object)this.id);
        }
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("DropAsyncEventListener:: removed AsyncEventListener " + this.id + " from SYS table"));
        final THashMap uid_idmap = Misc.getMemStore().getUUID_IDMap();
        if (uid_idmap != null) {
            uid_idmap.forEachEntry(new TObjectObjectProcedure(){

                public boolean execute(Object a, Object b) {
                    if (((String)b).equalsIgnoreCase(DropAsyncEventListenerConstantAction.this.id)) {
                        uid_idmap.remove(a);
                        GfxdAsyncEventListenerDescriptor asyncD = new GfxdAsyncEventListenerDescriptor(DropAsyncEventListenerConstantAction.this.id, (UUID)a);
                        try {
                            dd.getDependencyManager().clearDependencies(lcc, asyncD);
                        }
                        catch (StandardException e) {
                            Misc.getCacheLogWriter().warning("problem while removing dependencies of: " + DropAsyncEventListenerConstantAction.this.id, (Throwable)e);
                        }
                        return false;
                    }
                    return true;
                }
            });
        }
        tc.logAndDo(new AsyncQueueDropOperation(this.id));
    }
}

