/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableArrayHolder;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.store.access.ColumnOrdering;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.SortController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.AggregateSortObserver;
import com.pivotal.gemfirexd.internal.impl.sql.execute.GenericAggregator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScalarAggregateResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

class DistinctScalarAggregateResultSet
extends ScalarAggregateResultSet {
    private ColumnOrdering[] order;
    private int maxRowSize;
    private boolean dropDistinctAggSort;
    private long sortId;
    private ScanController scanController;
    ExecIndexRow sortResultRow;
    private long maxSortLimit;
    private boolean sorted;

    DistinctScalarAggregateResultSet(NoPutResultSet s, boolean isInSortedOrder, int aggregateItem, int orderingItem, Activation a, GeneratedMethod ra, int maxRowSize, int resultSetNumber, boolean singleInputRow, double optimizerEstimatedRowCount, double optimizerEstimatedCost) throws StandardException {
        super(s, isInSortedOrder, aggregateItem, a, ra, resultSetNumber, singleInputRow, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.order = (ColumnOrdering[])((FormatableArrayHolder)a.getSavedObject(orderingItem)).getArray(ColumnOrdering.class);
        this.maxRowSize = maxRowSize;
        this.recordConstructorTime();
    }

    @Override
    public void openCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((!this.isOpen ? 1 : 0) != 0, (String)"DistinctScalarResultSet already open");
        this.isOpen = true;
        this.sortResultRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow.getClone());
        this.sourceExecIndexRow = this.getExecutionFactory().getIndexableRow(this.sortTemplateRow.getClone());
        this.source.openCore();
        this.scanController = this.loadSorter();
        this.sorted = true;
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public final void setMaxSortingLimit(long limit) {
        this.maxSortLimit = limit;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        ExecIndexRow execIndexRow = null;
        ExecIndexRow aggResult = null;
        boolean cloneArg = true;
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.isOpen) {
            while ((execIndexRow = this.getRowFromResultSet(cloneArg)) != null) {
                if (aggResult == null) {
                    cloneArg = false;
                    aggResult = (ExecIndexRow)execIndexRow.getClone();
                    continue;
                }
                this.accumulateScalarAggregation(execIndexRow, aggResult, true);
            }
            if (this.countOfRows == 0) {
                aggResult = (ExecIndexRow)this.finishAggregation(aggResult);
                this.setCurrentRow(aggResult);
                ++this.countOfRows;
            }
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        return aggResult;
    }

    @Override
    public void reopenCore() throws StandardException {
        this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        SanityManager.ASSERT((boolean)this.isOpen, (String)"NormalizeResultSet already open");
        if (this.scanController != null) {
            this.scanController.close();
            this.scanController = null;
        }
        this.source.reopenCore();
        this.scanController = this.loadSorter();
        this.sorted = true;
        ++this.numOpens;
        this.countOfRows = 0;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        super.close(cleanupOnError);
        this.closeSource(cleanupOnError);
    }

    @Override
    public ExecIndexRow getRowFromResultSet(boolean doClone) throws StandardException {
        ExecIndexRow inputRow = null;
        if (this.scanController.next()) {
            this.currentRow = doClone ? this.sortResultRow.getClone() : this.sortResultRow;
            inputRow = this.getExecutionFactory().getIndexableRow(this.currentRow);
            this.scanController.fetch(inputRow);
        }
        return inputRow;
    }

    protected void closeSource(boolean cleanupOnError) throws StandardException {
        if (this.scanController != null) {
            this.scanController.close();
            if (this.dropDistinctAggSort) {
                try {
                    this.getTransactionController().dropSort(this.sortId);
                }
                catch (StandardException standardException) {
                    // empty catch block
                }
                this.dropDistinctAggSort = false;
            }
            this.scanController = null;
        }
        this.source.close(cleanupOnError);
    }

    private ScanController loadSorter() throws StandardException {
        ExecRow sourceRow;
        int inputRowCountEstimate = (int)this.optimizerEstimatedRowCount;
        TransactionController tc = this.getTransactionController();
        GenericAggregator[] aggsNoDistinct = this.getSortAggregators(this.aggInfoList, true, this.activation.getLanguageConnectionContext(), this.source);
        AggregateSortObserver sortObserver = new AggregateSortObserver(true, aggsNoDistinct, this.aggregates, this.sortTemplateRow);
        this.sortId = tc.createSort(null, this.sortTemplateRow, this.order, sortObserver, false, inputRowCountEstimate, this.maxRowSize, this.maxSortLimit);
        SortController sorter = tc.openSort(this.sortId);
        this.dropDistinctAggSort = true;
        while ((sourceRow = this.source.getNextRowCore()) != null) {
            boolean rowInserted = false;
            rowInserted = sorter.insert(sourceRow);
            ++this.rowsInput;
            if (!GemFireXDUtils.isOffHeapEnabled()) continue;
            this.source.releasePreviousByteSource();
        }
        sorter.completedInserts();
        this.scanController = tc.openSortScan(this.sortId, this.activation.getResultSetHoldability());
        inputRowCountEstimate = this.rowsInput;
        return this.scanController;
    }
}

