/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.i18n.MessageService;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecIndexRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.TemporaryRowHolder;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.DynamicCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.ScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexRow;
import com.pivotal.gemfirexd.internal.impl.sql.execute.PlanUtils;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.Properties;
import java.util.Vector;

class DependentResultSet
extends ScanResultSet
implements CursorResultSet {
    ConglomerateController heapCC;
    RowLocation baseRowLocation;
    ExecRow indexRow;
    IndexRow indexQualifierRow;
    ScanController indexSC;
    StaticCompiledOpenConglomInfo indexScoci;
    DynamicCompiledOpenConglomInfo indexDcoci;
    int numFkColumns;
    boolean isOpen;
    boolean deferred;
    TemporaryRowHolderResultSet source;
    TransactionController tc;
    String parentResultSetId;
    int[] fkColArray;
    RowLocation rowLocation;
    TemporaryRowHolder[] sourceRowHolders;
    TemporaryRowHolderResultSet[] sourceResultSets;
    int[] sourceOpened;
    int sArrayIndex;
    Vector sVector;
    protected ScanController scanController;
    protected boolean scanControllerOpened;
    protected boolean isKeyed;
    protected boolean firstScan = true;
    protected ExecIndexRow startPosition;
    protected ExecIndexRow stopPosition;
    protected long conglomId;
    protected DynamicCompiledOpenConglomInfo heapDcoci;
    protected StaticCompiledOpenConglomInfo heapScoci;
    protected GeneratedMethod resultRowAllocator;
    protected GeneratedMethod startKeyGetter;
    protected int startSearchOperator;
    protected GeneratedMethod stopKeyGetter;
    protected int stopSearchOperator;
    protected Qualifier[][] qualifiers;
    public String tableName;
    public String userSuppliedOptimizerOverrides;
    public String indexName;
    protected boolean runTimeStatisticsOn;
    public int rowsPerRead;
    public boolean forUpdate;
    private boolean sameStartStopPosition;
    private Properties scanProperties;
    public String startPositionString;
    public String stopPositionString;
    public boolean isConstraint;
    public boolean coarserLock;
    public boolean oneRowScan;
    protected long rowsThisScan;
    ExecRow searchRow = null;

    DependentResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, String parentResultSetId, long fkIndexConglomId, int fkColArrayItem, int rltItem) throws StandardException {
        super(activation, resultSetNumber, resultRowAllocator, lockMode, tableLocked, 4, colRefItem, optimizerEstimatedRowCount, optimizerEstimatedCost);
        this.conglomId = conglomId;
        this.heapScoci = scoci;
        this.heapDcoci = activation.getTransactionController().getDynamicCompiledConglomInfo(conglomId);
        SanityManager.ASSERT((activation != null ? 1 : 0) != 0, (String)"table scan must get activation context");
        SanityManager.ASSERT((resultRowAllocator != null ? 1 : 0) != 0, (String)"table scan must get row allocator");
        if (sameStartStopPosition) {
            SanityManager.ASSERT((stopKeyGetter == null ? 1 : 0) != 0, (String)"stopKeyGetter expected to be null when sameStartStopPosition is true");
        }
        this.resultRowAllocator = resultRowAllocator;
        this.startKeyGetter = startKeyGetter;
        this.startSearchOperator = startSearchOperator;
        this.stopKeyGetter = stopKeyGetter;
        this.stopSearchOperator = stopSearchOperator;
        this.sameStartStopPosition = sameStartStopPosition;
        this.qualifiers = qualifiers;
        this.tableName = tableName;
        this.userSuppliedOptimizerOverrides = userSuppliedOptimizerOverrides;
        this.indexName = "On Foreign Key";
        this.isConstraint = isConstraint;
        this.forUpdate = forUpdate;
        this.rowsPerRead = rowsPerRead;
        this.oneRowScan = oneRowScan;
        this.runTimeStatisticsOn = activation != null && activation.getLanguageConnectionContext().getRunTimeStatisticsMode();
        this.tc = activation.getTransactionController();
        this.indexDcoci = this.tc.getDynamicCompiledConglomInfo(fkIndexConglomId);
        this.indexScoci = this.tc.getStaticCompiledConglomInfo(fkIndexConglomId);
        this.parentResultSetId = parentResultSetId;
        this.fkColArray = (int[])activation.getSavedObject(fkColArrayItem);
        this.rowLocation = (RowLocation)activation.getSavedObject(rltItem);
        this.numFkColumns = this.fkColArray.length;
        this.indexQualifierRow = new IndexRow(this.numFkColumns);
        this.recordConstructorTime();
    }

    private ScanController openIndexScanController(ExecRow searchRow) throws StandardException {
        this.setupQualifierRow(searchRow);
        this.indexSC = this.tc.openCompiledScan(false, 4, this.lockMode, this.isolationLevel, null, this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, this.indexScoci, this.indexDcoci);
        return this.indexSC;
    }

    private void reopenIndexScanController(ExecRow searchRow) throws StandardException {
        this.setupQualifierRow(searchRow);
        this.indexSC.reopenScan(this.indexQualifierRow.getRowArray(), 1, null, this.indexQualifierRow.getRowArray(), -1, null);
    }

    private void setupQualifierRow(ExecRow searchRow) {
        DataValueDescriptor[] indexColArray = this.indexQualifierRow.getRowArray();
        DataValueDescriptor[] baseColArray = searchRow.getRowArray();
        for (int i = 0; i < this.numFkColumns; ++i) {
            indexColArray[i] = baseColArray[this.fkColArray[i] - 1];
        }
    }

    private void openIndexScan(ExecRow searchRow) throws StandardException {
        if (this.indexSC == null) {
            this.indexSC = this.openIndexScanController(searchRow);
            this.indexRow = this.indexQualifierRow.getClone();
            this.indexRow.setColumn(this.numFkColumns + 1, this.rowLocation.getClone());
        } else {
            this.reopenIndexScanController(searchRow);
        }
    }

    private ExecRow fetchIndexRow() throws StandardException {
        if (!this.indexSC.fetchNext(this.indexRow)) {
            return null;
        }
        return this.indexRow;
    }

    private ExecRow fetchBaseRow() throws StandardException {
        boolean base_row_exists;
        if (this.currentRow == null) {
            this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed);
        }
        this.baseRowLocation = (RowLocation)this.indexRow.getLastColumn();
        this.baseRowLocation = this.heapCC.fetch(this.baseRowLocation, this.candidate, this.accessedCols, false);
        boolean bl = base_row_exists = this.baseRowLocation != null;
        if (base_row_exists) {
            this.indexRow.setColumn(this.indexRow.getRowArray().length, this.baseRowLocation);
        }
        SanityManager.ASSERT((boolean)base_row_exists, (String)"base row disappeared.");
        return this.currentRow;
    }

    @Override
    public ExecRow getNextRowCore() throws StandardException {
        long l = this.beginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.searchRow == null && (this.searchRow = this.getNextParentRow()) != null) {
            this.openIndexScan(this.searchRow);
        }
        ExecRow currentIndexRow = null;
        while (this.searchRow != null && (currentIndexRow = this.fetchIndexRow()) == null) {
            this.searchRow = this.getNextParentRow();
            if (this.searchRow == null) continue;
            this.openIndexScan(this.searchRow);
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(this.beginTime);
        }
        if (currentIndexRow != null) {
            ++this.rowsSeen;
            return this.fetchBaseRow();
        }
        return currentIndexRow;
    }

    private ExecRow getNextParentRow() throws StandardException {
        TemporaryRowHolder rowHolder;
        if (this.sourceOpened[this.sArrayIndex] == 0) {
            rowHolder = this.sourceRowHolders[this.sArrayIndex];
            this.source = (TemporaryRowHolderResultSet)rowHolder.getResultSet();
            this.source.open();
            this.sourceOpened[this.sArrayIndex] = -1;
            this.sourceResultSets[this.sArrayIndex] = this.source;
        }
        if (this.sourceOpened[this.sArrayIndex] == 1) {
            this.source = this.sourceResultSets[this.sArrayIndex];
            this.source.reStartScan(this.sourceRowHolders[this.sArrayIndex].getTemporaryConglomId(), this.sourceRowHolders[this.sArrayIndex].getPositionIndexConglomId());
            this.sourceOpened[this.sArrayIndex] = -1;
        }
        if (this.sVector.size() > this.sourceRowHolders.length) {
            this.addNewSources();
        }
        ExecRow cRow = this.source.getNextRow();
        while (cRow == null && this.sArrayIndex + 1 < this.sourceRowHolders.length) {
            ++this.sArrayIndex;
            if (this.sourceOpened[this.sArrayIndex] == 0) {
                rowHolder = this.sourceRowHolders[this.sArrayIndex];
                this.source = (TemporaryRowHolderResultSet)rowHolder.getResultSet();
                this.source.open();
                this.sourceOpened[this.sArrayIndex] = -1;
                this.sourceResultSets[this.sArrayIndex] = this.source;
            }
            if (this.sourceOpened[this.sArrayIndex] == 1) {
                this.source = this.sourceResultSets[this.sArrayIndex];
                this.source.reStartScan(this.sourceRowHolders[this.sArrayIndex].getTemporaryConglomId(), this.sourceRowHolders[this.sArrayIndex].getPositionIndexConglomId());
                this.sourceOpened[this.sArrayIndex] = -1;
            }
            cRow = this.source.getNextRow();
        }
        if (cRow == null) {
            this.sArrayIndex = 0;
            for (int i = 0; i < this.sourceOpened.length; ++i) {
                this.sourceOpened[i] = 1;
            }
        }
        return cRow;
    }

    public ConglomerateController openHeapConglomerateController() throws StandardException {
        return this.tc.openCompiledConglomerate(false, 4, this.lockMode, this.isolationLevel, this.heapScoci, this.heapDcoci);
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        if (this.runTimeStatisticsOn) {
            this.startPositionString = this.printStartPosition();
            this.stopPositionString = this.printStopPosition();
            this.scanProperties = this.getScanProperties();
        }
        if (this.indexSC != null) {
            this.indexSC.close();
            this.indexSC = null;
        }
        if (this.heapCC != null) {
            this.heapCC.close();
            this.heapCC = null;
        }
        if (this.isOpen) {
            this.source.close(cleanupOnError);
        }
        if (this.statisticsTimingOn) {
            this.closeTime += this.getElapsedNanos(this.beginTime);
        }
    }

    @Override
    public void finish() throws StandardException {
        if (this.source != null) {
            this.source.finish();
        }
        this.finishAndRTS();
    }

    @Override
    public void openCore() throws StandardException {
        this.initIsolationLevel();
        this.sVector = this.activation.getParentResultSet(this.parentResultSetId);
        int size = this.sVector.size();
        this.sourceRowHolders = new TemporaryRowHolder[size];
        this.sourceOpened = new int[size];
        this.sourceResultSets = new TemporaryRowHolderResultSet[size];
        for (int i = 0; i < size; ++i) {
            this.sourceRowHolders[i] = (TemporaryRowHolder)this.sVector.elementAt(i);
            this.sourceOpened[i] = 0;
        }
        this.heapCC = this.openHeapConglomerateController();
        ++this.numOpens;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(this.beginTime);
        }
    }

    private void addNewSources() {
        int size = this.sVector.size();
        TemporaryRowHolder[] tsourceRowHolders = new TemporaryRowHolder[size];
        int[] tsourceOpened = new int[size];
        TemporaryRowHolderResultSet[] tsourceResultSets = new TemporaryRowHolderResultSet[size];
        System.arraycopy(this.sourceRowHolders, 0, tsourceRowHolders, 0, this.sourceRowHolders.length);
        System.arraycopy(this.sourceOpened, 0, tsourceOpened, 0, this.sourceOpened.length);
        System.arraycopy(this.sourceResultSets, 0, tsourceResultSets, 0, this.sourceResultSets.length);
        for (int i = this.sourceRowHolders.length; i < size; ++i) {
            tsourceRowHolders[i] = (TemporaryRowHolder)this.sVector.elementAt(i);
            tsourceOpened[i] = 0;
        }
        this.sourceRowHolders = tsourceRowHolders;
        this.sourceOpened = tsourceOpened;
        this.sourceResultSets = tsourceResultSets;
    }

    @Override
    boolean canGetInstantaneousLocks() {
        return false;
    }

    @Override
    public long getTimeSpent(int type, int timeType) {
        return PlanUtils.getTimeSpent(this.constructorTime, this.openTime, this.nextTime, this.closeTime, timeType);
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        return this.baseRowLocation;
    }

    @Override
    public ExecRow getCurrentRow() throws StandardException {
        return this.currentRow;
    }

    public Properties getScanProperties() {
        if (this.scanProperties == null) {
            this.scanProperties = new Properties();
        }
        try {
            if (this.indexSC != null) {
                this.indexSC.getScanInfo().getAllScanInfo(this.scanProperties);
                this.coarserLock = this.indexSC.isTableLocked() && this.lockMode == 6;
            }
        }
        catch (StandardException standardException) {
            // empty catch block
        }
        return this.scanProperties;
    }

    public String printStartPosition() {
        return this.printPosition(1, this.indexQualifierRow);
    }

    public String printStopPosition() {
        return this.printPosition(-1, this.indexQualifierRow);
    }

    private String printPosition(int searchOperator, ExecIndexRow positioner) {
        String idt = "";
        String output = "";
        String searchOp = null;
        switch (searchOperator) {
            case 1: {
                searchOp = ">=";
                break;
            }
            case -1: {
                searchOp = ">";
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("Unknown search operator " + searchOperator));
                searchOp = "unknown value (" + searchOperator + ")";
            }
        }
        if (positioner != null) {
            output = output + "\t" + MessageService.getTextMessage("42Z40.U", searchOp, String.valueOf(positioner.nColumns())) + "\n";
            output = output + "\t" + MessageService.getTextMessage("42Z41.U") + "\n";
            for (int position = 0; position < positioner.nColumns(); ++position) {
                if (!positioner.areNullsOrdered(position)) continue;
                output = output + position + " ";
            }
        }
        return output + "\n";
    }

    public String printQualifiers() {
        String idt = "";
        return idt + MessageService.getTextMessage("42Z37.U");
    }

    @Override
    public void updateRowLocationPostRead() throws StandardException {
        this.upgradeReadLockToWrite(this.baseRowLocation, null);
    }

    @Override
    public void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (localTXState != null) {
            this.releaseRowLocationLock(this.baseRowLocation, null);
        }
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        if (this.sourceResultSets != null) {
            visitor.setNumberOfChildren(this.sourceResultSets.length);
        }
        visitor.visit(this);
        for (int i = 0; i < this.sourceResultSets.length; ++i) {
            this.sourceResultSets[i].accept(visitor);
        }
    }

    @Override
    public StringBuilder buildQueryPlan(StringBuilder builder, PlanUtils.Context context) {
        super.buildQueryPlan(builder, context);
        PlanUtils.xmlTermTag(builder, context, "TABLESCAN");
        for (int i = 0; i < this.sourceResultSets.length; ++i) {
            this.source.buildQueryPlan(builder, context.pushContext());
        }
        PlanUtils.xmlCloseTag(builder, context, this);
        return builder;
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        if (this.indexSC instanceof SortedMap2IndexScanController) {
            SortedMap2IndexScanController sc = (SortedMap2IndexScanController)this.indexSC;
            return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, sc, sc.getCurrentKey(), sc.getCurrentNodeVersion(), (GemFireTransaction)this.lcc.getTransactionExecute());
        }
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, (GemFireTransaction)this.lcc.getTransactionExecute());
    }
}

