/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.distributed.internal.DM;
import com.gemstone.gemfire.internal.cache.TXState;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserver;
import com.pivotal.gemfirexd.internal.engine.GemFireXDQueryObserverHolder;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.distributed.ReferencedKeyCheckerMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.message.RegionExecutorMessage;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultDescription;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.RowChanger;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DMLWriteResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DeleteConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RISetChecker;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ResultSetStatisticsVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RowUtil;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TemporaryRowHolderImpl;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEventActivator;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerEvents;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TriggerInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;
import java.util.ArrayList;
import java.util.Properties;

public class DeleteResultSet
extends DMLWriteResultSet {
    private TransactionController tc;
    DeleteConstantAction constants;
    protected ResultDescription resultDescription;
    protected NoPutResultSet source;
    NoPutResultSet savedSource;
    int numIndexes;
    protected RowChanger rc;
    private ExecRow row;
    protected ConglomerateController deferredBaseCC;
    protected TemporaryRowHolderImpl rowHolder;
    private int numOpens;
    private boolean firstExecute;
    private FormatableBitSet baseRowReadList;
    private int rlColumnNumber;
    protected FKInfo[] fkInfoArray;
    private TriggerInfo triggerInfo;
    private final ArrayList<RowLocation> referencedKeyCheckRows;
    private final GemFireContainer container;
    private RISetChecker fkChecker;
    private TriggerEventActivator triggerActivator;
    private boolean noTriggersOrFks;
    ExecRow deferredSparseRow;
    ExecRow deferredBaseRow;
    int lockMode;
    protected boolean cascadeDelete;
    ExecRow deferredRLRow = null;
    int numberOfBaseColumns = 0;
    protected final GemFireXDQueryObserver observer = GemFireXDQueryObserverHolder.getInstance();

    DeleteResultSet(NoPutResultSet source, Activation activation) throws StandardException {
        this(source, activation.getConstantAction(), activation);
    }

    DeleteResultSet(NoPutResultSet source, ConstantAction passedInConstantAction, Activation activation) throws StandardException {
        super(activation, passedInConstantAction);
        this.source = source;
        this.tc = activation.getTransactionController();
        this.constants = (DeleteConstantAction)this.constantAction;
        this.fkInfoArray = this.constants.getFKInfo();
        this.triggerInfo = this.constants.getTriggerInfo();
        this.noTriggersOrFks = this.fkInfoArray == null && this.triggerInfo == null;
        this.baseRowReadList = this.constants.getBaseRowReadList();
        this.resultDescription = source != null ? activation.getResultDescription() : this.constants.resultDescription;
        this.container = ((MemConglomerate)this.constants.heapSCOCI.getConglom()).getGemFireContainer();
        this.referencedKeyCheckRows = !this.container.isTemporaryContainer() && this.container.getExtraTableInfo().getReferencedKeyColumns() != null ? new ArrayList() : null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void open() throws StandardException {
        try {
            this.setup();
            boolean rowsFound = this.collectAffectedRows();
            if (!rowsFound) {
                this.activation.addWarning(StandardException.newNoRowFoundWarning());
            }
            this.checkCancellationFlag();
            if (this.referencedKeyCheckRows != null) {
                RegionExecutorMessage msg;
                int numRefKeys = this.referencedKeyCheckRows.size();
                if (this.observer != null) {
                    this.observer.onDeleteResultSetOpenBeforeRefChecks(this);
                }
                if (numRefKeys > 0) {
                    ReferencedKeyCheckerMessage.referencedKeyCheck(this.container, this.lcc, null, this.referencedKeyCheckRows, false, null, null, null, null, null);
                }
                if (this.observer != null) {
                    this.observer.onDeleteResultSetOpenAfterRefChecks(this);
                }
                this.checkCancellationFlag();
                GemFireTransaction tran = (GemFireTransaction)this.tc;
                boolean doDeletes = true;
                if (tran.getActiveTXState() == null && (msg = (RegionExecutorMessage)this.activation.getFunctionContext()) != null && msg.getNumRecipients() > 1) {
                    DM dm = Misc.getDistributedSystem().getDM();
                    ReferencedKeyCheckerMessage.ReferencedKeyReplyProcessor processor = new ReferencedKeyCheckerMessage.ReferencedKeyReplyProcessor(dm, msg.getSender());
                    msg.getResultSender().sendResult((Object)processor.getProcessorId());
                    doDeletes = processor.waitForResult();
                }
                if (doDeletes) {
                    if (numRefKeys > 0) {
                        for (RowLocation rl : this.referencedKeyCheckRows) {
                            if (this.rc.deleteRow(this.deferredBaseRow, rl)) {
                                ++this.rowCount;
                            }
                            this.source.markRowAsDeleted();
                        }
                    }
                    this.rc.finish();
                }
            } else if (this.constants.deferred) {
                this.runFkChecker(true);
                this.deleteDeferredRows();
                this.runFkChecker(false);
                this.rc.finish();
            }
            if (!this.lcc.isSkipListeners() && this.container.getRegion().isSerialWanEnabled()) {
                this.distributeBulkOpToDBSynchronizer();
            }
            if (this.lcc.getRunTimeStatisticsMode()) {
                this.savedSource = this.source;
            }
        }
        catch (Throwable throwable) {
            this.cleanUp(false);
            this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
            throw throwable;
        }
        this.cleanUp(false);
        this.endTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
    }

    @Override
    protected void setup() throws StandardException {
        super.setup();
        this.firstExecute = this.rc == null;
        try {
            if (this.numOpens++ == 0) {
                this.source.openCore();
            } else {
                this.source.reopenCore();
            }
        }
        catch (StandardException se) {
            this.activation.checkStatementValidity();
            throw se;
        }
        this.activation.checkStatementValidity();
        if (this.firstExecute) {
            this.rc = this.lcc.getLanguageConnectionFactory().getExecutionFactory().getRowChanger(this.constants.conglomId, this.constants.heapSCOCI, this.heapDCOCI, ReuseFactory.getZeroLenIRGArray(), ReuseFactory.getZeroLenLongArray(), this.constants.indexSCOCIs, this.indexDCOCIs, this.constants.numColumns, this.tc, null, this.baseRowReadList, this.constants.getBaseRowReadMap(), this.constants.getStreamStorableHeapColIds(), this.activation);
        } else {
            this.lcc.getStatementContext().setTopResultSet(this, this.subqueryTrackingArray);
        }
        this.lockMode = this.decodeLockMode(this.constants.lockMode);
        this.rc.open(this.lockMode);
        if (this.constants.deferred || this.cascadeDelete) {
            this.activation.clearIndexScanInfo();
        }
        if (this.observer != null) {
            this.observer.onDeleteResultSetOpen(this);
        }
        this.rowCount = 0;
        if (!this.cascadeDelete) {
            this.row = this.getNextRowCore(this.source);
        }
        if (this.resultDescription == null) {
            SanityManager.ASSERT((this.triggerInfo == null ? 1 : 0) != 0, (String)"result description is needed to supply to trigger result sets");
            this.numberOfBaseColumns = this.row == null ? 0 : this.row.nColumns();
        } else {
            this.numberOfBaseColumns = this.resultDescription.getColumnCount();
        }
        this.numIndexes = this.constants.irgs.length;
        if (this.referencedKeyCheckRows == null && (this.constants.deferred || this.cascadeDelete)) {
            Properties properties = new Properties();
            this.deferredRLRow = RowUtil.getEmptyValueRow(1, this.lcc);
            this.rlColumnNumber = this.noTriggersOrFks ? 1 : this.numberOfBaseColumns;
            this.rowHolder = this.cascadeDelete ? new TemporaryRowHolderImpl(this.activation, properties, false) : new TemporaryRowHolderImpl(this.activation, properties);
            this.rc.setRowHolder(this.rowHolder);
        }
    }

    boolean collectAffectedRows() throws StandardException {
        TXState localTXState = this.source.initLocalTXState();
        RowLocation baseRowLocation = null;
        boolean rowsFound = false;
        if (this.cascadeDelete) {
            this.row = this.getNextRowCore(this.source);
        }
        while (this.row != null) {
            rowsFound = true;
            DataValueDescriptor rlColumn = this.row.getLastColumn();
            if (this.referencedKeyCheckRows != null) {
                baseRowLocation = (RowLocation)rlColumn.getObject();
                SanityManager.ASSERT((baseRowLocation != null ? 1 : 0) != 0, (String)"baseRowLocation is null");
                if (localTXState != null && baseRowLocation != null) {
                    this.source.upgradeReadLockToWrite(baseRowLocation, this.container);
                }
                this.referencedKeyCheckRows.add(baseRowLocation);
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns - 1, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns - 1);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
            } else if (this.constants.deferred || this.cascadeDelete) {
                if (this.noTriggersOrFks) {
                    this.deferredRLRow.setColumn(1, rlColumn);
                    this.rowHolder.insert(this.deferredRLRow);
                } else {
                    this.rowHolder.insert(this.row);
                }
                if (this.deferredBaseRow == null) {
                    this.deferredBaseRow = RowUtil.getEmptyValueRow(this.numberOfBaseColumns - 1, this.lcc);
                    RowUtil.copyCloneColumns(this.deferredBaseRow, this.row, this.numberOfBaseColumns - 1);
                    this.deferredSparseRow = this.makeDeferredSparseRow(this.deferredBaseRow, this.baseRowReadList, this.lcc);
                }
                baseRowLocation = (RowLocation)rlColumn.getObject();
                if (localTXState != null && baseRowLocation != null) {
                    this.source.upgradeReadLockToWrite(baseRowLocation, this.container);
                }
            } else {
                baseRowLocation = (RowLocation)rlColumn.getObject();
                SanityManager.ASSERT((baseRowLocation != null ? 1 : 0) != 0, (String)"baseRowLocation is null");
                if (localTXState != null && baseRowLocation != null) {
                    this.source.upgradeReadLockToWrite(baseRowLocation, this.container);
                }
                if (this.rc.deleteRow(this.row, baseRowLocation)) {
                    ++this.rowCount;
                }
                this.source.markRowAsDeleted();
            }
            this.source.releasePreviousByteSource();
            if (this.constants.singleRowSource) {
                this.row = null;
                continue;
            }
            this.row = this.getNextRowCore(this.source);
        }
        return rowsFound;
    }

    void fireBeforeTriggers() throws StandardException {
        if (this.activation.getFunctionContext() != null) {
            return;
        }
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("DeleteResultSet::fireBeforeTriggers activation is: " + this.activation + " function context is null"), (Throwable)new Throwable());
        }
        if (this.triggerInfo != null) {
            if (this.triggerActivator == null) {
                this.triggerActivator = new TriggerEventActivator(this.lcc, this.tc, this.constants.targetUUID, this.triggerInfo, 2, this.activation, null);
            } else {
                this.triggerActivator.reopen();
            }
            this.triggerActivator.notifyEvent(TriggerEvents.BEFORE_DELETE, this.rowHolder.getResultSet(), null);
            this.triggerActivator.cleanup(false);
        }
    }

    void fireAfterTriggers() throws StandardException {
        if (this.activation.getFunctionContext() != null) {
            return;
        }
        if (GemFireXDUtils.TraceActivation) {
            SanityManager.DEBUG_PRINT((String)"TraceActivation", (String)("DeleteResultSet::fireAfterTriggers activation is: " + this.activation + " function context is null"), (Throwable)new Throwable());
        }
        if (this.triggerActivator != null) {
            this.triggerActivator.reopen();
            this.triggerActivator.notifyEvent(TriggerEvents.AFTER_DELETE, this.rowHolder.getResultSet(), null);
            this.triggerActivator.cleanup(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void deleteDeferredRows() throws StandardException {
        if (this.observer != null) {
            this.observer.beforeDeferredDelete();
        }
        ExecRow deferredRLRow = null;
        this.deferredBaseCC = this.tc.openCompiledConglomerate(false, 4 | 0x2000, this.lockMode, 5, this.constants.heapSCOCI, this.heapDCOCI);
        CursorResultSet rs = this.rowHolder.getResultSet();
        try {
            FormatableBitSet readBitSet = RowUtil.shift(this.baseRowReadList, 1);
            rs.open();
            while ((deferredRLRow = rs.getNextRow()) != null) {
                boolean row_exists;
                DataValueDescriptor rlColumn = deferredRLRow.getColumn(this.rlColumnNumber);
                RowLocation baseRowLocation = (RowLocation)rlColumn.getObject();
                boolean bl = row_exists = baseRowLocation != null;
                if (this.cascadeDelete && !row_exists) continue;
                if (!row_exists) {
                    SanityManager.THROWASSERT((String)("could not find row " + baseRowLocation));
                }
                if (this.rc.deleteRow(this.deferredBaseRow, baseRowLocation)) {
                    ++this.rowCount;
                }
                this.source.markRowAsDeleted();
            }
        }
        finally {
            rs.close(false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void runFkChecker(boolean restrictCheckOnly) throws StandardException {
        ExecRow deferredRLRow = null;
        if (this.fkChecker != null) {
            CursorResultSet rs = this.rowHolder.getResultSet();
            try {
                rs.open();
                while ((deferredRLRow = rs.getNextRow()) != null) {
                    this.fkChecker.doPKCheck(deferredRLRow, restrictCheckOnly);
                }
            }
            finally {
                rs.close(false);
            }
        }
    }

    NoPutResultSet createDependentSource(RowChanger rc) throws StandardException {
        return null;
    }

    @Override
    public void cleanUp(boolean cleanupOnError) throws StandardException {
        this.numOpens = 0;
        try {
            if (this.source != null) {
                this.source.close(cleanupOnError);
            }
            if (this.rc != null) {
                this.rc.close();
            }
            if (this.rowHolder != null) {
                this.rowHolder.close();
            }
            if (this.fkChecker != null) {
                this.fkChecker.close();
            }
            if (this.deferredBaseCC != null) {
                this.deferredBaseCC.close();
            }
            this.deferredBaseCC = null;
            if (this.rc != null) {
                this.rc.close();
            }
        }
        finally {
            super.close(cleanupOnError);
        }
    }

    @Override
    public void finish() throws StandardException {
        if (this.source != null) {
            this.source.finish();
        }
        super.finish();
    }

    @Override
    public void accept(ResultSetStatisticsVisitor visitor) {
        visitor.setNumberOfChildren(1);
        visitor.visit(this);
        this.source.accept(visitor);
    }
}

