/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.catalog.TypeDescriptor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.RoutineAliasInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.context.ContextManager;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Dependent;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.AliasDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColPermsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DependencyDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.PermissionsDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementColumnPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementRoutinePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementSchemaPermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.StatementTablePermission;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.store.access.ConglomerateController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ColumnInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateSchemaConstantAction;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;

public abstract class DDLConstantAction
implements ConstantAction {
    private CreateSchemaConstantAction implicitSchema;

    static SchemaDescriptor getAndCheckSchemaDescriptor(DataDictionary dd, UUID schemaId, String statementType) throws StandardException {
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaId, null);
        return sd;
    }

    SchemaDescriptor getSchemaDescriptorForCreate(DataDictionary dd, Activation activation, String schemaName) throws StandardException {
        this.implicitSchema = null;
        TransactionController tc = activation.getLanguageConnectionContext().getTransactionExecute();
        SchemaDescriptor sd = dd.getSchemaDescriptor(schemaName, tc, false);
        if (sd == null || sd.getUUID() == null) {
            block5: {
                CreateSchemaConstantAction csca = new CreateSchemaConstantAction(schemaName, null);
                if (activation.getLanguageConnectionContext().isInitialDefaultSchema(schemaName)) {
                    DDLConstantAction.executeCAPreferSubTrans(csca, tc, activation);
                } else {
                    try {
                        csca.executeConstantAction(activation);
                        this.implicitSchema = csca;
                    }
                    catch (StandardException se) {
                        if (se.getMessageId().equals("X0Y68.S")) break block5;
                        throw se;
                    }
                }
            }
            sd = dd.getSchemaDescriptor(schemaName, tc, true);
        }
        return sd;
    }

    private static void executeCAPreferSubTrans(CreateSchemaConstantAction csca, TransactionController tc, Activation activation) throws StandardException {
        TransactionController useTc = null;
        TransactionController nestedTc = null;
        try {
            useTc = nestedTc = tc.startNestedUserTransaction(false);
        }
        catch (StandardException e) {
            SanityManager.THROWASSERT((String)"Unexpected: not able to start nested transaction to auto-create schema", (Throwable)e);
            useTc = tc;
        }
        while (true) {
            try {
                csca.executeConstantAction(activation, useTc);
            }
            catch (StandardException se) {
                if (se.getMessageId().equals("40XL1")) {
                    if (useTc == nestedTc) {
                        useTc = tc;
                        nestedTc.destroy();
                        continue;
                    }
                } else if (se.getMessageId().equals("X0Y68.S")) break;
                if (useTc == nestedTc) {
                    nestedTc.destroy();
                }
                throw se;
            }
            break;
        }
        if (useTc == nestedTc) {
            nestedTc.commit();
            nestedTc.destroy();
        }
    }

    protected void adjustUDTDependencies(LanguageConnectionContext lcc, DataDictionary dd, TableDescriptor td, ColumnInfo[] columnInfos, boolean dropWholeTable) throws StandardException {
        if (!dropWholeTable && columnInfos == null) {
            return;
        }
        TransactionController tc = lcc.getTransactionExecute();
        int changedColumnCount = columnInfos == null ? 0 : columnInfos.length;
        HashMap<String, AliasDescriptor> addUdtMap = new HashMap<String, AliasDescriptor>();
        HashMap<String, AliasDescriptor> dropUdtMap = new HashMap<String, AliasDescriptor>();
        HashSet<String> addColumnNames = new HashSet<String>();
        HashSet<String> dropColumnNames = new HashSet<String>();
        for (int i = 0; i < changedColumnCount; ++i) {
            ColumnInfo ci = columnInfos[i];
            AliasDescriptor ad = dd.getAliasDescriptorForUDT(tc, columnInfos[i].dataType);
            if (ad == null) continue;
            String key = ad.getObjectID().toString();
            if (ci.action == 0) {
                addColumnNames.add(ci.name);
                if (addUdtMap.get(key) != null) continue;
                addUdtMap.put(key, ad);
                continue;
            }
            if (ci.action != 1) continue;
            dropColumnNames.add(ci.name);
            dropUdtMap.put(key, ad);
        }
        if (!dropWholeTable && addUdtMap.size() == 0 && dropUdtMap.size() == 0) {
            return;
        }
        ColumnDescriptorList cdl = td.getColumnDescriptorList();
        int totalColumnCount = cdl.size();
        for (int i = 0; i < totalColumnCount; ++i) {
            AliasDescriptor ad;
            ColumnDescriptor cd = cdl.elementAt(i);
            if (addColumnNames.contains(cd.getColumnName()) || dropColumnNames.contains(cd.getColumnName()) || (ad = dd.getAliasDescriptorForUDT(tc, cd.getType())) == null) continue;
            String key = ad.getObjectID().toString();
            if (dropWholeTable) {
                dropUdtMap.put(key, ad);
                continue;
            }
            if (addUdtMap.get(key) != null) {
                addUdtMap.remove(key);
            }
            if (dropUdtMap.get(key) == null) continue;
            dropUdtMap.remove(key);
        }
        this.adjustUDTDependencies(lcc, dd, (Dependent)td, addUdtMap, dropUdtMap);
    }

    private void adjustUDTDependencies(LanguageConnectionContext lcc, DataDictionary dd, Dependent dependent, HashMap addUdtMap, HashMap dropUdtMap) throws StandardException {
        if (addUdtMap.size() == 0 && dropUdtMap.size() == 0) {
            return;
        }
        TransactionController tc = lcc.getTransactionExecute();
        DependencyManager dm = dd.getDependencyManager();
        ContextManager cm = lcc.getContextManager();
        for (AliasDescriptor ad : addUdtMap.values()) {
            dm.addDependency(dependent, ad, cm);
        }
        for (AliasDescriptor ad : dropUdtMap.values()) {
            DependencyDescriptor dependency = new DependencyDescriptor(dependent, ad);
            dd.dropStoredDependency(dependency, tc);
        }
    }

    protected void invalidatePreparedStatement(Activation activation, int action) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        ExecPreparedStatement st = activation.getPreparedStatement();
        if (st != null) {
            st.makeInvalid(action, lcc);
        }
    }

    protected void adjustUDTDependencies(LanguageConnectionContext lcc, DataDictionary dd, AliasDescriptor ad, boolean adding) throws StandardException {
        TypeDescriptor[] paramTypes;
        int i;
        AliasDescriptor returnTypeAD;
        switch (ad.getAliasType()) {
            case 'F': 
            case 'P': {
                break;
            }
            default: {
                return;
            }
        }
        TransactionController tc = lcc.getTransactionExecute();
        RoutineAliasInfo aliasInfo = (RoutineAliasInfo)ad.getAliasInfo();
        HashMap<String, AliasDescriptor> addUdtMap = new HashMap<String, AliasDescriptor>();
        HashMap dropUdtMap = new HashMap();
        HashMap<String, AliasDescriptor> udtMap = adding ? addUdtMap : dropUdtMap;
        TypeDescriptor rawReturnType = aliasInfo.getReturnType();
        if (rawReturnType != null && (returnTypeAD = dd.getAliasDescriptorForUDT(tc, DataTypeDescriptor.getType(rawReturnType))) != null) {
            udtMap.put(returnTypeAD.getObjectID().toString(), returnTypeAD);
        }
        if (rawReturnType != null && rawReturnType.isRowMultiSet()) {
            TypeDescriptor[] columnTypes = rawReturnType.getRowTypes();
            int columnCount = columnTypes.length;
            for (i = 0; i < columnCount; ++i) {
                AliasDescriptor columnTypeAD = dd.getAliasDescriptorForUDT(tc, DataTypeDescriptor.getType(columnTypes[i]));
                if (columnTypeAD == null) continue;
                udtMap.put(columnTypeAD.getObjectID().toString(), columnTypeAD);
            }
        }
        if ((paramTypes = aliasInfo.getParameterTypes()) != null) {
            int paramCount = paramTypes.length;
            for (i = 0; i < paramCount; ++i) {
                AliasDescriptor paramType = dd.getAliasDescriptorForUDT(tc, DataTypeDescriptor.getType(paramTypes[i]));
                if (paramType == null) continue;
                udtMap.put(paramType.getObjectID().toString(), paramType);
            }
        }
        this.adjustUDTDependencies(lcc, dd, ad, addUdtMap, dropUdtMap);
    }

    final void lockTableForDDL(TransactionController tc, long heapConglomerateNumber, boolean exclusiveMode) throws StandardException {
        ConglomerateController cc = tc.openConglomerate(heapConglomerateNumber, false, exclusiveMode ? 68 : 64, 7, 5);
        cc.close();
    }

    protected String constructToString(String statementType, String objectName) {
        return statementType + objectName;
    }

    protected void storeConstraintDependenciesOnPrivileges(Activation activation, Dependent dependent, UUID refTableUUID) throws StandardException {
        List requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        if (!lcc.getAuthorizationId().equals(dd.getAuthorizationDatabaseOwner()) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            for (StatementPermission statPerm : requiredPermissionsList) {
                StatementColumnPermission statementColumnPermission;
                StatementTablePermission statementTablePermission;
                if (!(statPerm instanceof StatementTablePermission) ? statPerm instanceof StatementSchemaPermission || statPerm instanceof StatementRoutinePermission : (statementTablePermission = (StatementTablePermission)statPerm).getPrivType() != 2 || !statementTablePermission.getTableUUID().equals(refTableUUID)) continue;
                PermissionsDescriptor permDesc = statPerm.getPermissionDescriptor(lcc.getAuthorizationId(), dd);
                if (permDesc == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    if (permDesc.checkOwner(lcc.getAuthorizationId())) break;
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    break;
                }
                if (permDesc.checkOwner(lcc.getAuthorizationId())) break;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                if (!(permDesc instanceof ColPermsDescriptor) || (permDesc = (statementColumnPermission = (StatementColumnPermission)statPerm).getPUBLIClevelColPermsDescriptor(lcc.getAuthorizationId(), dd)) == null) break;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                break;
            }
        }
    }

    protected void storeViewTriggerDependenciesOnPrivileges(Activation activation, Dependent dependent) throws StandardException {
        List requiredPermissionsList;
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        if (!lcc.getAuthorizationId().equals(dd.getAuthorizationDatabaseOwner()) && (requiredPermissionsList = activation.getPreparedStatement().getRequiredPermissionsList()) != null && !requiredPermissionsList.isEmpty()) {
            for (StatementPermission statPerm : requiredPermissionsList) {
                StatementColumnPermission statementColumnPermission;
                if (statPerm instanceof StatementSchemaPermission) continue;
                PermissionsDescriptor permDesc = statPerm.getPermissionDescriptor(lcc.getAuthorizationId(), dd);
                if (permDesc == null) {
                    permDesc = statPerm.getPermissionDescriptor("PUBLIC", dd);
                    if (permDesc.checkOwner(lcc.getAuthorizationId())) continue;
                    dm.addDependency(dependent, permDesc, lcc.getContextManager());
                    continue;
                }
                if (permDesc.checkOwner(lcc.getAuthorizationId())) continue;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
                if (!(permDesc instanceof ColPermsDescriptor) || (permDesc = (statementColumnPermission = (StatementColumnPermission)statPerm).getPUBLIClevelColPermsDescriptor(lcc.getAuthorizationId(), dd)) == null) continue;
                dm.addDependency(dependent, permDesc, lcc.getContextManager());
            }
        }
    }

    void updateIndex(SchemaDescriptor sd, TableDescriptor td, Activation activation, String oldName, String newName, long newConglomId) throws StandardException {
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        dm.invalidateFor(td, 41, lcc);
        ConglomerateDescriptor conglomerateDescriptor = dd.getConglomerateDescriptor(oldName, sd, true);
        if (conglomerateDescriptor == null) {
            throw StandardException.newException("X0X99.S", oldName);
        }
        dd.dropConglomerateDescriptor(conglomerateDescriptor, tc);
        conglomerateDescriptor.setConglomerateName(newName);
        if (newConglomId >= 0L) {
            conglomerateDescriptor.setConglomerateNumber(newConglomId);
        }
        dd.addDescriptor(conglomerateDescriptor, sd, 0, false, tc);
    }

    public boolean isReplayable() {
        return true;
    }

    public abstract String getSchemaName();

    public String getTableName() {
        return null;
    }

    public boolean isDropStatement() {
        return false;
    }

    public boolean isDropIfExists() {
        return false;
    }

    public String getObjectName() {
        return null;
    }

    @Override
    public boolean isCancellable() {
        return true;
    }

    public CreateSchemaConstantAction getImplicitSchemaCreated() {
        return this.implicitSchema;
    }
}

