/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.cache.wan.GatewaySenderFactory;
import com.gemstone.gemfire.distributed.DistributedMember;
import com.gemstone.gemfire.distributed.internal.membership.InternalDistributedMember;
import com.gemstone.gemfire.internal.cache.GemFireCacheImpl;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.ddl.ServerGroupsTableAttribute;
import com.pivotal.gemfirexd.internal.engine.ddl.wan.WanProcedures;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.engine.store.ServerGroupUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GfxdGatewaySenderDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLConstantAction;
import com.pivotal.gemfirexd.internal.shared.common.SharedUtils;
import com.pivotal.gemfirexd.internal.shared.common.sanity.SanityManager;
import java.util.Set;

public class CreateGatewaySenderConstantAction
extends DDLConstantAction {
    private final String senderId;
    private final ServerGroupsTableAttribute serverGroups;
    private final int socketBufferSize;
    private final boolean manualStart;
    private final int socketReadTimeout;
    private final boolean enableBatchConflation;
    private final boolean enablePersistence;
    private final boolean diskSynchronous;
    private final int batchSize;
    private final int batchTimeInterval;
    private String diskStoreName;
    private final int maximumQueueMemory;
    private final int alertThreshold;
    private final int remoteDsId;
    private final boolean isParallel;
    private final boolean enableBULKDMLStr;
    public static final String REGION_PREFIX_FOR_CONFLATION = "__GFXD_INTERNAL_GATEWAYSENDER_";

    CreateGatewaySenderConstantAction(String senderId, ServerGroupsTableAttribute serverGroups, int socketBufferSize, boolean manualStart, int socketReadTimeout, boolean enableBatchConflation, int batchSize, int batchTimeInterval, boolean enablePersistence, boolean diskSync, String diskStoreName, int maximumQueueMemory, int alertThreshold, int remoteDsId, boolean isParallel) {
        this.senderId = senderId;
        this.serverGroups = serverGroups;
        this.socketBufferSize = socketBufferSize;
        this.manualStart = manualStart;
        this.socketReadTimeout = socketReadTimeout;
        this.enableBatchConflation = enableBatchConflation;
        this.batchSize = batchSize;
        this.batchTimeInterval = batchTimeInterval;
        this.enablePersistence = enablePersistence;
        this.diskSynchronous = diskSync;
        this.diskStoreName = diskStoreName;
        this.maximumQueueMemory = maximumQueueMemory;
        this.alertThreshold = alertThreshold;
        this.remoteDsId = remoteDsId;
        this.isParallel = isParallel;
        this.enableBULKDMLStr = false;
    }

    @Override
    public final String getSchemaName() {
        return "SYS";
    }

    @Override
    public final String getTableName() {
        return REGION_PREFIX_FOR_CONFLATION + this.senderId;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        if (!this.isParallel && !ServerGroupUtils.isDataStore()) {
            SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("Skipping create gateway sender for " + this.senderId + " on JVM of kind " + GemFireXDUtils.getMyVMKind()));
            return;
        }
        Set<DistributedMember> members = this.serverGroups != null ? GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(this.serverGroups.getServerGroupSet()) : GemFireXDUtils.getGfxdAdvisor().adviseOperationNodes(null);
        InternalDistributedMember myId = Misc.getGemFireCache().getMyId();
        boolean self = members.remove(myId);
        GemFireCacheImpl cache = Misc.getGemFireCache();
        if (cache.getGatewaySender(this.senderId) != null) {
            throw StandardException.newException("X0Y68.S", (Object)"GATEWAYSENDER", (Object)this.senderId);
        }
        if (self) {
            GatewaySenderFactory factory = cache.createGatewaySenderFactory();
            factory.setSocketBufferSize(this.socketBufferSize);
            factory.setManualStart(this.manualStart);
            factory.setSocketReadTimeout(this.socketReadTimeout);
            factory.setBatchConflationEnabled(this.enableBatchConflation);
            factory.setBatchSize(this.batchSize);
            factory.setBatchTimeInterval(this.batchTimeInterval);
            factory.setPersistenceEnabled(this.enablePersistence);
            factory.setDiskSynchronous(this.diskSynchronous);
            factory.setParallel(this.isParallel);
            if (this.diskStoreName != null) {
                this.diskStoreName = this.diskStoreName.toUpperCase();
                if (GemFireCacheImpl.getInstance().findDiskStore(this.diskStoreName) == null) {
                    throw StandardException.newException("X0Z07.S", this.diskStoreName);
                }
                factory.setDiskStoreName(this.diskStoreName);
            } else {
                factory.setDiskStoreName("GFXD-DEFAULT-DISKSTORE");
            }
            factory.setMaximumQueueMemory(this.maximumQueueMemory);
            factory.setAlertThreshold(this.alertThreshold);
            if (this.isParallel) {
                factory.addGatewayEventFilter(WanProcedures.getParallelWanFilter());
            } else {
                factory.addGatewayEventFilter(WanProcedures.getSerialWanFilter(this.enableBULKDMLStr));
            }
            factory.create(this.senderId, this.remoteDsId);
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        TransactionController tc = lcc.getTransactionExecute();
        dd.startWriting(lcc);
        UUID id = dd.getUUIDFactory().recreateUUID(this.senderId);
        String servers = SharedUtils.toCSV(this.serverGroups.getServerGroupSet());
        GfxdGatewaySenderDescriptor ghd = new GfxdGatewaySenderDescriptor(dd, id, this.senderId, this.remoteDsId, servers, this.socketBufferSize, this.manualStart, this.socketReadTimeout, this.enableBatchConflation, this.batchSize, this.batchTimeInterval, this.enablePersistence, this.diskSynchronous, this.diskStoreName, this.maximumQueueMemory, this.alertThreshold, !this.manualStart);
        dd.addDescriptor(ghd, null, 21, false, tc);
        SanityManager.DEBUG_PRINT((String)"TraceConglom", (String)("CreateGatewaySenderNode:: inserted GatewaySender configuration for " + this.senderId + " in SYS table"));
    }

    public String toString() {
        return "CREATE GATEWAYSENDER " + this.senderId;
    }
}

