/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.catalog.types.ReferencedColumnsDescriptorImpl;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.loader.ClassFactory;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.services.uuid.UUIDFactory;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.DependencyManager;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.Provider;
import com.pivotal.gemfirexd.internal.iapi.sql.depend.ProviderInfo;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ColumnDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DDUtils;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDescriptorGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.IndexRowGenerator;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.SchemaDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ConstraintInfo;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateIndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.CreateTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;
import java.util.Collection;

public class CreateConstraintConstantAction
extends ConstraintConstantAction {
    private final boolean forCreateTable;
    private String[] columnNames;
    private String constraintText;
    private ConstraintInfo otherConstraintInfo;
    private ClassFactory cf;
    private boolean enabled;
    private ProviderInfo[] providerInfo;
    private boolean skipPopulatingIndexes = false;

    CreateConstraintConstantAction(String constraintName, int constraintType, boolean forCreateTable, String tableName, UUID tableId, String schemaName, String[] columnNames, IndexConstantAction indexAction, String constraintText, boolean enabled, ConstraintInfo otherConstraint, ProviderInfo[] providerInfo) {
        super(constraintName, constraintType, tableName, tableId, schemaName, indexAction);
        this.forCreateTable = forCreateTable;
        this.columnNames = columnNames;
        this.constraintText = constraintText;
        this.enabled = enabled;
        this.otherConstraintInfo = otherConstraint;
        this.providerInfo = providerInfo;
    }

    @Override
    public void executeConstantAction(Activation activation) throws StandardException {
        ConglomerateDescriptor conglomDesc = null;
        ConglomerateDescriptor[] conglomDescs = null;
        ConstraintDescriptor conDesc = null;
        TableDescriptor td = null;
        UUID indexId = null;
        if (this.constraintType == 1) {
            return;
        }
        LanguageConnectionContext lcc = activation.getLanguageConnectionContext();
        DataDictionary dd = lcc.getDataDictionary();
        DependencyManager dm = dd.getDependencyManager();
        TransactionController tc = lcc.getTransactionExecute();
        this.cf = lcc.getLanguageConnectionFactory().getClassFactory();
        dd.startWriting(lcc);
        SchemaDescriptor sd = dd.getSchemaDescriptor(this.schemaName, tc, true);
        td = activation.getDDLTableDescriptor();
        if (td == null) {
            td = this.tableId != null ? dd.getTableDescriptor(this.tableId) : dd.getTableDescriptor(this.tableName, sd, tc);
            if (td == null) {
                throw StandardException.newException("X0X05.S", this.tableName);
            }
            activation.setDDLTableDescriptor(td);
        }
        UUIDFactory uuidFactory = dd.getUUIDFactory();
        if (this.indexAction != null) {
            String backingIndexName;
            if (this.indexAction.getIndexName() == null) {
                backingIndexName = uuidFactory.createUUID().toString();
                this.indexAction.setIndexName(backingIndexName);
            } else {
                backingIndexName = this.indexAction.getIndexName();
            }
            if (this.indexAction instanceof CreateIndexConstantAction) {
                CreateIndexConstantAction createIndexAction = (CreateIndexConstantAction)this.indexAction;
                if (this.skipPopulatingIndexes) {
                    createIndexAction.skipLoadConglomerate();
                }
                createIndexAction.setThroughConstraint();
            }
            this.indexAction.executeConstantAction(activation);
            conglomDescs = td.getConglomerateDescriptors();
            for (int index = 0; !(index >= conglomDescs.length || (conglomDesc = conglomDescs[index]).isIndex() && backingIndexName.equals(conglomDesc.getConglomerateName())); ++index) {
            }
            SanityManager.ASSERT((conglomDesc != null ? 1 : 0) != 0, (String)"conglomDesc is expected to be non-null after search for backing index");
            SanityManager.ASSERT((boolean)conglomDesc.isIndex(), (String)"conglomDesc is expected to be indexable after search for backing index");
            SanityManager.ASSERT((boolean)conglomDesc.getConglomerateName().equals(backingIndexName), (String)"conglomDesc name expected to be the same as backing index name after search for backing index");
            indexId = conglomDesc.getUUID();
        }
        UUID constraintId = uuidFactory.createUUID();
        DataDescriptorGenerator ddg = dd.getDataDescriptorGenerator();
        switch (this.constraintType) {
            case 2: {
                conDesc = ddg.newPrimaryKeyConstraintDescriptor(td, this.constraintName, false, false, this.genColumnPositions(td, false), constraintId, indexId, sd, this.enabled, 0);
                dd.addConstraintDescriptor(conDesc, tc);
                break;
            }
            case 3: {
                conDesc = ddg.newUniqueConstraintDescriptor(td, this.constraintName, false, false, this.genColumnPositions(td, false), constraintId, indexId, sd, this.enabled, 0);
                dd.addConstraintDescriptor(conDesc, tc);
                break;
            }
            case 4: {
                conDesc = ddg.newCheckConstraintDescriptor(td, this.constraintName, false, false, constraintId, this.constraintText, new ReferencedColumnsDescriptorImpl(this.genColumnPositions(td, false)), sd, this.enabled);
                dd.addConstraintDescriptor(conDesc, tc);
                break;
            }
            case 6: {
                ReferencedKeyConstraintDescriptor referencedConstraint = DDUtils.locateReferencedConstraint(dd, td, this.constraintName, this.columnNames, this.otherConstraintInfo);
                DDUtils.validateReferentialActions(dd, td, this.constraintName, this.otherConstraintInfo, this.columnNames);
                boolean isFKOnRR_PRRefIndexLocal = false;
                int[] partitioningColsIndexInRefKey = null;
                PartitionedRegion refTablePR = null;
                if (!this.forCreateTable) {
                    TableDescriptor refTableDesc = this.otherConstraintInfo.getReferencedTableDescriptor(dd);
                    IndexRowGenerator refIndexDescriptor = referencedConstraint.getIndexConglomerateDescriptor(dd).getIndexDescriptor();
                    DDUtils.validateRefConstraintCheckability(refTableDesc, refIndexDescriptor, td, lcc, this.columnNames);
                    boolean bl = isFKOnRR_PRRefIndexLocal = refTableDesc.getDistributionDescriptor().isPartitioned() && td.getDistributionDescriptor().getPolicy() == 1 && refIndexDescriptor.indexType().equals("LOCALSORTEDMAP");
                    if (isFKOnRR_PRRefIndexLocal) {
                        String prRefPath = Misc.getRegionPath(refTableDesc.getSchemaName(), refTableDesc.getName(), lcc);
                        refTablePR = (PartitionedRegion)Misc.getRegionByPath(prRefPath, true);
                        partitioningColsIndexInRefKey = this.getPartitioningColsInRefKey(refTableDesc, refIndexDescriptor);
                    }
                }
                conDesc = ddg.newForeignKeyConstraintDescriptor(td, this.constraintName, false, false, this.genColumnPositions(td, false), constraintId, indexId, sd, referencedConstraint, this.enabled, this.otherConstraintInfo.getReferentialActionDeleteRule(), this.otherConstraintInfo.getReferentialActionUpdateRule());
                dd.addConstraintDescriptor(conDesc, tc);
                if (!this.forCreateTable && !Misc.initialDDLReplayInProgress() && dd.activeConstraint(conDesc)) {
                    CreateConstraintConstantAction.validateFKConstraint(tc, dd, (ForeignKeyConstraintDescriptor)conDesc, referencedConstraint, ((CreateIndexConstantAction)this.indexAction).getIndexTemplateRow(), partitioningColsIndexInRefKey, refTablePR);
                }
                dm.addDependency(conDesc, referencedConstraint, lcc.getContextManager());
                this.storeConstraintDependenciesOnPrivileges(activation, conDesc, referencedConstraint.getTableId());
                break;
            }
            default: {
                SanityManager.THROWASSERT((String)("contraintType (" + this.constraintType + ") has unexpected value"));
            }
        }
        if (this.providerInfo != null) {
            for (int ix = 0; ix < this.providerInfo.length; ++ix) {
                Provider provider = null;
                provider = (Provider)this.providerInfo[ix].getDependableFinder().getDependable(dd, this.providerInfo[ix].getObjectId());
                dm.addDependency(conDesc, provider, lcc.getContextManager());
            }
        }
        if (!this.forCreateTable) {
            dm.invalidateFor(td, 22, lcc);
        }
        if (this.constraintType == 6) {
            SanityManager.ASSERT((conDesc != null ? 1 : 0) != 0, (String)"conDesc expected to be non-null");
            if (!(conDesc instanceof ForeignKeyConstraintDescriptor)) {
                SanityManager.THROWASSERT((String)("conDesc expected to be instance of ForeignKeyConstraintDescriptor, not " + conDesc.getClass().getName()));
            }
            dm.invalidateFor(((ForeignKeyConstraintDescriptor)conDesc).getReferencedConstraint().getTableDescriptor(), 22, lcc);
        }
    }

    private int[] getPartitioningColsInRefKey(TableDescriptor refTableDesc, IndexRowGenerator refIndexDescriptor) throws StandardException {
        int[] partColsPos = refTableDesc.getDistributionDescriptor().getColumnPositionsSorted();
        int[] partitioningColsIndexInRefKey = new int[partColsPos.length];
        int[] refColsPos = refIndexDescriptor.baseColumnPositions();
        int k = 0;
        block0: for (int i = 0; i < refColsPos.length; ++i) {
            int refColPos = refColsPos[i];
            for (int partColPos : partColsPos) {
                if (refColPos != partColPos) continue;
                partitioningColsIndexInRefKey[k++] = i;
                continue block0;
            }
        }
        return partitioningColsIndexInRefKey;
    }

    boolean isForeignKeyConstraint() {
        return this.constraintType == 6;
    }

    private int[] genColumnPositions(TableDescriptor td, boolean columnsMustBeOrderable) throws StandardException {
        int[] baseColumnPositions = new int[this.columnNames.length];
        for (int i = 0; i < this.columnNames.length; ++i) {
            ColumnDescriptor columnDescriptor = td.getColumnDescriptor(this.columnNames[i]);
            if (columnDescriptor == null) {
                throw StandardException.newException("42X14", (Object)this.columnNames[i], (Object)this.tableName);
            }
            if (columnsMustBeOrderable && !columnDescriptor.getType().getTypeId().orderable(this.cf)) {
                throw StandardException.newException("X0X67.S", columnDescriptor.getType().getTypeId().getSQLTypeName());
            }
            baseColumnPositions[i] = columnDescriptor.getPosition();
        }
        if (this.constraintType == 2) {
            GemFireXDUtils.sortColumns(baseColumnPositions, this.columnNames);
        }
        return baseColumnPositions;
    }

    String getConstraintText() {
        return this.constraintText;
    }

    public String toString() {
        StringBuilder strbuf = new StringBuilder();
        strbuf.append("CREATE CONSTRAINT " + this.constraintName);
        strbuf.append("\n=========================\n");
        if (this.columnNames == null) {
            strbuf.append("columnNames == null\n");
        } else {
            for (int ix = 0; ix < this.columnNames.length; ++ix) {
                strbuf.append("\n\tcol[" + ix + "]" + this.columnNames[ix].toString());
            }
        }
        strbuf.append("\n");
        strbuf.append(this.constraintText);
        strbuf.append("\n");
        if (this.otherConstraintInfo != null) {
            strbuf.append(this.otherConstraintInfo.toString());
        }
        strbuf.append("\n");
        return strbuf.toString();
    }

    @Override
    public String getSchemaName() {
        return null;
    }

    public final void setSkipPopulatingIndexes(boolean flag) {
        this.skipPopulatingIndexes = flag;
    }

    public final Collection<CreateTableConstantAction.LoadIndexData> getLoadIndexData() {
        if (this.indexAction instanceof CreateIndexConstantAction) {
            return ((CreateIndexConstantAction)this.indexAction).getLoadIndexData();
        }
        return null;
    }
}

