/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.BucketAdvisor;
import com.gemstone.gemfire.internal.cache.ColocationHelper;
import com.gemstone.gemfire.internal.cache.PartitionedRegion;
import com.gemstone.gemfire.internal.cache.partitioned.RegionAdvisor;
import com.pivotal.gemfirexd.internal.catalog.UUID;
import com.pivotal.gemfirexd.internal.engine.Misc;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.PreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.ResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ForeignKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ReferencedKeyConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.GenericScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.GroupFetchScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.impl.sql.execute.DDLSingleTableConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.IndexConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.execute.RIBulkChecker;
import com.pivotal.gemfirexd.internal.impl.sql.execute.ValueRow;
import java.util.Iterator;
import java.util.Set;

public abstract class ConstraintConstantAction
extends DDLSingleTableConstantAction {
    protected String constraintName;
    protected int constraintType;
    protected String tableName;
    protected String schemaName;
    protected UUID schemaId;
    protected IndexConstantAction indexAction;

    ConstraintConstantAction(String constraintName, int constraintType, String tableName, UUID tableId, String schemaName, IndexConstantAction indexAction) {
        super(tableId);
        this.constraintName = constraintName;
        this.constraintType = constraintType;
        this.tableName = tableName;
        this.indexAction = indexAction;
        this.schemaName = schemaName;
        SanityManager.ASSERT((schemaName != null ? 1 : 0) != 0, (String)"Constraint schema name is null");
    }

    public int getConstraintType() {
        return this.constraintType;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public IndexConstantAction getIndexAction() {
        return this.indexAction;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void validateFKConstraint(TransactionController tc, DataDictionary dd, ForeignKeyConstraintDescriptor fk, ReferencedKeyConstraintDescriptor refcd, ExecRow indexTemplateRow, int[] partitionColIndexInRefKeyForSelectiveCheck, PartitionedRegion refTablePR) throws StandardException {
        GenericScanController refScan = null;
        GroupFetchScanController fkScan = tc.openGroupFetchScan(fk.getIndexConglomerateDescriptor(dd).getConglomerateNumber(), false, 0, 7, 2, null, null, 1, null, null, -1);
        try {
            int numFailures;
            RIBulkChecker riChecker;
            ValueRow firstKeyToFail;
            block14: {
                if (!fkScan.next()) {
                    fkScan.close();
                    return;
                }
                fkScan.reopenScan(null, 1, null, null, -1, null);
                refScan = tc.openGroupFetchScan(refcd.getIndexConglomerateDescriptor(dd).getConglomerateNumber(), false, 0x400000, 6, 2, null, null, 1, null, null, -1);
                firstKeyToFail = new ValueRow(indexTemplateRow.nColumns());
                riChecker = new RIBulkChecker((GroupFetchScanController)refScan, fkScan, indexTemplateRow, true, null, firstKeyToFail, partitionColIndexInRefKeyForSelectiveCheck, refTablePR);
                if (partitionColIndexInRefKeyForSelectiveCheck != null && !tc.skipLocks()) {
                    PartitionedRegion.RecoveryLock recoveryLock = ColocationHelper.getLeaderRegion((PartitionedRegion)refTablePR).getRecoveryLock();
                    recoveryLock.lock();
                    int bucketIDWithNoPrimary = 0;
                    try {
                        bucketIDWithNoPrimary = ConstraintConstantAction.checkIfAllHostedBucketsHavePrimary(refTablePR);
                        if (bucketIDWithNoPrimary == -1) {
                            ((GemFireTransaction)tc).setRegionRecoveryLock(recoveryLock);
                            break block14;
                        }
                        throw StandardException.newException("X0Z20.S", (Object)bucketIDWithNoPrimary, (Object)Misc.getFullTableNameFromRegionPath(refTablePR.getFullPath()));
                    }
                    finally {
                        if (bucketIDWithNoPrimary != -1) {
                            recoveryLock.unlock();
                        }
                    }
                }
            }
            if ((numFailures = riChecker.doCheck()) > 0) {
                StandardException se = StandardException.newException("X0Y45.S", (Object)fk.getConstraintName(), (Object)fk.getTableDescriptor().getName(), (Object)("key1=" + firstKeyToFail.toString()));
                throw se;
            }
        }
        finally {
            if (fkScan != null) {
                fkScan.close();
                fkScan = null;
            }
            if (refScan != null) {
                refScan.close();
                refScan = null;
            }
        }
    }

    private static int checkIfAllHostedBucketsHavePrimary(PartitionedRegion refTablePR) {
        RegionAdvisor ra = refTablePR.getRegionAdvisor();
        Set allHostedBuckets = ra.getBucketSet();
        Iterator iterator = allHostedBuckets.iterator();
        while (iterator.hasNext()) {
            int bucketID = (Integer)iterator.next();
            BucketAdvisor ba = ra.getBucketAdvisor(bucketID);
            if (ba.hasPrimary()) continue;
            return bucketID;
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean validateConstraint(String constraintName, String constraintText, TableDescriptor td, LanguageConnectionContext lcc, boolean isCheckConstraint) throws StandardException {
        StringBuilder checkStmt = new StringBuilder();
        checkStmt.append("SELECT COUNT(*) FROM ");
        checkStmt.append(td.getQualifiedName());
        checkStmt.append(" WHERE NOT(");
        checkStmt.append(constraintText);
        checkStmt.append(")");
        ResultSet rs = null;
        try {
            Number value;
            short execFlags = 0;
            execFlags = GemFireXDUtils.set(execFlags, (short)2);
            PreparedStatement ps = lcc.prepareInternalStatement(checkStmt.toString(), execFlags);
            rs = ps.execute(lcc, false, 0L);
            ExecRow row = rs.getNextRow();
            if (row == null) {
                SanityManager.THROWASSERT((String)("did not get any rows back from query: " + checkStmt.toString()));
            }
            if ((value = (Number)((NumberDataValue)row.getRowArray()[0]).getObject()) != null && value.longValue() != 0L) {
                if (isCheckConstraint) {
                    throw StandardException.newException("X0Y59.S", (Object)constraintName, (Object)td.getQualifiedName(), (Object)value.toString());
                }
                boolean bl = false;
                return bl;
            }
        }
        finally {
            if (rs != null) {
                rs.close(false);
            }
        }
        return true;
    }

    String getFullConstraintName() {
        return this.schemaName + '.' + this.constraintName;
    }
}

