/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowLocationRetRowSource;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;

public class CardinalityCounter
implements RowLocationRetRowSource {
    private RowLocationRetRowSource rowSource;
    private ExecRow prevKey;
    private long[] cardinality;
    private long numRows;

    public CardinalityCounter(RowLocationRetRowSource rowSource) {
        this.rowSource = rowSource;
    }

    @Override
    public boolean needsRowLocation() {
        return this.rowSource.needsRowLocation();
    }

    @Override
    public void rowLocation(RowLocation rl) throws StandardException {
        this.rowSource.rowLocation(rl);
    }

    @Override
    public ExecRow getNextRowFromRowSource() throws StandardException {
        ExecRow nextRow = this.rowSource.getNextRowFromRowSource();
        if (nextRow != null) {
            this.keepCount(nextRow);
        }
        return nextRow;
    }

    @Override
    public boolean needsToClone() {
        return this.rowSource.needsToClone();
    }

    @Override
    public FormatableBitSet getValidColumns() {
        return this.rowSource.getValidColumns();
    }

    @Override
    public void closeRowSource() {
        this.rowSource.closeRowSource();
    }

    public void keepCount(ExecRow currentKey) throws StandardException {
        long offsetWidth;
        int numKeys = currentKey.nColumns() - 1;
        ++this.numRows;
        if (this.prevKey == null) {
            this.prevKey = currentKey.getClone();
            this.cardinality = new long[numKeys];
            for (int i = 0; i < numKeys; ++i) {
                this.cardinality[i] = 1L;
            }
            return;
        }
        for (int i = 1; i <= numKeys && (offsetWidth = this.prevKey.isNull(i)) != -7L; ++i) {
            if (this.prevKey.compare(currentKey, i, offsetWidth, false) == 0) continue;
            this.prevKey = null;
            this.prevKey = currentKey.getClone();
            break;
        }
        for (int j = i; j <= numKeys; ++j) {
            int n = j - 1;
            this.cardinality[n] = this.cardinality[n] + 1L;
        }
    }

    public long[] getCardinality() {
        return this.cardinality;
    }

    public long getRowCount() {
        return this.numRows;
    }
}

