/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.gemstone.gemfire.internal.cache.TXState;
import com.gemstone.gemfire.internal.offheap.SimpleMemoryAllocatorImpl;
import com.pivotal.gemfirexd.internal.engine.access.GemFireTransaction;
import com.pivotal.gemfirexd.internal.engine.access.MemConglomerate;
import com.pivotal.gemfirexd.internal.engine.access.heap.MemHeapScanController;
import com.pivotal.gemfirexd.internal.engine.access.index.SortedMap2IndexScanController;
import com.pivotal.gemfirexd.internal.engine.store.GemFireContainer;
import com.pivotal.gemfirexd.internal.engine.store.RowFormatter;
import com.pivotal.gemfirexd.internal.engine.store.offheap.OHAddressCache;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.loader.GeneratedMethod;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.Activation;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.GroupFetchScanController;
import com.pivotal.gemfirexd.internal.iapi.store.access.Qualifier;
import com.pivotal.gemfirexd.internal.iapi.store.access.RowUtil;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.RowLocation;
import com.pivotal.gemfirexd.internal.impl.sql.StatementStats;
import com.pivotal.gemfirexd.internal.impl.sql.execute.TableScanResultSet;
import com.pivotal.gemfirexd.internal.impl.sql.execute.xplain.XPLAINUtil;

final class BulkTableScanResultSet
extends TableScanResultSet
implements CursorResultSet {
    private ExecRow[] rowArray;
    private MemHeapScanController mhsc;
    private GemFireContainer gfc;
    private final RowLocation[] rowLocationArray;
    private SortedMap2IndexScanController smScanController;
    private Object[] indexKeys;
    private int[] nodeVersions;
    private int[] scanKeyGroupID;
    private RowFormatter rfForAccessedCols;
    private final StatementStats stats;
    private int curRowPosition;
    private int numRowsInArray;
    private static int OUT_OF_ROWS = 0;

    @Override
    protected void initLocalTXState(TXState localTXState, boolean forUpdate) {
        super.initLocalTXState(localTXState, forUpdate);
    }

    BulkTableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, int colRefItem, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, StatementStats stats, boolean delayScanOpening, boolean optimizeforOffHeap, boolean indexAccesesBaseTable, boolean supportsMoveToNextKey, String nonQualPreds) throws StandardException {
        this(conglomId, scoci, activation, (ExecRow)resultRowAllocator.invoke(activation), resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, colRefItem != -1 ? (FormatableBitSet)activation.getSavedObject(colRefItem) : null, indexColItem, lockMode, tableLocked, isolationLevel, rowsPerRead, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost, stats, delayScanOpening, optimizeforOffHeap, indexAccesesBaseTable, supportsMoveToNextKey, nonQualPreds);
    }

    BulkTableScanResultSet(long conglomId, StaticCompiledOpenConglomInfo scoci, Activation activation, ExecRow candidate, GeneratedMethod resultRowAllocator, int resultSetNumber, GeneratedMethod startKeyGetter, int startSearchOperator, GeneratedMethod stopKeyGetter, int stopSearchOperator, boolean sameStartStopPosition, Qualifier[][] qualifiers, String tableName, String userSuppliedOptimizerOverrides, String indexName, boolean isConstraint, boolean forUpdate, FormatableBitSet accessedCols, int indexColItem, int lockMode, boolean tableLocked, int isolationLevel, int rowsPerRead, boolean oneRowScan, double optimizerEstimatedRowCount, double optimizerEstimatedCost, StatementStats stats, boolean delayScanOpening, boolean optimizeForOffHeap, boolean indexAccessesBaseTable, boolean supportsMoveToNextKey, String nonQualPreds) throws StandardException {
        super(conglomId, scoci, activation, candidate, resultRowAllocator, resultSetNumber, startKeyGetter, startSearchOperator, stopKeyGetter, stopSearchOperator, sameStartStopPosition, qualifiers, tableName, userSuppliedOptimizerOverrides, indexName, isConstraint, forUpdate, accessedCols, indexColItem, lockMode, tableLocked, isolationLevel, rowsPerRead, oneRowScan, optimizerEstimatedRowCount, optimizerEstimatedCost, delayScanOpening, optimizeForOffHeap, indexAccessesBaseTable, supportsMoveToNextKey, nonQualPreds);
        if (rowsPerRead == 1) {
            SanityManager.THROWASSERT((String)"rowsPerRead not expected to be 1");
        }
        if (oneRowScan) {
            SanityManager.THROWASSERT((String)("oneRowScan expected to be false - rowsPerRead = " + rowsPerRead));
        }
        this.stats = stats;
        this.rowLocationArray = new RowLocation[this.rowsPerRead];
    }

    @Override
    protected void openScanController(TransactionController tc) throws StandardException {
        DataValueDescriptor[] stopPositionRow;
        DataValueDescriptor[] startPositionRow = this.startPosition == null ? null : this.startPosition.getRowArray();
        DataValueDescriptor[] dataValueDescriptorArray = stopPositionRow = this.stopPosition == null ? null : this.stopPosition.getRowArray();
        if (this.qualifiers != null) {
            this.clearOrderableCache(this.qualifiers);
        }
        if (tc == null) {
            tc = this.activation.getTransactionController();
        }
        this.scanController = tc.openCompiledScan(this.activation.getResultSetHoldability(), this.forUpdate() ? 4 : 0, this.lockMode, this.isolationLevel, this.accessedCols, startPositionRow, this.startSearchOperator, this.qualifiers, stopPositionRow, this.stopSearchOperator, this.scoci, this.dcoci, this.activation);
        this.setScanControllerOpened(true);
        this.rowsThisScan = 0L;
        this.activation.informOfRowCount(this, this.scanController.getEstimatedRowCount());
        if (this.scanController instanceof SortedMap2IndexScanController) {
            this.smScanController = (SortedMap2IndexScanController)this.scanController;
            this.indexKeys = new Object[this.rowsPerRead];
            this.nodeVersions = new int[this.rowsPerRead];
        } else if (this.scanController instanceof MemHeapScanController && ((MemHeapScanController)this.scanController).getGemFireContainer().isOffHeap()) {
            ((MemHeapScanController)this.scanController).setOffHeapOwner(this);
        }
    }

    @Override
    public void openCore() throws StandardException {
        long lbeginTime;
        super.openCore();
        long l = lbeginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (this.scanController instanceof MemHeapScanController) {
            this.mhsc = (MemHeapScanController)this.scanController;
        }
        this.rowArray = new ExecRow[this.rowsPerRead];
        if (this.mhsc != null) {
            GemFireContainer gfc;
            this.gfc = gfc = this.mhsc.getGemFireContainer();
            if (gfc.isByteArrayStore()) {
                DataValueDescriptor[] candidateRowArray = this.candidate.getRowArray();
                RowFormatter rf = gfc.getRowFormatter(candidateRowArray.length);
                this.candidate = gfc.newCompactExecRow(candidateRowArray, rf);
            }
        }
        this.rowArray[0] = this.candidate.getClone();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
        if (this.statisticsTimingOn) {
            this.openTime += this.getElapsedNanos(lbeginTime);
        }
    }

    @Override
    public void reopenCore() throws StandardException {
        super.reopenCore();
        this.numRowsInArray = 0;
        this.curRowPosition = -1;
    }

    @Override
    public final ExecRow getNextRowCore() throws StandardException {
        RowLocation rl;
        long lbeginTime;
        long l = lbeginTime = this.statisticsTimingOn ? XPLAINUtil.nanoTime() : 0L;
        if (!this.isOpen && this.delayScanOpening()) {
            if (this.numOpens == 0) {
                this.basicOpenCore();
            } else {
                this.basicReopenCore();
            }
        }
        ExecRow result = null;
        if (this.observer != null) {
            this.observer.onGetNextRowCoreOfBulkTableScan(this);
        }
        this.checkCancellationFlag();
        TXState localTXState = this.localTXState;
        if (this.isOpen && (this.varflags & 1) != 0) {
            if (this.currentRow == null) {
                boolean useBytes = false;
                if (this.mhsc != null && (useBytes = this.gfc.isByteArrayStore()) && this.rfForAccessedCols == null) {
                    this.rfForAccessedCols = this.gfc.getRowFormatter(this.accessedCols);
                    if (this.accessedCols == null) {
                        this.baseColumnMap = null;
                    }
                }
                this.currentRow = this.getCompactRow(this.candidate, this.accessedCols, this.isKeyed(), useBytes, this.gfc, this.rfForAccessedCols, false);
            }
            block0: while (true) {
                if (this.curRowPosition >= this.numRowsInArray - 1 && this.reloadArray() == OUT_OF_ROWS) {
                    this.clearCurrentRow();
                    this.setRowCountIfPossible(this.rowsThisScan);
                    if (this.statisticsTimingOn) {
                        this.nextTime += this.getElapsedNanos(lbeginTime);
                    }
                    return null;
                }
                while (true) {
                    if (++this.curRowPosition >= this.numRowsInArray) continue block0;
                    this.candidate.setRowArray(this.rowArray[this.curRowPosition]);
                    this.currentRow = this.setCompactRow(this.candidate, this.currentRow);
                    ++this.rowsSeen;
                    ++this.rowsThisScan;
                    if (!this.skipRow(this.candidate)) break block0;
                    ++this.rowsFiltered;
                    this.filteredRowLocationPostRead(localTXState);
                }
                break;
            }
            result = this.currentRow;
        }
        this.setCurrentRow(result);
        this.setRegionAndKeyInfo(result);
        if (localTXState != null && this.isTopResultSet && this.forUpdate() && result != null && (rl = this.rowLocationArray[this.curRowPosition]) != null) {
            this.upgradeReadLockToWrite(rl, this.gfc);
        }
        if (this.statisticsTimingOn) {
            this.nextTime += this.getElapsedNanos(lbeginTime);
        }
        return result;
    }

    private int reloadArray() throws StandardException {
        this.curRowPosition = -1;
        this.numRowsInArray = ((GroupFetchScanController)((Object)this.scanController)).fetchNextGroup(this.rowArray, this.rowLocationArray, this.indexKeys, this.nodeVersions, this.scanKeyGroupID, null);
        if (this.stats != null) {
            this.stats.incNumReloadArray();
            this.stats.incNumRowsLoaded(this.numRowsInArray);
        }
        return this.numRowsInArray;
    }

    @Override
    public void close(boolean cleanupOnError) throws StandardException {
        super.close(cleanupOnError);
        this.numRowsInArray = -1;
        this.curRowPosition = -1;
        this.rowArray = null;
        if (this.scanKeyGroupID != null) {
            this.scanKeyGroupID = null;
        }
    }

    @Override
    protected boolean canGetInstantaneousLocks() {
        return !this.forUpdate();
    }

    @Override
    public boolean requiresRelocking() {
        return this.isolationLevel == 2 || this.isolationLevel == 3 || this.isolationLevel == 1;
    }

    @Override
    public RowLocation getRowLocation() throws StandardException {
        if (this.isOpen && this.scanControllerOpened()) {
            return this.rowLocationArray[this.curRowPosition];
        }
        return null;
    }

    @Override
    public final void updateRowLocationPostRead() throws StandardException {
        if (this.scanControllerOpened()) {
            this.upgradeReadLockToWrite(this.rowLocationArray[this.curRowPosition], this.gfc);
        }
    }

    @Override
    public final void filteredRowLocationPostRead(TXState localTXState) throws StandardException {
        if (localTXState != null && this.scanControllerOpened() && this.numRowsInArray != OUT_OF_ROWS) {
            this.releaseRowLocationLock(this.rowLocationArray[this.curRowPosition], this.gfc);
        }
        if (this.ohAddressCache != null) {
            this.basicReleasePreviousByteSource();
        }
    }

    private void basicReleasePreviousByteSource() {
        if (this.isHeapScan()) {
            if (this.candidate != null && this.numRowsInArray != OUT_OF_ROWS && this.curRowPosition != -1) {
                this.releaseByteSource(this.numRowsInArray - this.curRowPosition - 1);
            }
        } else {
            this.releaseByteSource(0);
        }
    }

    @Override
    public void releasePreviousByteSource() {
        if (this.ohAddressCache != null && (this.finalFlags & 0x20) != 0) {
            this.basicReleasePreviousByteSource();
        }
    }

    @Override
    public boolean supportsMoveToNextKey() {
        if (super.supportsMoveToNextKey()) {
            if (this.scanKeyGroupID == null) {
                this.scanKeyGroupID = new int[this.rowsPerRead];
            }
            return true;
        }
        return false;
    }

    @Override
    public int getScanKeyGroupID() {
        if (this.scanControllerOpened()) {
            if (this.curRowPosition >= 0) {
                return this.scanKeyGroupID[this.curRowPosition];
            }
            return -1;
        }
        throw new UnsupportedOperationException("not expected to be invoked");
    }

    @Override
    public RowLocation fetch(RowLocation loc, ExecRow destRow, FormatableBitSet validColumns, boolean faultIn, GemFireContainer container) throws StandardException {
        if (this.indexKeys != null) {
            return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, this.smScanController, this.indexKeys[this.curRowPosition], this.nodeVersions[this.curRowPosition], this);
        }
        return RowUtil.fetch(loc, destRow, validColumns, faultIn, container, null, null, 0, this);
    }

    @Override
    protected OHAddressCache createOHAddressCache() {
        if (this.isOHAddressCacheNeeded()) {
            int memConglomType = ((MemConglomerate)this.scoci).getType();
            if (memConglomType == 1 || memConglomType == 3) {
                return super.createOHAddressCache();
            }
            if (this.optimizedForOffHeap()) {
                return new BatchOHAddressCache();
            }
            return GemFireTransaction.createOHAddressCache();
        }
        return null;
    }

    protected final class BatchOHAddressCache
    implements OHAddressCache {
        private final long[] addresses;
        private int curPos = 0;

        public BatchOHAddressCache() {
            this.addresses = new long[BulkTableScanResultSet.this.rowsPerRead];
        }

        @Override
        public void put(long address) {
            if (this.addresses[this.curPos] != 0L) {
                throw new IllegalStateException("Cached address =" + this.addresses[this.curPos] + " is unreleased");
            }
            if (this.curPos >= BulkTableScanResultSet.this.rowsPerRead) {
                throw new IllegalStateException("BatchOHAdress has previous unreleased positions causing no space to accomodate address=" + address);
            }
            this.addresses[this.curPos] = address;
            ++this.curPos;
        }

        @Override
        public void releaseByteSource(int positionFromEnd) {
            int posInArray = BulkTableScanResultSet.this.numRowsInArray - positionFromEnd - 1;
            this.releaseAddressAndReset(posInArray);
            if (posInArray == BulkTableScanResultSet.this.numRowsInArray - 1) {
                this.curPos = 0;
            }
        }

        public void release() {
            for (int i = 0; i < BulkTableScanResultSet.this.rowsPerRead; ++i) {
                this.releaseAddressAndReset(i);
            }
            this.curPos = 0;
        }

        private void releaseAddressAndReset(int position) {
            long address = this.addresses[position];
            if (address != 0L) {
                SimpleMemoryAllocatorImpl.Chunk.release((long)address, (boolean)true);
                this.addresses[position] = 0L;
            }
        }
    }
}

