/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.execute;

import com.pivotal.gemfirexd.internal.engine.distributed.utils.GemFireXDUtils;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecAggregator;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.NumberDataValue;
import com.pivotal.gemfirexd.internal.iapi.types.SQLLongint;
import com.pivotal.gemfirexd.internal.impl.sql.execute.SumAggregator;
import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;

public final class AvgAggregator
extends SumAggregator {
    private long count;
    private int scale;

    @Override
    public void setup(String aggregateName, DataValueDescriptor initValue) throws StandardException {
        throw new AssertionError((Object)"Should never had been called for Avg");
    }

    public void setup(String aggregateName, DataValueDescriptor initValue, long initCount) throws StandardException {
        this.value = initValue;
        this.count = initCount;
        if (this.count == 0L) {
            switch (initValue.getTypeFormatId()) {
                case 80: 
                case 83: 
                case 84: 
                case 199: {
                    this.scale = 0;
                    break;
                }
                case 79: 
                case 81: {
                    this.scale = 127;
                    break;
                }
                default: {
                    this.scale = ((NumberDataValue)this.value).getDecimalValueScale();
                    if (this.scale >= 4) break;
                    this.scale = 4;
                }
            }
        }
    }

    @Override
    public final void clear() {
        super.clear();
        this.count = 0L;
    }

    @Override
    protected void basicAccumulate(DataValueDescriptor addend) throws StandardException {
        if (this.count == 0L) {
            switch (addend.getTypeFormatId()) {
                case 80: 
                case 83: 
                case 84: 
                case 199: {
                    this.scale = 0;
                    break;
                }
                case 79: 
                case 81: {
                    this.scale = 127;
                    break;
                }
                default: {
                    this.scale = ((NumberDataValue)addend).getDecimalValueScale();
                    if (this.scale >= 4) break;
                    this.scale = 4;
                }
            }
        }
        try {
            super.basicAccumulate(addend);
            ++this.count;
            return;
        }
        catch (StandardException se) {
            if (!se.getMessageId().equals("22003")) {
                throw se;
            }
            this.value = this.promoteType();
            this.basicAccumulate(addend);
            return;
        }
    }

    @Override
    public void merge(ExecAggregator addend) throws StandardException {
        AvgAggregator otherAvg = (AvgAggregator)addend;
        if (this.count == 0L) {
            this.count = otherAvg.count;
            if (this.value == null) {
                this.value = otherAvg.value.getClone();
            } else {
                this.value.setValue(otherAvg.value);
            }
            this.scale = otherAvg.scale;
            if (GemFireXDUtils.TraceAggreg) {
                SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)(" assigned to " + String.valueOf(this.value) + " count " + String.valueOf(this.count)));
            }
            return;
        }
        if (otherAvg.value != null) {
            this.count += otherAvg.count - 1L;
            this.basicAccumulate(otherAvg.value);
        }
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)(" merged from " + String.valueOf(otherAvg.value) + " to " + String.valueOf(this.value) + " count " + String.valueOf(this.count)));
        }
    }

    @Override
    public DataValueDescriptor getResult() throws StandardException {
        String typeName;
        if (this.count == 0L) {
            return null;
        }
        NumberDataValue sum = (NumberDataValue)this.value;
        NumberDataValue avg = (NumberDataValue)this.value.getNewNull();
        if (GemFireXDUtils.TraceAggreg) {
            SanityManager.DEBUG_PRINT((String)"TraceAggregation", (String)(" SUM " + sum + " Count " + String.valueOf(this.count)));
        }
        if (this.count > Integer.MAX_VALUE && ((typeName = sum.getTypeName()).equals("INTEGER") || typeName.equals("TINYINT") || typeName.equals("SMALLINT"))) {
            avg.setValue(0);
            return avg;
        }
        SQLLongint countv = new SQLLongint(this.count);
        sum.divide(sum, countv, avg, this.scale);
        return avg;
    }

    @Override
    public ExecAggregator newAggregator() {
        return new AvgAggregator();
    }

    @Override
    public void writeExternal(ObjectOutput out) throws IOException {
        super.writeExternal(out);
        out.writeLong(this.count);
        out.writeInt(this.scale);
    }

    @Override
    public void readExternal(ObjectInput in) throws IOException, ClassNotFoundException {
        super.readExternal(in);
        this.count = in.readLong();
        this.scale = in.readInt();
    }

    @Override
    public int getTypeFormatId() {
        return 149;
    }
}

