/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.AggregateNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.GroupByList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.HasNodeVisitor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;

public class VerifyAggregateExpressionsVisitor
extends VisitorAdaptor {
    private GroupByList groupByList;

    public VerifyAggregateExpressionsVisitor(GroupByList groupByList) {
        this.groupByList = groupByList;
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        if (node instanceof ColumnReference) {
            ColumnReference cr = (ColumnReference)node;
            if (this.groupByList == null) {
                throw StandardException.newException("42Y35", cr.getSQLColumnName());
            }
            if (this.groupByList.findGroupingColumn(cr) == null) {
                throw StandardException.newException("42Y30");
            }
        } else if (node instanceof SubqueryNode) {
            SubqueryNode subq = (SubqueryNode)node;
            if (subq.getSubqueryType() != 17 || subq.hasCorrelatedCRs()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30");
            }
            HasNodeVisitor visitor = new HasNodeVisitor(AggregateNode.class);
            subq.accept(visitor);
            if (visitor.hasNode()) {
                throw StandardException.newException(this.groupByList == null ? "42Y29" : "42Y30");
            }
        }
        return node;
    }

    @Override
    public boolean skipChildren(Visitable node) throws StandardException {
        return node instanceof AggregateNode || node instanceof SubqueryNode || node instanceof ValueNode && this.groupByList != null && this.groupByList.findGroupingColumn((ValueNode)node) != null;
    }

    @Override
    public boolean stopTraversal() {
        return false;
    }
}

