/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Visitable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.VisitorAdaptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DefaultVTIModDeferPolicy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.QueryTreeNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.vti.DeferModification;
import java.sql.SQLException;
import java.util.Enumeration;
import java.util.Hashtable;

class VTIDeferModPolicy
extends VisitorAdaptor {
    private boolean deferred = false;
    private DeferModification deferralControl;
    private int statementType;
    private int tableNumber;
    private Hashtable columns = new Hashtable();

    public static boolean deferIt(int statementType, FromVTI targetVTI, String[] updateColumnNames, QueryTreeNode source) throws StandardException {
        try {
            int resultSetType = targetVTI.getResultSetType();
            if ((statementType == 2 || statementType == 3) && resultSetType == 1003) {
                return false;
            }
            DeferModification deferralControl = targetVTI.getDeferralControl();
            if (deferralControl == null) {
                String VTIClassName = targetVTI.getMethodCall().getJavaClassName();
                deferralControl = new DefaultVTIModDeferPolicy(VTIClassName, 1005 == resultSetType);
            }
            if (deferralControl.alwaysDefer(statementType)) {
                return true;
            }
            if (source == null && statementType != 2) {
                return false;
            }
            VTIDeferModPolicy deferralSearch = new VTIDeferModPolicy(targetVTI, updateColumnNames, deferralControl, statementType);
            if (source != null) {
                source.accept(deferralSearch);
            }
            if (statementType == 2) {
                Enumeration columns = deferralSearch.columns.keys();
                while (columns.hasMoreElements()) {
                    if (!deferralControl.columnRequiresDefer(statementType, (String)columns.nextElement(), false)) continue;
                    return true;
                }
            }
            return deferralSearch.deferred;
        }
        catch (SQLException sqle) {
            throw StandardException.unexpectedUserException(sqle);
        }
    }

    private VTIDeferModPolicy(FromVTI targetVTI, String[] columnNames, DeferModification deferralControl, int statementType) {
        this.deferralControl = deferralControl;
        this.statementType = statementType;
        this.tableNumber = targetVTI.getTableNumber();
        if (statementType == 2 && columnNames != null) {
            for (int i = 0; i < columnNames.length; ++i) {
                this.columns.put(columnNames[i], columnNames[i]);
            }
        }
    }

    @Override
    public Visitable visit(Visitable node) throws StandardException {
        try {
            if (node instanceof ColumnReference && this.statementType != 1) {
                ColumnReference cr = (ColumnReference)node;
                if (cr.getTableNumber() == this.tableNumber) {
                    String columnName = cr.getColumnName();
                    if (this.statementType == 3) {
                        if (this.columns.get(columnName) == null) {
                            this.columns.put(columnName, columnName);
                            if (this.deferralControl.columnRequiresDefer(this.statementType, columnName, true)) {
                                this.deferred = true;
                            }
                        }
                    } else if (this.statementType == 2 && this.columns.get(columnName) != null) {
                        if (this.deferralControl.columnRequiresDefer(this.statementType, columnName, true)) {
                            this.deferred = true;
                        }
                        this.columns.remove(columnName);
                    }
                }
            } else if (node instanceof SelectNode) {
                SelectNode subSelect = (SelectNode)node;
                FromList fromList = subSelect.getFromList();
                for (int i = 0; i < fromList.size(); ++i) {
                    FromVTI fromVTI;
                    FromTable fromTable = (FromTable)fromList.elementAt(i);
                    if (fromTable instanceof FromBaseTable) {
                        TableDescriptor td = fromTable.getTableDescriptor();
                        if (!this.deferralControl.subselectRequiresDefer(this.statementType, td.getSchemaName(), td.getName())) continue;
                        this.deferred = true;
                        continue;
                    }
                    if (!(fromTable instanceof FromVTI) || !this.deferralControl.subselectRequiresDefer(this.statementType, (fromVTI = (FromVTI)fromTable).getMethodCall().getJavaClassName())) continue;
                    this.deferred = true;
                }
            }
        }
        catch (SQLException sqle) {
            throw StandardException.unexpectedUserException(sqle);
        }
        return node;
    }

    @Override
    public boolean stopTraversal() {
        return this.deferred;
    }

    @Override
    public boolean skipChildren(Visitable node) {
        return false;
    }
}

