/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfo;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.QueryInfoContext;
import com.pivotal.gemfirexd.internal.engine.distributed.metadata.UpdateQueryInfo;
import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.io.FormatableBitSet;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.conn.LanguageConnectionContext;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.CheckConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConglomerateDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.ConstraintDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.DataDictionary;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.GenericDescriptorList;
import com.pivotal.gemfirexd.internal.iapi.sql.dictionary.TableDescriptor;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecPreparedStatement;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ExecRow;
import com.pivotal.gemfirexd.internal.iapi.store.access.StaticCompiledOpenConglomInfo;
import com.pivotal.gemfirexd.internal.iapi.store.access.TransactionController;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ColumnReference;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentOfNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.CurrentRowLocationNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.DMLModStatementNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromBaseTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromVTI;
import com.pivotal.gemfirexd.internal.impl.sql.compile.NumericConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumn;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TableName;
import com.pivotal.gemfirexd.internal.impl.sql.compile.VTIDeferModPolicy;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import com.pivotal.gemfirexd.internal.impl.sql.execute.FKInfo;
import java.util.Vector;

public final class UpdateNode
extends DMLModStatementNode {
    public int[] changedColumnIds;
    public ExecRow emptyHeapRow;
    public boolean deferred;
    public ValueNode checkConstraints;
    public FKInfo fkInfo;
    protected FromTable targetTable;
    protected FormatableBitSet readColsBitSet;
    protected boolean positionedUpdate;
    public static final String COLUMNNAME = "###RowLocationToUpdate";

    @Override
    public void init(Object targetTableName, Object resultSet) {
        super.init(resultSet);
        this.targetTableName = (TableName)targetTableName;
    }

    @Override
    public String toString() {
        return this.targetTableName.toString() + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return "UPDATE";
    }

    @Override
    public void printSubNodes(int depth) {
        super.printSubNodes(depth);
        if (this.targetTableName != null) {
            this.printLabel(depth, "targetTableName: ");
            this.targetTableName.treePrint(depth + 1);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void bindStatement() throws StandardException {
        TableName synonymTab;
        this.getCompilerContext().pushCurrentPrivType(0);
        FromList fromList = (FromList)this.getNodeFactory().getNode(37, this.getNodeFactory().doJoinOrderOptimization(), this.getContextManager());
        ResultColumn rowLocationColumn = null;
        ValueNode rowLocationNode = null;
        TableName cursorTargetTableName = null;
        CurrentOfNode currentOfNode = null;
        ResultColumnList afterColumns = null;
        DataDictionary dataDictionary = this.getDataDictionary();
        if (this.targetTableName != null && (synonymTab = this.resolveTableToSynonym(this.targetTableName)) != null) {
            this.synonymTableName = this.targetTableName;
            this.targetTableName = synonymTab;
        }
        this.bindTables(dataDictionary);
        SanityManager.ASSERT((this.resultSet != null && this.resultSet instanceof SelectNode ? 1 : 0) != 0, (String)"Update must have a select result set");
        SelectNode sel = (SelectNode)this.resultSet;
        this.targetTable = (FromTable)sel.fromList.elementAt(0);
        if (this.targetTable instanceof CurrentOfNode) {
            this.positionedUpdate = true;
            currentOfNode = (CurrentOfNode)this.targetTable;
            cursorTargetTableName = currentOfNode.getBaseCursorTargetTableName();
            SanityManager.ASSERT((cursorTargetTableName != null ? 1 : 0) != 0);
        }
        if (this.targetTable instanceof FromVTI) {
            this.targetVTI = (FromVTI)this.targetTable;
            this.targetVTI.setTarget();
        } else if (this.targetTableName == null) {
            SanityManager.ASSERT((cursorTargetTableName != null ? 1 : 0) != 0);
            this.targetTableName = cursorTargetTableName;
        } else if (cursorTargetTableName != null && !this.targetTableName.equals(cursorTargetTableName)) {
            throw StandardException.newException("42X29", (Object)this.targetTableName, (Object)currentOfNode.getCursorName());
        }
        this.verifyTargetTable();
        SanityManager.ASSERT((fromList.size() == 0 ? 1 : 0) != 0, (String)("fromList.size() is expected to be 0, not " + fromList.size() + " on return from RS.bindExpressions()"));
        this.resultSet.getResultColumns().markUpdated();
        SanityManager.ASSERT((this.resultSet.resultColumns != null ? 1 : 0) != 0, (String)"resultColumns is expected not to be null at bind time");
        FromList resultFromList = this.resultSet.getFromList();
        SanityManager.ASSERT((resultFromList.size() == 1 ? 1 : 0) != 0, (String)"More than one table in result from list in an update.");
        if (this.synonymTableName != null) {
            this.normalizeSynonymColumns(this.resultSet.resultColumns, this.targetTable);
        }
        this.normalizeCorrelatedColumns(this.resultSet.resultColumns, this.targetTable);
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        this.resultSet.bindResultColumns(this.targetTableDescriptor, this.targetVTI, this.resultSet.resultColumns, this, fromList);
        this.getCompilerContext().popCurrentPrivType();
        LanguageConnectionContext lcc = this.getLanguageConnectionContext();
        if (!lcc.getAutoincrementUpdate()) {
            this.resultSet.getResultColumns().checkAutoincrement(null);
        }
        boolean allColumns = false;
        if (this.targetTable instanceof FromBaseTable) {
            ((FromBaseTable)this.targetTable).markUpdated(this.resultSet.getResultColumns());
        } else if (this.targetTable instanceof FromVTI) {
            this.resultColumnList = this.resultSet.getResultColumns();
        } else {
            SanityManager.ASSERT((currentOfNode != null ? 1 : 0) != 0, (String)"currentOfNode is null");
            ExecPreparedStatement cursorStmt = currentOfNode.getCursorStatement();
            String[] ucl = cursorStmt.getUpdateColumns();
            if (ucl == null || ucl.length == 0) {
                this.getResultColumnList();
                afterColumns = this.resultSet.getResultColumns().expandToAll(this.targetTableDescriptor, this.targetTable.getTableName());
                this.getAffectedIndexes(this.targetTableDescriptor, null, null);
                allColumns = true;
            } else {
                this.resultSet.getResultColumns().checkColumnUpdateability(ucl, currentOfNode.getCursorName());
            }
        }
        this.changedColumnIds = this.getChangedColumnIds(this.resultSet.getResultColumns());
        if (!allColumns && this.targetVTI == null) {
            this.getCompilerContext().pushCurrentPrivType(-1);
            try {
                int i;
                this.readColsBitSet = new FormatableBitSet();
                FromBaseTable fbt = this.getResultColumnList(this.resultSet.getResultColumns());
                afterColumns = this.resultSet.getResultColumns().copyListAndObjects();
                this.readColsBitSet = this.getReadMap(dataDictionary, this.targetTableDescriptor, afterColumns);
                afterColumns = fbt.addColsToList(afterColumns, this.readColsBitSet);
                this.resultColumnList = fbt.addColsToList(this.resultColumnList, this.readColsBitSet);
                int size = this.targetTableDescriptor.getMaxColumnID();
                for (i = 1; i <= size && this.readColsBitSet.get(i); ++i) {
                }
                if (i > size) {
                    this.readColsBitSet = null;
                    allColumns = true;
                }
            }
            finally {
                this.getCompilerContext().popCurrentPrivType();
            }
        }
        if (this.targetVTI == null) {
            this.emptyHeapRow = this.targetTableDescriptor.getEmptyExecRow();
            this.resultColumnList.appendResultColumns(afterColumns, false);
            rowLocationNode = (CurrentRowLocationNode)this.getNodeFactory().getNode(2, this.getContextManager());
        } else {
            rowLocationNode = (NumericConstantNode)this.getNodeFactory().getNode(70, ReuseFactory.getInteger(0), this.getContextManager());
        }
        rowLocationColumn = (ResultColumn)this.getNodeFactory().getNode(80, COLUMNNAME, rowLocationNode, this.getContextManager());
        rowLocationColumn.markGenerated();
        this.resultColumnList.addResultColumn(rowLocationColumn);
        this.checkTableNameAndScrubResultColumns(this.resultColumnList);
        this.resultSet.setResultColumns(this.resultColumnList);
        this.getCompilerContext().pushCurrentPrivType(this.getPrivType());
        super.bindExpressions();
        this.getCompilerContext().popCurrentPrivType();
        this.resultSet.getResultColumns().bindUntypedNullsToResultColumns(this.resultColumnList);
        if (null != rowLocationColumn) {
            rowLocationColumn.bindResultColumnToExpression();
        }
        this.resultColumnList.checkStorableExpressions();
        if (!this.resultColumnList.columnTypesAndLengthsMatch()) {
            this.resultSet = this.resultSet.genNormalizeResultSetNode(true);
            this.resultColumnList.copyTypesAndLengthsToSource(this.resultSet.getResultColumns());
            if (this.hasCheckConstraints(dataDictionary, this.targetTableDescriptor)) {
                int afterColumnsSize = afterColumns.size();
                afterColumns = (ResultColumnList)this.getNodeFactory().getNode(9, this.getContextManager());
                ResultColumnList normalizedRCs = this.resultSet.getResultColumns();
                for (int index = 0; index < afterColumnsSize; ++index) {
                    afterColumns.addElement(normalizedRCs.elementAt(index + afterColumnsSize));
                }
            }
        }
        if (null != this.targetVTI) {
            this.deferred = VTIDeferModPolicy.deferIt(2, this.targetVTI, this.resultColumnList.getColumnNames(), sel.getWhereClause());
        } else {
            boolean hasTriggers = this.getAllRelevantTriggers(dataDictionary, this.targetTableDescriptor, this.changedColumnIds, true).size() > 0;
            this.checkConstraints = this.bindConstraints(dataDictionary, this.getNodeFactory(), this.targetTableDescriptor, null, hasTriggers ? this.resultColumnList : afterColumns, this.changedColumnIds, this.readColsBitSet, false, true);
            if (this.resultSet.subqueryReferencesTarget(this.targetTableDescriptor.getName(), true) || this.requiresDeferredProcessing()) {
                this.deferred = true;
            }
        }
        this.getCompilerContext().popCurrentPrivType();
    }

    @Override
    int getPrivType() {
        return 1;
    }

    @Override
    public boolean referencesSessionSchema() throws StandardException {
        return this.resultSet.referencesSessionSchema();
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        ConglomerateDescriptor updateCD;
        if (!this.deferred && (updateCD = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && updateCD.isIndex()) {
            int[] baseColumns = updateCD.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(baseColumns)) {
                this.deferred = true;
            }
        }
        if (null == this.targetTableDescriptor) {
            return this.getGenericConstantActionFactory().getUpdatableVTIConstantAction(2, this.deferred, this.changedColumnIds);
        }
        int lockMode = this.resultSet.updateTargetLockMode();
        long heapConglomId = this.targetTableDescriptor.getHeapConglomerateId();
        TransactionController tc = this.getLanguageConnectionContext().getTransactionCompile();
        StaticCompiledOpenConglomInfo[] indexSCOCIs = new StaticCompiledOpenConglomInfo[this.indexConglomerateNumbers.length];
        for (int index = 0; index < indexSCOCIs.length; ++index) {
            indexSCOCIs[index] = tc.getStaticCompiledConglomInfo(this.indexConglomerateNumbers[index]);
        }
        if (this.targetTableDescriptor.getLockGranularity() == 'T') {
            lockMode = 7;
        }
        return this.getGenericConstantActionFactory().getUpdateConstantAction(heapConglomId, this.targetTableDescriptor.getTableType(), tc.getStaticCompiledConglomInfo(heapConglomId), this.indicesToMaintain, this.indexConglomerateNumbers, indexSCOCIs, this.indexNames, this.emptyHeapRow, this.deferred, this.targetTableDescriptor.getUUID(), lockMode, false, this.changedColumnIds, null, null, this.getFKInfo(), this.getTriggerInfo(), this.readColsBitSet == null ? (FormatableBitSet)null : new FormatableBitSet(this.readColsBitSet), UpdateNode.getReadColMap(this.targetTableDescriptor.getNumberOfColumns(), this.readColsBitSet), this.resultColumnList.getStreamStorableColIds(this.targetTableDescriptor.getNumberOfColumns()), this.readColsBitSet == null ? this.targetTableDescriptor.getNumberOfColumns() : this.readColsBitSet.getNumBitsSet(), this.positionedUpdate, this.resultSet.isOneRowResultSet());
    }

    protected void setDeferredForUpdateOfIndexColumn() {
        ConglomerateDescriptor updateCD;
        if (!this.deferred && (updateCD = this.targetTable.getTrulyTheBestAccessPath().getConglomerateDescriptor()) != null && updateCD.isIndex()) {
            int[] baseColumns = updateCD.getIndexDescriptor().baseColumnPositions();
            if (this.resultSet.getResultColumns().updateOverlaps(baseColumns)) {
                this.deferred = true;
            }
        }
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        this.generateCodeForTemporaryTable(acb, acb.getExecuteMethod());
        if (!this.isDependentTable) {
            this.generateParameterValueSet(acb);
        }
        acb.newFieldDeclaration(2, "com.pivotal.gemfirexd.internal.iapi.sql.execute.CursorResultSet", acb.newRowLocationScanResultSetName());
        this.optimizeForOffHeap(true);
        acb.pushGetResultSetFactoryExpression(mb);
        this.resultSet.generate(acb, mb);
        if (null != this.targetVTI) {
            this.targetVTI.assignCostEstimate(this.resultSet.getNewCostEstimate());
            mb.callMethod((short)185, null, "getUpdateVTIResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 1);
        } else {
            this.generateCheckConstraints(this.checkConstraints, acb, mb);
            if (this.isDependentTable) {
                this.optimizeForOffHeap(false);
                mb.push(acb.addItem(this.makeConstantAction()));
                mb.push(acb.addItem(this.makeResultDescription()));
                mb.callMethod((short)185, null, "getDeleteCascadeUpdateResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 4);
            } else {
                mb.callMethod((short)185, null, "getUpdateResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 2);
            }
        }
    }

    @Override
    public final int getStatementType() {
        return 3;
    }

    public FormatableBitSet getReadMap(DataDictionary dd, TableDescriptor baseTable, ResultColumnList updateColumnList) throws StandardException {
        boolean[] needsDeferredProcessing = new boolean[]{this.requiresDeferredProcessing()};
        Vector conglomVector = new Vector();
        this.relevantCdl = new ConstraintDescriptorList();
        this.relevantTriggers = new GenericDescriptorList();
        FormatableBitSet columnMap = UpdateNode.getUpdateReadMap(baseTable, updateColumnList, conglomVector, this.relevantCdl, this.relevantTriggers, needsDeferredProcessing);
        this.markAffectedIndexes(conglomVector);
        this.adjustDeferredFlag(needsDeferredProcessing[0]);
        return columnMap;
    }

    private int[] getChangedColumnIds(ResultColumnList rcl) {
        if (rcl == null) {
            return null;
        }
        return rcl.sortMe();
    }

    public static FormatableBitSet getUpdateReadMap(TableDescriptor baseTable, ResultColumnList updateColumnList, Vector conglomVector, ConstraintDescriptorList relevantConstraints, GenericDescriptorList relevantTriggers, boolean[] needsDeferredProcessing) throws StandardException {
        SanityManager.ASSERT((updateColumnList != null ? 1 : 0) != 0, (String)"updateColumnList is null");
        int columnCount = baseTable.getMaxColumnID();
        FormatableBitSet columnMap = new FormatableBitSet(columnCount + 1);
        int[] changedColumnIds = updateColumnList.sortMe();
        for (int ix = 0; ix < changedColumnIds.length; ++ix) {
            columnMap.set(changedColumnIds[ix]);
        }
        DMLModStatementNode.getXAffectedIndexes(baseTable, updateColumnList, columnMap, conglomVector);
        baseTable.getAllRelevantConstraints(3, false, changedColumnIds, needsDeferredProcessing, relevantConstraints);
        int rclSize = relevantConstraints.size();
        for (int index = 0; index < rclSize; ++index) {
            ConstraintDescriptor cd = relevantConstraints.elementAt(index);
            if (cd.getConstraintType() != 4) continue;
            int[] refColumns = ((CheckConstraintDescriptor)cd).getReferencedColumns();
            for (int i = 0; i < refColumns.length; ++i) {
                columnMap.set(refColumns[i]);
            }
        }
        baseTable.getAllRelevantTriggers(3, changedColumnIds, relevantTriggers);
        if (relevantTriggers.size() > 0) {
            needsDeferredProcessing[0] = true;
        }
        if (relevantTriggers.size() > 0) {
            for (int i = 1; i <= columnCount; ++i) {
                columnMap.set(i);
            }
        }
        return columnMap;
    }

    private void normalizeCorrelatedColumns(ResultColumnList rcl, FromTable fromTable) throws StandardException {
        String correlationName = fromTable.getCorrelationName();
        if (correlationName == null) {
            return;
        }
        TableName tableNameNode = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        int count = rcl.size();
        for (int i = 0; i < count; ++i) {
            ResultColumn column = (ResultColumn)rcl.elementAt(i);
            ColumnReference reference = column.getReference();
            if (reference == null || !correlationName.equals(reference.getTableName())) continue;
            reference.setTableNameNode(tableNameNode);
        }
    }

    private void checkTableNameAndScrubResultColumns(ResultColumnList rcl) throws StandardException {
        int columnCount = rcl.size();
        int tableCount = ((SelectNode)this.resultSet).fromList.size();
        for (int i = 0; i < columnCount; ++i) {
            boolean foundMatchingTable = false;
            ResultColumn column = (ResultColumn)rcl.elementAt(i);
            if (column.getTableName() != null) {
                for (int j = 0; j < tableCount; ++j) {
                    FromTable fromTable = (FromTable)((SelectNode)this.resultSet).fromList.elementAt(j);
                    String tableName = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName().getTableName() : fromTable.getBaseTableName();
                    if (!column.getTableName().equals(tableName)) continue;
                    foundMatchingTable = true;
                    break;
                }
                if (!foundMatchingTable) {
                    throw StandardException.newException("42X04", column.getTableName() + "." + column.getName());
                }
            }
            column.clearTableName();
        }
    }

    private void normalizeSynonymColumns(ResultColumnList rcl, FromTable fromTable) throws StandardException {
        if (fromTable.getCorrelationName() != null) {
            return;
        }
        TableName tableNameNode = fromTable instanceof CurrentOfNode ? ((CurrentOfNode)fromTable).getBaseCursorTargetTableName() : this.makeTableName(null, fromTable.getBaseTableName());
        super.normalizeSynonymColumns(rcl, tableNameNode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public QueryInfo computeQueryInfo(QueryInfoContext qic) throws StandardException {
        try {
            UpdateQueryInfo info = new UpdateQueryInfo(qic);
            info.visit(this);
            info.init();
            UpdateQueryInfo updateQueryInfo = info;
            return updateQueryInfo;
        }
        finally {
            qic.cleanUp();
        }
    }

    public int getTargetTableID() {
        return this.targetTable instanceof FromBaseTable ? ((FromBaseTable)this.targetTable).getTableNumber() : -1;
    }
}

