/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.CostEstimate;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizable;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.OptimizablePredicateList;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.Optimizer;
import com.pivotal.gemfirexd.internal.iapi.sql.compile.RowOrdering;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.util.JBitSet;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromTable;
import com.pivotal.gemfirexd.internal.impl.sql.compile.PredicateList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultColumnList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.RowResultSetNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SelectNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SetOperatorNode;

public class UnionNode
extends SetOperatorNode {
    private boolean addNewNodesCalled;
    boolean tableConstructor;
    boolean topTableConstructor;

    @Override
    public void init(Object leftResult, Object rightResult, Object all, Object tableConstructor, Object tableProperties) throws StandardException {
        super.init(leftResult, rightResult, all, tableProperties);
        this.tableConstructor = (Boolean)tableConstructor;
    }

    public void markTopTableConstructor() {
        this.topTableConstructor = true;
    }

    boolean tableConstructor() {
        return this.tableConstructor;
    }

    @Override
    public void rejectParameters() throws StandardException {
        if (!this.tableConstructor()) {
            super.rejectParameters();
        }
    }

    @Override
    void setTableConstructorTypes(ResultColumnList typeColumns) throws StandardException {
        SanityManager.ASSERT((this.resultColumns.size() <= typeColumns.size() ? 1 : 0) != 0, (String)"More columns in ResultColumnList than in base table.");
        if (this.tableConstructor()) {
            ResultSetNode rsn = this;
            while (rsn instanceof UnionNode) {
                UnionNode union = rsn;
                SanityManager.ASSERT((boolean)(union.rightResultSet instanceof RowResultSetNode), (String)("A " + union.rightResultSet.getClass().getName() + " is on the right of a union in a table constructor"));
                ((RowResultSetNode)union.rightResultSet).setTableConstructorTypes(typeColumns);
                rsn = union.leftResultSet;
            }
            SanityManager.ASSERT((boolean)(rsn instanceof RowResultSetNode), (String)("A " + rsn.getClass().getName() + " is at the left end of a table constructor"));
            ((RowResultSetNode)rsn).setTableConstructorTypes(typeColumns);
        }
    }

    @Override
    public CostEstimate optimizeIt(Optimizer optimizer, OptimizablePredicateList predList, CostEstimate outerCost, RowOrdering rowOrdering) throws StandardException {
        if (predList != null && !this.getCurrentAccessPath().getJoinStrategy().isHashJoin()) {
            for (int i = predList.size() - 1; i >= 0; --i) {
                if (!this.pushOptPredicate(predList.getOptPredicate(i))) continue;
                predList.removeOptPredicate(i);
            }
        }
        this.updateBestPlanMap((short)1, this);
        this.leftResultSet = this.optimizeSource(optimizer, this.leftResultSet, this.getLeftOptPredicateList(), outerCost);
        this.rightResultSet = this.optimizeSource(optimizer, this.rightResultSet, this.getRightOptPredicateList(), outerCost);
        CostEstimate costEstimate = this.getCostEstimate(optimizer);
        costEstimate.setCost(this.leftResultSet.getCostEstimate().getEstimatedCost(), this.leftResultSet.getCostEstimate().rowCount(), this.leftResultSet.getCostEstimate().singleScanRowCount() + this.rightResultSet.getCostEstimate().singleScanRowCount());
        costEstimate.add(this.rightResultSet.costEstimate, costEstimate);
        this.getCurrentAccessPath().getJoinStrategy().estimateCost(this, predList, null, outerCost, optimizer, costEstimate);
        optimizer.considerCost(this, predList, costEstimate, outerCost);
        return costEstimate;
    }

    @Override
    public void pushExpressions(PredicateList predicateList) throws StandardException {
        if (this.leftResultSet instanceof UnionNode) {
            ((UnionNode)this.leftResultSet).pushExpressions(predicateList);
        } else if (this.leftResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.leftResultSet, true);
        }
        if (this.rightResultSet instanceof UnionNode) {
            ((UnionNode)this.rightResultSet).pushExpressions(predicateList);
        } else if (this.rightResultSet instanceof SelectNode) {
            predicateList.pushExpressionsIntoSelect((SelectNode)this.rightResultSet, true);
        }
    }

    @Override
    public Optimizable modifyAccessPath(JBitSet outerTables) throws StandardException {
        Optimizable retOptimizable = super.modifyAccessPath(outerTables);
        if (this.addNewNodesCalled) {
            return retOptimizable;
        }
        return (Optimizable)((Object)this.addNewNodes());
    }

    @Override
    public ResultSetNode modifyAccessPaths() throws StandardException {
        ResultSetNode retRSN = super.modifyAccessPaths();
        if (this.addNewNodesCalled) {
            return retRSN;
        }
        return this.addNewNodes();
    }

    private ResultSetNode addNewNodes() throws StandardException {
        ResultSetNode treeTop = this;
        if (this.addNewNodesCalled) {
            return this;
        }
        this.addNewNodesCalled = true;
        if (!this.all) {
            if (!this.columnTypesAndLengthsMatch()) {
                treeTop = this.genNormalizeResultSetNode(false);
            }
            treeTop = (ResultSetNode)this.getNodeFactory().getNode(124, treeTop.genProjectRestrict(), Boolean.FALSE, this.tableProperties, this.getContextManager());
            ((FromTable)treeTop).setTableNumber(this.tableNumber);
            treeTop.setReferencedTableMap((JBitSet)this.referencedTableMap.clone());
            this.all = true;
        }
        if (this.orderByList != null) {
            treeTop = (ResultSetNode)this.getNodeFactory().getNode(140, treeTop, this.orderByList, this.tableProperties, this.getContextManager());
        }
        return treeTop;
    }

    @Override
    public String toString() {
        return "tableConstructor: " + this.tableConstructor + "\n" + super.toString();
    }

    @Override
    public void bindExpressions(FromList fromListParam) throws StandardException {
        super.bindExpressions(fromListParam);
        if (this.topTableConstructor && !this.insertSource) {
            RowResultSetNode rrsn;
            SetOperatorNode setOperator;
            DataTypeDescriptor[] types = new DataTypeDescriptor[this.leftResultSet.getResultColumns().size()];
            int numTypes = 0;
            ResultSetNode rsn = this;
            while (rsn instanceof SetOperatorNode) {
                setOperator = rsn;
                SanityManager.ASSERT((boolean)(setOperator.rightResultSet instanceof RowResultSetNode), (String)("A " + setOperator.rightResultSet.getClass().getName() + " is on the right side of a setOperator in a table constructor"));
                rrsn = (RowResultSetNode)setOperator.rightResultSet;
                numTypes += this.getParamColumnTypes(types, rrsn);
                rsn = setOperator.leftResultSet;
            }
            SanityManager.ASSERT((boolean)(rsn instanceof RowResultSetNode));
            if ((numTypes += this.getParamColumnTypes(types, (RowResultSetNode)rsn)) < types.length) {
                throw StandardException.newException("42Y10");
            }
            rsn = this;
            while (rsn instanceof SetOperatorNode) {
                setOperator = rsn;
                rrsn = (RowResultSetNode)setOperator.rightResultSet;
                this.setParamColumnTypes(types, rrsn);
                rsn = setOperator.leftResultSet;
            }
            this.setParamColumnTypes(types, (RowResultSetNode)rsn);
        }
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        SanityManager.ASSERT((boolean)this.all, (String)"all expected to be true");
        this.assignResultSetNumber();
        this.costEstimate = this.getFinalCostEstimate();
        acb.pushGetResultSetFactoryExpression(mb);
        this.leftResultSet.generate(acb, mb);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.leftResultSet.getResultColumns())) {
            acb.pushGetResultSetFactoryExpression(mb);
            mb.swap();
            this.generateNormalizationResultSet(acb, mb, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        this.rightResultSet.generate(acb, mb);
        if (!this.resultColumns.isExactTypeAndLengthMatch(this.rightResultSet.getResultColumns())) {
            acb.pushGetResultSetFactoryExpression(mb);
            mb.swap();
            this.generateNormalizationResultSet(acb, mb, this.getCompilerContext().getNextResultSetNumber(), this.makeResultDescription());
        }
        mb.push(this.resultSetNumber);
        mb.push(this.costEstimate.rowCount());
        mb.push(this.costEstimate.getEstimatedCost());
        mb.callMethod((short)185, null, "getUnionResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.execute.NoPutResultSet", 5);
    }

    @Override
    public CostEstimate getFinalCostEstimate() throws StandardException {
        if (this.finalCostEstimate != null) {
            return this.finalCostEstimate;
        }
        CostEstimate leftCE = this.leftResultSet.getFinalCostEstimate();
        CostEstimate rightCE = this.rightResultSet.getFinalCostEstimate();
        this.finalCostEstimate = this.getNewCostEstimate();
        this.finalCostEstimate.setCost(leftCE.getEstimatedCost(), leftCE.rowCount(), leftCE.singleScanRowCount() + rightCE.singleScanRowCount());
        this.finalCostEstimate.add(rightCE, this.finalCostEstimate);
        return this.finalCostEstimate;
    }

    @Override
    String getOperatorName() {
        return "UNION";
    }

    @Override
    protected void optimizeForOffHeap(boolean shouldOptimize) {
        this.leftResultSet.optimizeForOffHeap(shouldOptimize);
        this.rightResultSet.optimizeForOffHeap(shouldOptimize);
    }
}

