/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.DataTypeDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor;
import com.pivotal.gemfirexd.internal.iapi.types.DataValueFactory;
import com.pivotal.gemfirexd.internal.iapi.types.DateTimeDataValue;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.FromList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.SubqueryList;
import com.pivotal.gemfirexd.internal.impl.sql.compile.UnaryOperatorNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ValueNode;
import java.util.Vector;

public class UnaryDateTimestampOperatorNode
extends UnaryOperatorNode {
    private static final String TIMESTAMP_METHOD_NAME = "getTimestamp";
    private static final String DATE_METHOD_NAME = "getDate";

    @Override
    public void init(Object operand, Object targetType) throws StandardException {
        this.setType((DataTypeDescriptor)targetType);
        switch (this.getTypeServices().getJDBCTypeId()) {
            case 91: {
                super.init(operand, "date", DATE_METHOD_NAME);
                break;
            }
            case 93: {
                super.init(operand, "timestamp", TIMESTAMP_METHOD_NAME);
                break;
            }
            default: {
                SanityManager.NOTREACHED();
                super.init(operand);
            }
        }
    }

    @Override
    public ValueNode bindExpression(FromList fromList, SubqueryList subqueryList, Vector aggregateVector) throws StandardException {
        boolean isIdentity = false;
        boolean operandIsNumber = false;
        this.bindOperand(fromList, subqueryList, aggregateVector);
        DataTypeDescriptor operandType = this.operand.getTypeServices();
        switch (operandType.getJDBCTypeId()) {
            case -6: 
            case -5: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 8: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                operandIsNumber = true;
                break;
            }
            case 1: 
            case 12: {
                break;
            }
            case 91: {
                if (TIMESTAMP_METHOD_NAME.equals(this.methodName)) {
                    this.invalidOperandType();
                }
                isIdentity = true;
                break;
            }
            case 0: {
                break;
            }
            case 93: {
                if (!TIMESTAMP_METHOD_NAME.equals(this.methodName)) break;
                isIdentity = true;
                break;
            }
            default: {
                this.invalidOperandType();
            }
        }
        if (this.operand instanceof ConstantNode) {
            DataValueFactory dvf = this.getLanguageConnectionContext().getDataValueFactory();
            DataValueDescriptor sourceValue = ((ConstantNode)this.operand).getValue();
            DateTimeDataValue destValue = null;
            destValue = sourceValue.isNull() ? (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dvf.getNullTimestamp(null) : dvf.getNullDate(null)) : (TIMESTAMP_METHOD_NAME.equals(this.methodName) ? dvf.getTimestamp(sourceValue) : dvf.getDate(sourceValue));
            return (ValueNode)this.getNodeFactory().getNode(76, destValue, this.getContextManager());
        }
        if (isIdentity) {
            return this.operand;
        }
        return this;
    }

    private void invalidOperandType() throws StandardException {
        throw StandardException.newException("42X25", (Object)this.getOperatorString(), (Object)this.getOperand().getTypeServices().getSQLstring());
    }

    @Override
    public void generateExpression(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushDataValueFactory(mb);
        this.operand.generateExpression(acb, mb);
        mb.cast("com.pivotal.gemfirexd.internal.iapi.types.DataValueDescriptor");
        mb.callMethod((short)185, null, this.methodName, this.getTypeCompiler().interfaceName(), 1);
    }
}

