/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.sql.execute.ConstantAction;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ActivationClassBuilder;
import com.pivotal.gemfirexd.internal.impl.sql.compile.TransactionStatementNode;

public class SetTransactionIsolationNode
extends TransactionStatementNode {
    private int isolationLevel;

    @Override
    public void init(Object isolationLevel) {
        this.isolationLevel = (Integer)isolationLevel;
    }

    @Override
    public String toString() {
        return "isolationLevel: " + this.isolationLevel + "\n" + super.toString();
    }

    @Override
    public String statementToString() {
        return "SET TRANSACTION ISOLATION";
    }

    @Override
    public void generate(ActivationClassBuilder acb, MethodBuilder mb) throws StandardException {
        acb.pushGetResultSetFactoryExpression(mb);
        acb.pushThisAsActivation(mb);
        mb.callMethod((short)185, null, "getSetTransactionResultSet", "com.pivotal.gemfirexd.internal.iapi.sql.ResultSet", 1);
    }

    @Override
    public ConstantAction makeConstantAction() throws StandardException {
        return this.getGenericConstantActionFactory().getSetTransactionIsolationConstantAction(this.isolationLevel);
    }
}

