/*
 * Decompiled with CFR 0.152.
 */
package com.pivotal.gemfirexd.internal.impl.sql.compile;

import com.pivotal.gemfirexd.internal.iapi.error.StandardException;
import com.pivotal.gemfirexd.internal.iapi.services.compiler.MethodBuilder;
import com.pivotal.gemfirexd.internal.iapi.services.sanity.SanityManager;
import com.pivotal.gemfirexd.internal.iapi.types.TypeId;
import com.pivotal.gemfirexd.internal.iapi.util.ReuseFactory;
import com.pivotal.gemfirexd.internal.iapi.util.StringUtil;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ConstantNode;
import com.pivotal.gemfirexd.internal.impl.sql.compile.ExpressionClassBuilder;

public class SQLBooleanConstantNode
extends ConstantNode {
    @Override
    public void init(Object newValue) throws StandardException {
        String strVal = (String)newValue;
        Boolean val = null;
        SanityManager.ASSERT((StringUtil.SQLEqualsIgnoreCase(strVal, "true") || StringUtil.SQLEqualsIgnoreCase(strVal, "false") || StringUtil.SQLEqualsIgnoreCase(strVal, "unknown") ? 1 : 0) != 0, (String)("String \"" + strVal + "\" cannot be converted to a SQLBoolean"));
        if (StringUtil.SQLEqualsIgnoreCase(strVal, "true")) {
            val = Boolean.TRUE;
        } else if (StringUtil.SQLEqualsIgnoreCase(strVal, "false")) {
            val = Boolean.FALSE;
        }
        super.init(TypeId.BOOLEAN_ID, Boolean.TRUE, ReuseFactory.getInteger(1));
        if (val == null) {
            this.setValue(this.getTypeServices().getNull());
        } else {
            this.setValue(this.getDataValueFactory().getDataValue((boolean)val));
        }
    }

    @Override
    void generateConstant(ExpressionClassBuilder acb, MethodBuilder mb) throws StandardException {
        mb.push(this.value.getBoolean());
    }
}

